/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class Task
extends Suggestion
implements Cloneable,
Node.Cookie {
    private static final Logger LOGGER;
    static final String PROP_ATTRS_CHANGED = "attrs";
    protected EventListenerList listeners = new EventListenerList();
    private boolean visitable;
    protected boolean silentUpdate = false;
    private Task parent;
    private Object key;
    private List subtasks = null;
    private List subtasksCopy;
    private boolean zombie = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Task() {
        super(null, null, null, null);
        this.parent = null;
        this.visitable = true;
        this.key = new Object();
    }

    public Task(String desc, Task parent) {
        super(null, null, desc, null);
        this.parent = parent;
        this.visitable = true;
        this.key = new Object();
    }

    public int indexOf(Task t) {
        if (!this.hasSubtasks()) {
            return -1;
        }
        return this.subtasks.indexOf(t);
    }

    public void clear() {
        if (this.hasSubtasks()) {
            this.subtasks.clear();
            this.subtasksCopy = null;
            this.fireStructureChanged();
        }
    }

    public int getLevel() {
        int level = 0;
        for (Task t = this.getParent(); t != null; t = t.getParent()) {
            ++level;
        }
        return level;
    }

    public void setSummary(String ndesc) {
        super.setSummary(ndesc);
    }

    public void setDetails(String ndesc) {
        super.setDetails(ndesc);
    }

    public void setPriority(SuggestionPriority priority) {
        super.setPriority(priority);
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!this.silentUpdate) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void addTaskListener(TaskListener l) {
        if (LOGGER.isLoggable(Level.FINE)) {
            Thread.dumpStack();
        }
        this.listeners.add(TaskListener.class, l);
    }

    public void removeTaskListener(TaskListener l) {
        if (LOGGER.isLoggable(Level.FINE)) {
            Thread.dumpStack();
        }
        this.listeners.remove(TaskListener.class, l);
    }

    protected final void fireStructureChanged() {
        if (this.silentUpdate) {
            return;
        }
        Object[] l = this.listeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != (class$org$netbeans$modules$tasklist$core$TaskListener == null ? Task.class$("org.netbeans.modules.tasklist.core.TaskListener") : class$org$netbeans$modules$tasklist$core$TaskListener)) continue;
            ((TaskListener)l[i + 1]).structureChanged(this);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).structureChanged(this);
        }
    }

    protected final void fireAddedTask(Task t) {
        if (this.silentUpdate) {
            return;
        }
        Object[] l = this.listeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != (class$org$netbeans$modules$tasklist$core$TaskListener == null ? Task.class$("org.netbeans.modules.tasklist.core.TaskListener") : class$org$netbeans$modules$tasklist$core$TaskListener)) continue;
            ((TaskListener)l[i + 1]).addedTask(t);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).addedTask(t);
        }
    }

    protected final void fireRemovedTask(Task t, int index) {
        if (this.silentUpdate) {
            return;
        }
        Object[] l = this.listeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != (class$org$netbeans$modules$tasklist$core$TaskListener == null ? Task.class$("org.netbeans.modules.tasklist.core.TaskListener") : class$org$netbeans$modules$tasklist$core$TaskListener)) continue;
            ((TaskListener)l[i + 1]).removedTask(this, t, index);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).removedTask(this, t, index);
        }
    }

    protected void recursivePropertyChange() {
        this.firePropertyChange(PROP_ATTRS_CHANGED, null, null);
        if (this.subtasks != null) {
            Iterator it = this.getSubtasks().iterator();
            while (it.hasNext()) {
                Task item = (Task)it.next();
                item.recursivePropertyChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getSubtasks() {
        if (this.subtasks == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.subtasksCopy == null) {
            List list = this.subtasks;
            synchronized (list) {
                this.subtasksCopy = Collections.unmodifiableList(new ArrayList(this.subtasks));
            }
        }
        return this.subtasksCopy;
    }

    public final Iterator subtasksIterator() {
        return this.getSubtasks().iterator();
    }

    public final int subtasksCount() {
        if (this.subtasks == null) {
            return 0;
        }
        return this.subtasks.size();
    }

    public final boolean containsSubtask(Task task) {
        if (this.subtasks == null) {
            return false;
        }
        return this.subtasks.contains(task);
    }

    public void addSubtask(Task subtask) {
        this.addSubtask(subtask, false);
    }

    public void addSubtask(Task subtask, Task after) {
        subtask.parent = this;
        if (this.subtasks == null) {
            ErrorManager.getDefault().log("addSubtask(subtask,after) called where subtasks==null");
            return;
        }
        int pos = this.subtasks.indexOf(after);
        this.subtasks.add(pos + 1, subtask);
        this.subtasksCopy = null;
        this.fireAddedTask(subtask);
    }

    public void addSubtasks(List tasks, boolean append, Task after) {
        ListIterator it = tasks.listIterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            task.parent = this;
        }
        if (this.subtasks == null) {
            this.subtasks = Collections.synchronizedList(new LinkedList());
        }
        if (after != null) {
            int pos = this.subtasks.indexOf(after);
            this.subtasks.addAll(pos + 1, tasks);
        } else if (append) {
            this.subtasks.addAll(tasks);
        } else {
            this.subtasks.addAll(0, tasks);
        }
        this.subtasksCopy = null;
        this.fireStructureChanged();
    }

    public void addSubtask(Task subtask, boolean append) {
        subtask.parent = this;
        if (this.subtasks == null) {
            this.subtasks = Collections.synchronizedList(new LinkedList());
        }
        if (this.subtasks.contains(subtask)) {
            return;
        }
        if (append) {
            this.subtasks.add(subtask);
        } else {
            this.subtasks.add(0, subtask);
        }
        this.subtasksCopy = null;
        this.fireAddedTask(subtask);
    }

    public void removeSubtask(Task subtask) {
        subtask.zombie = true;
        if (this.subtasks == null) {
            return;
        }
        int index = this.subtasks.indexOf(subtask);
        this.subtasks.remove(index);
        if (this.subtasks.size() == 0) {
            this.subtasks = null;
        }
        this.subtasksCopy = null;
        this.fireRemovedTask(subtask, index);
    }

    public final boolean hasSubtasks() {
        return this.subtasks != null && this.subtasks.size() != 0;
    }

    public final Task getParent() {
        return this.parent;
    }

    public final Task getRoot() {
        Task parent = this.getParent();
        if (parent != null) {
            return parent.getRoot();
        }
        return this;
    }

    public final boolean isParentOf(Task task) {
        if (task.getKey() == this.getKey()) {
            return true;
        }
        Task nextLevel = task.getParent();
        if (nextLevel == null) {
            return false;
        }
        return this.isParentOf(nextLevel);
    }

    public boolean isZombie() {
        return this.zombie;
    }

    public static void generate(Task item, Writer w) throws IOException {
        w.write(item.getSummary());
    }

    public static Task parse(Reader r) throws IOException {
        LOGGER.fine("parsing");
        BufferedReader reader = new BufferedReader(r);
        String line = reader.readLine();
        if (line != null) {
            Task item = new Task();
            item.setSummary(line);
            return item;
        }
        return null;
    }

    public void setSilentUpdate(boolean silentUpdate, boolean fireChildren) {
        this.silentUpdate = silentUpdate;
        if (!silentUpdate && fireChildren) {
            this.fireStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubtaskCountRecursively() {
        if (this.subtasks == null) {
            return 0;
        }
        int n = 0;
        List list = this.subtasks;
        synchronized (list) {
            Iterator it = this.subtasks.iterator();
            while (it.hasNext()) {
                Task t = (Task)it.next();
                n += t.getSubtaskCountRecursively() + 1;
            }
            return n;
        }
    }

    public Node[] createNode() {
        if (this.subtasks != null) {
            return new Node[]{new TaskNode(this, (Children)new TaskChildren(this))};
        }
        return new Node[]{new TaskNode(this)};
    }

    protected Object clone() {
        Task t = new Task();
        t.copyFrom(this);
        return t;
    }

    final Task cloneTask() {
        Task clone = (Task)this.clone();
        clone.parent = null;
        return clone;
    }

    public final Object getKey() {
        return this.key;
    }

    public Object getSeed() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFrom(Task from) {
        this.visitable = from.visitable;
        this.zombie = from.zombie;
        if (!$assertionsDisabled && from.key == null) {
            throw new AssertionError();
        }
        this.key = from.key;
        super.setSummary(from.getSummary());
        super.setPriority(from.getPriority());
        super.setIcon(from.getIcon());
        super.setType(from.getType());
        super.setLine(from.getLine());
        super.setAction(from.getAction());
        super.setDetails(from.getDetails());
        this.parent = from.parent;
        if (from.subtasks != null) {
            List list = from.subtasks;
            synchronized (list) {
                Iterator it = from.subtasks.iterator();
                this.subtasks = Collections.synchronizedList(new LinkedList());
                while (it.hasNext()) {
                    Task task = (Task)it.next();
                    Task mycopy = (Task)task.clone();
                    mycopy.parent = this;
                    this.subtasks.add(mycopy);
                }
                this.subtasksCopy = null;
            }
        }
    }

    static {
        $assertionsDisabled = !Task.class.desiredAssertionStatus();
        LOGGER = TLUtils.getLogger(Task.class);
        LOGGER.setLevel(Level.OFF);
    }
}

