/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class UUEncoderStream
extends FilterOutputStream {
    private byte[] buffer;
    private int bufsize = 0;
    private boolean wrotePrefix = false;
    protected String name;
    protected int mode;

    public UUEncoderStream(OutputStream outputStream) {
        this(outputStream, "encoder.buf", 644);
    }

    public UUEncoderStream(OutputStream outputStream, String string) {
        this(outputStream, string, 644);
    }

    public UUEncoderStream(OutputStream outputStream, String string, int n) {
        super(outputStream);
        this.name = string;
        this.mode = n;
        this.buffer = new byte[45];
    }

    public void setNameMode(String string, int n) {
        this.name = string;
        this.mode = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        this.buffer[this.bufsize++] = (byte)n;
        if (this.bufsize == 45) {
            this.writePrefix();
            this.encode();
            this.bufsize = 0;
        }
    }

    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.writePrefix();
            this.encode();
        }
        this.writeSuffix();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void writePrefix() throws IOException {
        if (!this.wrotePrefix) {
            PrintStream printStream = new PrintStream(this.out);
            printStream.println("begin " + this.mode + " " + this.name);
            printStream.flush();
            this.wrotePrefix = true;
        }
    }

    private void writeSuffix() throws IOException {
        PrintStream printStream = new PrintStream(this.out);
        printStream.println(" \nend");
        printStream.flush();
    }

    private void encode() throws IOException {
        int n = 0;
        this.out.write((this.bufsize & 0x3F) + 32);
        while (n < this.bufsize) {
            byte by;
            byte by2;
            byte by3 = this.buffer[n++];
            if (n < this.bufsize) {
                by2 = this.buffer[n++];
                by = n < this.bufsize ? this.buffer[n++] : (byte)1;
            } else {
                by2 = 1;
                by = 1;
            }
            int n2 = by3 >>> 2 & 0x3F;
            int n3 = by3 << 4 & 0x30 | by2 >>> 4 & 0xF;
            int n4 = by2 << 2 & 0x3C | by >>> 6 & 3;
            int n5 = by & 0x3F;
            this.out.write(n2 + 32);
            this.out.write(n3 + 32);
            this.out.write(n4 + 32);
            this.out.write(n5 + 32);
        }
        this.out.write(10);
    }
}

