/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.j2ee.verification.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesRepository {
    private Collection<Rule> clazzRules = new ArrayList<Rule>();
    private Collection<Rule> constructorRules = new ArrayList<Rule>();
    private Collection<Rule> fieldRules = new ArrayList<Rule>();
    private Collection<Rule> methodRules = new ArrayList<Rule>();
    private Collection<Rule> annotationRules = new ArrayList<Rule>();

    public Collection<Rule> getClazzRules() {
        return Collections.unmodifiableCollection(this.clazzRules);
    }

    public Collection<Rule> getConstructorRules() {
        return Collections.unmodifiableCollection(this.constructorRules);
    }

    public Collection<Rule> getFieldRules() {
        return Collections.unmodifiableCollection(this.fieldRules);
    }

    public Collection<Rule> getMethodRules() {
        return Collections.unmodifiableCollection(this.methodRules);
    }

    public Collection<Rule> getAnnotationRules() {
        return this.annotationRules;
    }

    public void registerClazzRule(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.clazzRules.add((Rule)Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerFieldRule(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.fieldRules.add((Rule)Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerConstructorRule(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.constructorRules.add((Rule)Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerMethodRule(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.methodRules.add((Rule)Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerAnnotationRule(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.annotationRules.add((Rule)Rule.class.cast(Class.forName(className).newInstance()));
    }
}

