/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.httpfs.HTTPFileObject;
import org.netbeans.modules.javadoc.httpfs.HTTPFileSystem;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class HTTPRootFileObject
extends HTTPFileObject
implements Runnable {
    private static final String IDE_SETTINGS_NAME = "Services/org-netbeans-core-IDESettings.settings";
    private Thread refreshThread;
    private Date lastRefreshDate;
    private boolean threadIsRunning;
    private boolean refreshPending;
    private static boolean proxyInit;

    HTTPRootFileObject(HTTPFileSystem parentFileSystem) {
        super("/", parentFileSystem);
        this.refreshThread = new Thread(this);
        this.threadIsRunning = true;
        this.refreshPending = false;
        this.refreshThread.start();
    }

    protected HTTPRootFileObject() {
    }

    void triggerRefresh() {
        this.refreshPending = true;
        this.refreshThread.interrupt();
    }

    public void run() {
        this.refreshRootContents();
        this.refreshThread.setPriority(1);
        while (this.threadIsRunning) {
            boolean docsHaveChanged = false;
            int refreshInterval = this.parentFileSystem.getRefreshRate();
            if (refreshInterval > 0) {
                GregorianCalendar nextRefreshTime = new GregorianCalendar();
                nextRefreshTime.setTime(this.lastRefreshDate);
                ((Calendar)nextRefreshTime).add(12, refreshInterval);
                if (nextRefreshTime.before(new GregorianCalendar())) {
                    docsHaveChanged = this.hasDocumentationChanged();
                }
            }
            if (docsHaveChanged || this.refreshPending) {
                this.refreshPending = false;
                this.refreshRootContents();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {}
        }
    }

    private boolean hasDocumentationChanged() {
        boolean hasChanged;
        HTTPFileObject packageFile = this.child("package-list", false);
        if (packageFile != null) {
            try {
                Date currentPackageFileDate = packageFile.lastModified();
                HttpURLConnection fileConnection = (HttpURLConnection)packageFile.fileURL.openConnection();
                fileConnection.setRequestMethod("HEAD");
                hasChanged = currentPackageFileDate.before(new Date(fileConnection.getLastModified()));
                fileConnection.disconnect();
            }
            catch (IOException e) {
                hasChanged = false;
            }
        } else {
            hasChanged = true;
        }
        return hasChanged;
    }

    private void refreshRootContents() {
        HTTPRootFileObject.initHTTPProxyHack();
        this.parentFileSystem.setState(1);
        this.removeAllChildren();
        if (this.addOptionalChild("/package-list")) {
            HTTPFileObject packageFile = this.child("package-list", false);
            this.addChild("/allclasses-frame.html");
            this.addOptionalChild("/deprecated-list.html");
            this.addOptionalChild("/help-doc.html");
            this.addOptionalChild("/index.html");
            this.addChild("/overview-frame.html");
            this.addChild("/overview-summary.html");
            this.addOptionalChild("/overview-tree.html");
            this.addChild("/packages.html");
            this.addChild("/serialized-form.html");
            this.addChild("/stylesheet.css");
            if (!this.addOptionalChild("/index-all.html")) {
                int indexFileNumber = 1;
                while (this.addOptionalChild("/index-" + indexFileNumber + ".html")) {
                    ++indexFileNumber;
                }
                if (indexFileNumber == 1) {
                    HTTPFileObject indexDirectory = new HTTPFileObject("/index-files/", this.parentFileSystem);
                    if (!indexDirectory.addOptionalChild("/index-files/index-all.html")) {
                        indexFileNumber = 1;
                        while (indexDirectory.addOptionalChild("/index-files/index-" + indexFileNumber + ".html")) {
                            ++indexFileNumber;
                        }
                        if (indexFileNumber != 1) {
                            this.addChild(indexDirectory);
                        }
                    } else {
                        this.addChild(indexDirectory);
                    }
                }
            }
            try {
                BufferedReader packageReader = new BufferedReader(new InputStreamReader(packageFile.getInputStream()));
                String packageName = packageReader.readLine();
                while (packageName != null) {
                    this.addPackage(packageName);
                    packageName = packageReader.readLine();
                }
                packageReader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.lastRefreshDate = new Date();
        this.parentFileSystem.setState(2);
    }

    private void addPackage(String packageName) {
        StringTokenizer packageParser = new StringTokenizer(packageName, ".");
        HTTPFileObject packageDirectory = this;
        while (packageParser.hasMoreElements()) {
            String packagePart = (String)packageParser.nextElement();
            if (packageDirectory.child(packagePart, false) == null) {
                packageDirectory.addChild(packageDirectory.uriStem + packagePart + "/");
            }
            packageDirectory = packageDirectory.child(packagePart, false);
        }
        packageDirectory.makePackage();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.threadIsRunning = false;
        this.refreshThread.interrupt();
    }

    static void initHTTPProxyHack() {
        if (proxyInit) {
            return;
        }
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(IDE_SETTINGS_NAME);
        try {
            DataObject d = DataObject.find((FileObject)f);
            InstanceCookie ic = (InstanceCookie)d.getCookie(InstanceCookie.class);
            if (ic != null) {
                Object o = ic.instanceCreate();
                proxyInit = true;
            }
        }
        catch (DataObjectNotFoundException ex) {
        }
        catch (IOException ex) {
            proxyInit = true;
        }
        catch (ClassNotFoundException ex) {
            proxyInit = true;
        }
    }
}

