/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class DefaultEMLookup
extends ProxyLookup
implements LookupListener,
PropertyChangeListener {
    private static final Object PRESENT = new Object();
    private ExplorerManager tc;
    private LookupListener listener;
    private Map attachedTo;
    private Lookup actionMap;

    public DefaultEMLookup(ExplorerManager tc, ActionMap map) {
        this.tc = tc;
        this.listener = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)this, null);
        this.actionMap = Lookups.singleton((Object)map);
        tc.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)tc));
        this.updateLookups(tc.getSelectedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookups(Node[] arr) {
        HashMap copy;
        if (arr == null) {
            arr = new Node[]{};
        }
        Lookup[] lookups = new Lookup[arr.length];
        DefaultEMLookup defaultEMLookup = this;
        synchronized (defaultEMLookup) {
            copy = this.attachedTo == null ? Collections.EMPTY_MAP : new HashMap(this.attachedTo);
        }
        for (int i = 0; i < arr.length; ++i) {
            lookups[i] = arr[i].getLookup();
            if (copy == null) continue;
            copy.remove(arr[i]);
        }
        Iterator it = copy.values().iterator();
        while (it.hasNext()) {
            Lookup.Result res = (Lookup.Result)it.next();
            res.removeLookupListener(this.listener);
        }
        DefaultEMLookup defaultEMLookup2 = this;
        synchronized (defaultEMLookup2) {
            this.attachedTo = null;
        }
        this.setLookups(new Lookup[]{new NoNodeLookup((Lookup)new ProxyLookup(lookups), arr), Lookups.fixed((Object[])arr), this.actionMap});
    }

    public void resultChanged(LookupEvent ev) {
        this.updateLookups(this.tc.getSelectedNodes());
    }

    private static boolean isNodeQuery(Class c) {
        return Node.class.isAssignableFrom(c) || c.isAssignableFrom(Node.class);
    }

    protected synchronized void beforeLookup(Lookup.Template t) {
        if (this.attachedTo == null && DefaultEMLookup.isNodeQuery(t.getType())) {
            Lookup[] arr = this.getLookups();
            this.attachedTo = new WeakHashMap(arr.length * 2);
            for (int i = 0; i < arr.length - 2; ++i) {
                Lookup.Result res = arr[i].lookup(t);
                res.addLookupListener(this.listener);
                this.attachedTo.put(arr[i], res);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes" == evt.getPropertyName()) {
            this.updateLookups((Node[])evt.getNewValue());
        }
    }

    private static final class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;
        private final Map verboten;

        public NoNodeLookup(Lookup del, Object[] exclude) {
            this.delegate = del;
            this.verboten = new IdentityHashMap();
            int i = 0;
            while (i < exclude.length) {
                this.verboten.put(exclude[i++], PRESENT);
            }
        }

        public Object lookup(Class clazz) {
            if (clazz == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultEMLookup.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                return null;
            }
            Object o = this.delegate.lookup(clazz);
            if (this.verboten.containsKey(o)) {
                Iterator it = this.lookup(new Lookup.Template(clazz)).allInstances().iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (this.verboten.containsKey(o2)) continue;
                    return o2;
                }
                return null;
            }
            return o;
        }

        public Lookup.Result lookup(Lookup.Template template) {
            if (template.getType() == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultEMLookup.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                return Lookup.EMPTY.lookup(new Lookup.Template(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultEMLookup.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node));
            }
            return new ExclusionResult(this.delegate.lookup(template), this.verboten);
        }

        private static final class ExclusionResult
        extends Lookup.Result
        implements LookupListener {
            private final Lookup.Result delegate;
            private final Map verboten;
            private final List listeners = new ArrayList();

            public ExclusionResult(Lookup.Result delegate, Map verboten) {
                this.delegate = delegate;
                this.verboten = verboten;
            }

            public Collection allInstances() {
                Collection c = this.delegate.allInstances();
                ArrayList ret = new ArrayList(c.size());
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (this.verboten.containsKey(o)) continue;
                    ret.add(o);
                }
                return ret;
            }

            public Set allClasses() {
                return this.delegate.allClasses();
            }

            public Collection allItems() {
                Collection c = this.delegate.allItems();
                ArrayList<Lookup.Item> ret = new ArrayList<Lookup.Item>(c.size());
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    Lookup.Item i = (Lookup.Item)it.next();
                    if (this.verboten.containsKey(i.getInstance())) continue;
                    ret.add(i);
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener l) {
                List list = this.listeners;
                synchronized (list) {
                    if (this.listeners.isEmpty()) {
                        this.delegate.addLookupListener((LookupListener)this);
                    }
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener l) {
                List list = this.listeners;
                synchronized (list) {
                    this.listeners.remove(l);
                    if (this.listeners.isEmpty()) {
                        this.delegate.removeLookupListener((LookupListener)this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                LookupListener[] ls;
                LookupEvent ev2 = new LookupEvent((Lookup.Result)this);
                List list = this.listeners;
                synchronized (list) {
                    ls = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].resultChanged(ev2);
                }
            }
        }
    }
}

