/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.ejbjar.EjbJarAccessor;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class EjbJar {
    private EjbJarImplementation impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(EjbJarProvider.class));

    private EjbJar(EjbJarImplementation impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static EjbJar getEjbJar(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to EjbJar.getEjbJar(FileObject)");
        }
        for (EjbJarProvider impl : implementations.allInstances()) {
            EjbJar wm = impl.findEjbJar(f);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    public static EjbJar[] getEjbJars(Project project) {
        EjbJar[] jars;
        EjbJarsInProject providers = (EjbJarsInProject)project.getLookup().lookup(EjbJarsInProject.class);
        if (providers != null && (jars = providers.getEjbJars()) != null) {
            return jars;
        }
        return new EjbJar[0];
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        return this.impl.getMetaInf();
    }

    public MetadataUnit getMetadataUnit() {
        return this.impl.getMetadataUnit();
    }

    static {
        EjbJarAccessor.DEFAULT = new EjbJarAccessor(){

            public EjbJar createEjbJar(EjbJarImplementation spiEjbJar) {
                return new EjbJar(spiEjbJar);
            }

            public EjbJarImplementation getEjbJarImplementation(EjbJar wm) {
                return wm == null ? null : wm.impl;
            }
        };
    }
}

