/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class DerbySystemHomePanel
extends JPanel {
    private DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent e) {
            DerbySystemHomePanel.this.validatePanel();
        }

        public void insertUpdate(DocumentEvent e) {
            DerbySystemHomePanel.this.validatePanel();
        }

        public void changedUpdate(DocumentEvent e) {
            DerbySystemHomePanel.this.validatePanel();
        }
    };
    public JButton browseButton;
    public JLabel derbySystemHomeLabel;
    public JTextField derbySystemHomeTextField;
    public JScrollPane infoScrollPane;
    public JTextArea infoTextArea;
    public JLabel messageLabel;

    public static String findDerbySystemHome() {
        return (String)Mutex.EVENT.writeAccess(new Mutex.Action(){

            public Object run() {
                DerbySystemHomePanel panel = new DerbySystemHomePanel();
                String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$derby$ui$DerbySystemHomePanel == null ? (class$org$netbeans$modules$derby$ui$DerbySystemHomePanel = DerbySystemHomePanel.class$("org.netbeans.modules.derby.ui.DerbySystemHomePanel")) : class$org$netbeans$modules$derby$ui$DerbySystemHomePanel), (String)"LBL_SetDerbySystemHome");
                DialogDescriptor desc = new DialogDescriptor((Object)panel, title);
                panel.setDialogDescriptor(desc);
                while (true) {
                    boolean success;
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
                    String acsd = NbBundle.getMessage((Class)(class$org$netbeans$modules$derby$ui$DerbySystemHomePanel == null ? DerbySystemHomePanel.class$("org.netbeans.modules.derby.ui.DerbySystemHomePanel") : class$org$netbeans$modules$derby$ui$DerbySystemHomePanel), (String)"ACSD_DerbySystemHomePanel");
                    dialog.getAccessibleContext().setAccessibleDescription(acsd);
                    dialog.setVisible(true);
                    dialog.dispose();
                    if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                        return "";
                    }
                    File derbySystemHome = new File(panel.getDerbySystemHome());
                    if (derbySystemHome.exists() || (success = derbySystemHome.mkdirs())) break;
                    String message = NbBundle.getMessage((Class)(class$org$netbeans$modules$derby$ui$DerbySystemHomePanel == null ? DerbySystemHomePanel.class$("org.netbeans.modules.derby.ui.DerbySystemHomePanel") : class$org$netbeans$modules$derby$ui$DerbySystemHomePanel), (String)"ERR_DerbySystemHomeCantCreate");
                    NotifyDescriptor.Message ndesc = new NotifyDescriptor.Message((Object)message, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
                }
                return panel.getDerbySystemHome();
            }
        });
    }

    private DerbySystemHomePanel() {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.derbySystemHomeTextField.getDocument().addDocumentListener(this.docListener);
    }

    private void setDialogDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.validatePanel();
    }

    private String getDerbySystemHome() {
        return this.derbySystemHomeTextField.getText().trim();
    }

    private void setDerbySystemHome(String derbySystemHome) {
        this.derbySystemHomeTextField.setText(derbySystemHome);
    }

    private void validatePanel() {
        if (this.descriptor == null) {
            return;
        }
        String error = null;
        File derbySystemHome = new File(this.getDerbySystemHome());
        if (derbySystemHome.getPath().length() <= 0) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotEntered");
        } else if (derbySystemHome.exists() && !derbySystemHome.isDirectory()) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotDirectory");
        } else if (!derbySystemHome.isAbsolute()) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotAbsolute");
        }
        if (error != null) {
            this.messageLabel.setText(error);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    private void initComponents() {
        this.infoScrollPane = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.derbySystemHomeLabel = new JLabel();
        this.derbySystemHomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.messageLabel = new JLabel();
        this.infoScrollPane.setBorder(null);
        this.infoScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoScrollPane.setVerticalScrollBarPolicy(21);
        this.infoTextArea.setColumns(20);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setRows(5);
        this.infoTextArea.setText(NbBundle.getMessage((Class)DerbySystemHomePanel.class, (String)"LBL_DerbySystemHomeInfo"));
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setFocusable(false);
        this.infoTextArea.setOpaque(false);
        this.infoScrollPane.setViewportView(this.infoTextArea);
        this.derbySystemHomeLabel.setLabelFor(this.derbySystemHomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.derbySystemHomeLabel, (String)NbBundle.getMessage((Class)DerbySystemHomePanel.class, (String)"LBL_DerbySystemHome"));
        this.derbySystemHomeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DerbySystemHomePanel.class, (String)"ACSD_DerbySystemHomePanel_derbySystemHomeTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage((Class)DerbySystemHomePanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DerbySystemHomePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DerbySystemHomePanel.class, (String)"ACSD_DerbySystemHomePanel_browseButton"));
        this.messageLabel.setForeground(this.nbErrorForeground);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.infoScrollPane, 0, 505, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.derbySystemHomeLabel).addPreferredGap(0).add((Component)this.derbySystemHomeTextField, 0, 280, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add(1, (Component)this.messageLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.derbySystemHomeLabel).add((Component)this.derbySystemHomeTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0, 11, -2).add((Component)this.infoScrollPane, 0, 134, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.messageLabel).addContainerGap()));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        String derbySystemHome = this.getDerbySystemHome();
        if (derbySystemHome.length() > 0) {
            chooser.setSelectedFile(new File(derbySystemHome));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setDerbySystemHome(chooser.getSelectedFile().getAbsolutePath());
    }
}

