/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.rss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.rss.Channel;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RSSDigester
extends Digester {
    protected boolean configured = false;
    protected static final String[] registrations = new String[]{"-//Netscape Communications//DTD RSS 0.9//EN", "/org/apache/commons/digester/rss/rss-0.9.dtd", "-//Netscape Communications//DTD RSS 0.91//EN", "/org/apache/commons/digester/rss/rss-0.91.dtd"};
    protected String channelClass = "org.apache.commons.digester.rss.Channel";
    protected String imageClass = "org.apache.commons.digester.rss.Image";
    protected String itemClass = "org.apache.commons.digester.rss.Item";
    protected String textInputClass = "org.apache.commons.digester.rss.TextInput";
    static /* synthetic */ Class class$org$apache$commons$digester$rss$RSSDigester;

    public String getChannelClass() {
        return this.channelClass;
    }

    public void setChannelClass(String channelClass) {
        this.channelClass = channelClass;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
    }

    public String getTextInputClass() {
        return this.textInputClass;
    }

    public void setTextInputClass(String textInputClass) {
        this.textInputClass = textInputClass;
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        return super.parse(file);
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        this.configure();
        return super.parse(input);
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.configure();
        return super.parse(input);
    }

    public Object parse(String uri) throws IOException, SAXException {
        this.configure();
        return super.parse(uri);
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        int i = 0;
        while (i < registrations.length) {
            URL url = this.getClass().getResource(registrations[i + 1]);
            if (url != null) {
                this.register(registrations[i], url.toString());
            }
            i += 2;
        }
        this.addObjectCreate("rss/channel", this.channelClass);
        this.addCallMethod("rss/channel/copyright", "setCopyright", 0);
        this.addCallMethod("rss/channel/description", "setDescription", 0);
        this.addCallMethod("rss/channel/docs", "setDocs", 0);
        this.addCallMethod("rss/channel/language", "setLanguage", 0);
        this.addCallMethod("rss/channel/lastBuildDate", "setLastBuildDate", 0);
        this.addCallMethod("rss/channel/link", "setLink", 0);
        this.addCallMethod("rss/channel/managingEditor", "setManagingEditor", 0);
        this.addCallMethod("rss/channel/pubDate", "setPubDate", 0);
        this.addCallMethod("rss/channel/rating", "setRating", 0);
        this.addCallMethod("rss/channel/skipDays/day", "addSkipDay", 0);
        this.addCallMethod("rss/channel/skipHours/hour", "addSkipHour", 0);
        this.addCallMethod("rss/channel/title", "setTitle", 0);
        this.addCallMethod("rss/channel/webMaster", "setWebMaster", 0);
        this.addObjectCreate("rss/channel/image", this.imageClass);
        this.addSetNext("rss/channel/image", "setImage", "org.apache.commons.digester.rss.Image");
        this.addCallMethod("rss/channel/image/description", "setDescription", 0);
        this.addCallMethod("rss/channel/image/height", "setHeight", 0, new Class[]{Integer.TYPE});
        this.addCallMethod("rss/channel/image/link", "setLink", 0);
        this.addCallMethod("rss/channel/image/title", "setTitle", 0);
        this.addCallMethod("rss/channel/image/url", "setURL", 0);
        this.addCallMethod("rss/channel/image/width", "setWidth", 0, new Class[]{Integer.TYPE});
        this.addObjectCreate("rss/channel/item", this.itemClass);
        this.addSetNext("rss/channel/item", "addItem", "org.apache.commons.digester.rss.Item");
        this.addCallMethod("rss/channel/item/description", "setDescription", 0);
        this.addCallMethod("rss/channel/item/link", "setLink", 0);
        this.addCallMethod("rss/channel/item/title", "setTitle", 0);
        this.addObjectCreate("rss/channel/textinput", this.textInputClass);
        this.addSetNext("rss/channel/textinput", "setTextInput", "org.apache.commons.digester.rss.TextInput");
        this.addCallMethod("rss/channel/textinput/description", "setDescription", 0);
        this.addCallMethod("rss/channel/textinput/link", "setLink", 0);
        this.addCallMethod("rss/channel/textinput/name", "setName", 0);
        this.addCallMethod("rss/channel/textinput/title", "setTitle", 0);
        this.configured = true;
    }

    public static void main(String[] args) {
        try {
            System.out.println("RSSDigester Test Program");
            System.out.println("Opening input stream ...");
            InputStream is = (class$org$apache$commons$digester$rss$RSSDigester == null ? (class$org$apache$commons$digester$rss$RSSDigester = RSSDigester.class$("org.apache.commons.digester.rss.RSSDigester")) : class$org$apache$commons$digester$rss$RSSDigester).getResourceAsStream("/org/apache/commons/digester/rss/rss-example.xml");
            System.out.println("Creating new digester ...");
            RSSDigester digester = new RSSDigester();
            if (args.length > 0 && args[0].equals("-debug")) {
                digester.setLogger(LogFactory.getLog((String)"RSSDigester"));
            }
            System.out.println("Parsing input stream ...");
            Channel channel = (Channel)digester.parse(is);
            System.out.println("Closing input stream ...");
            is.close();
            System.out.println("Dumping channel info ...");
            channel.render(System.out);
        }
        catch (Exception e) {
            System.out.println("-->Exception");
            e.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

