/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReference<T extends Referenceable>
implements Reference<T> {
    private T referenced;
    private Class<T> classType;
    private AbstractComponent parent;
    protected String refString;

    public AbstractReference(T referenced, Class<T> referencedType, AbstractComponent parent) {
        if (referenced == null) {
            throw new IllegalArgumentException("Referenced component null");
        }
        this.checkParentAndType(parent, referencedType);
        this.referenced = referenced;
        this.classType = referencedType;
        this.parent = parent;
    }

    public AbstractReference(Class<T> referencedType, AbstractComponent parent, String ref) {
        this.checkParentAndType(parent, referencedType);
        this.refString = ref;
        this.classType = referencedType;
        this.parent = parent;
    }

    protected T getReferenced() {
        return this.referenced;
    }

    protected void setReferenced(T referenced) {
        this.referenced = referenced;
    }

    @Override
    public Class<T> getType() {
        return this.classType;
    }

    @Override
    public boolean isBroken() {
        try {
            return this.get() == null;
        }
        catch (IllegalStateException ise) {
            this.referenced = null;
            return false;
        }
    }

    @Override
    public boolean references(T target) {
        return this.get() == target;
    }

    @Override
    public String getRefString() {
        return this.refString;
    }

    protected AbstractComponent getParent() {
        return this.parent;
    }

    private void checkParentAndType(AbstractComponent parent, Class<T> classType) {
        if (parent == null) {
            throw new IllegalArgumentException("parent == null");
        }
        if (classType == null) {
            throw new IllegalArgumentException("classType == null");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractReference) {
            AbstractReference that = (AbstractReference)obj;
            return this.refString.equals(that.getRefString()) && this.parent.equals(that.parent) && this.getType().equals(that.getType());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.parent.hashCode();
    }
}

