/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;

public class Model {
    private BaseOptions javaOptions;

    boolean isShowCodeFolding() {
        return this.getFoldingParameter("code-folding-enable", true);
    }

    boolean isFoldImports() {
        return this.getFoldingParameter("code-folding-collapse-import", false);
    }

    boolean isFoldInitialComment() {
        return this.getFoldingParameter("code-folding-collapse-initial-comment", false);
    }

    boolean isFoldInnerClasses() {
        return this.getFoldingParameter("code-folding-collapse-innerclass", false);
    }

    boolean isFoldJavaDocComments() {
        return this.getFoldingParameter("code-folding-collapse-javadoc", false);
    }

    boolean isFoldMethods() {
        return this.getFoldingParameter("code-folding-collapse-method", false);
    }

    void setFoldingOptions(boolean showCodeFolding, boolean foldImports, boolean foldInitialComent, boolean foldInnerClasses, boolean foldJavaDoc, boolean foldMethods) {
        if (this.javaOptions == null) {
            this.javaOptions = Model.getOptions("text/x-java");
        }
        if (this.javaOptions == null) {
            return;
        }
        Map javaFoldingMap = this.javaOptions.getCodeFoldingProps();
        javaFoldingMap.put("code-folding-enable", showCodeFolding);
        javaFoldingMap.put("code-folding-collapse-import", foldImports);
        javaFoldingMap.put("code-folding-collapse-initial-comment", foldInitialComent);
        javaFoldingMap.put("code-folding-collapse-innerclass", foldInnerClasses);
        javaFoldingMap.put("code-folding-collapse-javadoc", foldJavaDoc);
        javaFoldingMap.put("code-folding-collapse-method", foldMethods);
        this.javaOptions.setCodeFoldingProps(javaFoldingMap);
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            Map m = baseOptions.getCodeFoldingProps();
            m.put("code-folding-enable", showCodeFolding);
            baseOptions.setCodeFoldingProps(m);
        }
    }

    boolean isPairCharacterCompletion() {
        return this.getParameter("getPairCharactersCompletion", true);
    }

    boolean isCompletionAutoPopup() {
        return this.getParameter("getCompletionAutoPopup", true);
    }

    boolean isShowDeprecatedMembers() {
        return this.getParameter("getShowDeprecatedMembers", true);
    }

    boolean isCompletionInstantSubstitution() {
        return this.getParameter("getCompletionInstantSubstitution", true);
    }

    boolean isCompletionCaseSensitive() {
        return this.getParameter("getCompletionCaseSensitive", true);
    }

    void setCompletionOptions(boolean pairCharacterCompletion, boolean completionAutoPopup, boolean showDeprecatedMembers, boolean completionInstantSubstitution, boolean completionCaseSensitive) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Method method;
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            try {
                method = baseOptions.getClass().getMethod("setPairCharactersCompletion", Boolean.TYPE);
                method.invoke((Object)baseOptions, pairCharacterCompletion);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionAutoPopup", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionAutoPopup);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setShowDeprecatedMembers", Boolean.TYPE);
                method.invoke((Object)baseOptions, showDeprecatedMembers);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionInstantSubstitution", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionInstantSubstitution);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                method = baseOptions.getClass().getMethod("setCompletionCaseSensitive", Boolean.TYPE);
                method.invoke((Object)baseOptions, completionCaseSensitive);
            }
            catch (Exception ex) {}
        }
    }

    private boolean getFoldingParameter(String parameterName, boolean defaultValue) {
        BaseOptions options = Model.getOptions("text/x-java");
        if (options == null) {
            options = Model.getOptions("text/plain");
        }
        if (options == null) {
            return defaultValue;
        }
        Map javaFoldingMap = options.getCodeFoldingProps();
        Boolean b = (Boolean)javaFoldingMap.get(parameterName);
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    private boolean getParameter(String parameterName, boolean defaultValue) {
        if (this.javaOptions == null) {
            this.javaOptions = Model.getOptions("text/x-java");
            if (this.javaOptions == null) {
                this.javaOptions = Model.getOptions("text/plain");
            }
        }
        if (this.javaOptions == null) {
            return defaultValue;
        }
        try {
            Method method = this.javaOptions.getClass().getMethod(parameterName, new Class[0]);
            return (Boolean)method.invoke((Object)this.javaOptions, new Object[0]);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private static BaseOptions getOptions(String mimeType) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            BaseKit kit = BaseKit.getKit((Class)baseOptions.getKitClass());
            if (!kit.getContentType().equals(mimeType)) continue;
            return baseOptions;
        }
        return null;
    }
}

