/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.Evaluator;
import org.netbeans.modules.web.wizards.FileType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;

class TargetEvaluator
extends Evaluator {
    private final boolean debug = false;
    private ArrayList pathItems = null;
    private DeployData deployData = null;
    private String errorMessage = null;
    private String fileName;
    private boolean initialized = false;
    private String className;

    TargetEvaluator(FileType fileType, DeployData deployData) {
        super(fileType);
        this.deployData = deployData;
    }

    String getErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    DeployData getDeployData() {
        return this.deployData;
    }

    String getClassName() {
        return this.className;
    }

    void setClassName(String fileName, String targetFolder) {
        this.className = targetFolder.length() > 0 ? targetFolder + "." + fileName : fileName;
        this.fileName = fileName;
    }

    String getFileName() {
        return this.fileName;
    }

    Iterator getPathItems() {
        return this.pathItems.iterator();
    }

    String getTargetPath() {
        return super.getTargetPath(this.pathItems.iterator());
    }

    void setInitialFolder(DataFolder selectedFolder, Project p) {
        if (selectedFolder == null) {
            return;
        }
        FileObject targetFolder = selectedFolder.getPrimaryFile();
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            this.deployData.setWebApp(DeployData.getWebAppFor(groups[i].getRootFolder()));
        }
        if (packageName == null) {
            packageName = "";
        }
        this.setInitialPath(packageName);
    }

    boolean isValid() {
        return true;
    }

    private void setInitialPath(String dirPath) {
        this.pathItems = new ArrayList();
        String[] path = dirPath.split("/");
        if (path.length > 0) {
            for (int i = 0; i < path.length; ++i) {
                if (path[i].equals("")) continue;
                this.pathItems.add(path[i]);
            }
        }
    }

    private static void log(String s) {
        System.out.println("TargetEvaluator" + s);
    }

    private void setAlternativeName(String fileName, FileObject targetFolder) {
        int index = 0;
        String tempName = fileName;
        boolean pathOK = false;
        while (!pathOK) {
            this.pathItems.remove(tempName);
            tempName = fileName.concat("_").concat(String.valueOf(++index));
            this.pathItems.add(tempName);
            try {
                this.checkFile(this.pathItems.iterator(), targetFolder);
                pathOK = true;
                this.fileName = tempName;
            }
            catch (IOException ioex) {
                pathOK = true;
            }
        }
    }
}

