/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.spi.ListModelSupport;
import org.netbeans.modules.java.navigation.spi.TreeModelSupport;

public abstract class AbstractModel {
    private TreeModelSupport tree = null;
    List tempList = null;
    private TreePath path = null;

    protected AbstractModel() {
        if (!TreeModelSupport.class.isAssignableFrom(this.getClass()) && !ListModelSupport.class.isAssignableFrom(this.getClass())) {
            throw new Error("Only ListModelSupport and TreeModelSupport may subclass AbstractModelSupport");
        }
    }

    protected abstract List loadContents();

    public final void addNotify() {
        this.doAddNotify();
        TreeModelSupport owner = this.getTree();
        if (this.tree != null) {
            // empty if block
        }
    }

    abstract void doAddNotify();

    protected abstract void removeNotify();

    protected abstract List getSearchResults(String var1);

    protected abstract boolean isActive();

    protected abstract List getList();

    protected abstract boolean isReady();

    protected abstract void startListening();

    protected abstract void stopListening();

    protected abstract void addChangeListener(ChangeListener var1) throws TooManyListenersException;

    protected abstract void removeChangeListener(ChangeListener var1);

    abstract boolean owns(Object var1);

    abstract int getSize();

    abstract Object getElementAt(int var1);

    abstract int indexOf(Object var1);

    AbstractModel findModelFor(Object o, boolean create) {
        return this.owns(o) ? this : null;
    }

    void setTree(TreeModelSupport tree) {
        this.tree = tree;
    }

    List getLoadingTempList() {
        if (this.tempList == null) {
            this.tempList = Arrays.asList(AbstractModel.createWaitMarker());
        }
        return this.tempList;
    }

    TreeModelSupport getTree() {
        return this.tree;
    }

    TreeModelSupport getRootTree() {
        TreeModelSupport tree = this.getTree();
        if (tree != null) {
            return tree.getRootTree();
        }
        if (this instanceof TreeModelSupport) {
            return (TreeModelSupport)this;
        }
        return null;
    }

    int fullSize() {
        return this.getSize();
    }

    void setPath(TreePath path) {
        this.path = path;
    }

    TreePath getPath() {
        return this.path;
    }

    static TreePath combine(TreePath a, TreePath b) {
        if (a == null || a.getPathComponent(0) == b.getPathComponent(0)) {
            return b;
        }
        ArrayList<Object> al = new ArrayList<Object>(a.getPathCount() + b.getPathCount());
        al.addAll(Arrays.asList(a.getPath()));
        al.addAll(Arrays.asList(b.getPath()));
        return new TreePath(al.toArray());
    }

    public static final Object createInvalidMarker() {
        return new Unique(true);
    }

    public static final Object createWaitMarker() {
        return new Unique(true);
    }

    public static final boolean isWaitMarker(Object o) {
        return o instanceof Unique && ((Unique)o).wait;
    }

    public static final boolean isInvalidMarker(Object o) {
        return o instanceof Unique && !((Unique)o).wait;
    }

    private static final class Unique {
        final boolean wait;

        Unique(boolean wait) {
            this.wait = wait;
        }

        public String toString() {
            return this.wait ? "wait" : "unique";
        }
    }
}

