/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class DDUtils {
    public static String[] getUrlPatterns(WebApp webApp, Servlet servlet) {
        if (servlet.getServletName() == null) {
            return new String[0];
        }
        ServletMapping[] mapping = webApp.getServletMapping();
        ArrayList<String> maps = new ArrayList<String>();
        for (int i = 0; i < mapping.length; ++i) {
            String urlPattern;
            if (!servlet.getServletName().equals(mapping[i].getServletName()) || (urlPattern = mapping[i].getUrlPattern()) == null) continue;
            maps.add(urlPattern);
        }
        String[] urlPatterns = new String[maps.size()];
        maps.toArray(urlPatterns);
        return urlPatterns;
    }

    public static String[] getUrlPatterns(WebApp webApp, Filter filter) {
        if (filter.getFilterName() == null) {
            return new String[0];
        }
        FilterMapping[] mapping = webApp.getFilterMapping();
        ArrayList<String> maps = new ArrayList<String>();
        for (int i = 0; i < mapping.length; ++i) {
            if (!filter.getFilterName().equals(mapping[i].getFilterName())) continue;
            String urlPattern = mapping[i].getUrlPattern();
            if (urlPattern != null) {
                maps.add(urlPattern);
                continue;
            }
            String servletName = mapping[i].getServletName();
            if (servletName == null) continue;
            maps.add(servletName);
        }
        String[] urlPatterns = new String[maps.size()];
        maps.toArray(urlPatterns);
        return urlPatterns;
    }

    public static String[] getStringArray(String text) {
        StringTokenizer tok = new StringTokenizer(text, ",");
        HashSet<String> set = new HashSet<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (token.length() <= 0) continue;
            set.add(token);
        }
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public static boolean isServletMapping(WebApp webApp, String urlPattern) {
        return webApp.findBeanByName("ServletMapping", "UrlPattern", urlPattern) != null;
    }

    public static boolean isServletMapping(WebApp webApp, Servlet servlet, String urlPattern) {
        ServletMapping[] maps = webApp.getServletMapping();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            for (int i = 0; i < maps.length; ++i) {
                if (!urlPattern.equals(maps[i].getUrlPattern()) || servletName.equals(maps[i].getServletName())) continue;
                return true;
            }
        }
        return false;
    }

    public static String urlPatternList(String[] urlPatterns) {
        if (urlPatterns == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urlPatterns.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(urlPatterns[i]);
        }
        return buf.toString();
    }

    public static void addServletMappings(WebApp webApp, Servlet servlet, String[] urlPatterns) {
        String servletName = servlet.getServletName();
        try {
            for (int i = 0; i < urlPatterns.length; ++i) {
                ServletMapping map = (ServletMapping)webApp.createBean("ServletMapping");
                map.setServletName(servletName);
                map.setUrlPattern(urlPatterns[i]);
                webApp.addServletMapping(map);
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
    }

    public static void setServletMappings(WebApp webApp, Servlet servlet, String[] urlPatterns) {
        int i;
        String servletName = servlet.getServletName();
        List oldMaps = DDUtils.getServletMappingList(webApp, servlet);
        ArrayList<String> newPatterns = new ArrayList<String>();
        for (int i2 = 0; i2 < urlPatterns.length; ++i2) {
            boolean found = false;
            for (int j = 0; j < oldMaps.size(); ++j) {
                ServletMapping oldMap = (ServletMapping)oldMaps.get(j);
                if (!urlPatterns[i2].equals(oldMap.getUrlPattern())) continue;
                oldMaps.remove(oldMap);
                found = true;
                break;
            }
            if (found) continue;
            newPatterns.add(urlPatterns[i2]);
        }
        int min = Math.min(oldMaps.size(), newPatterns.size());
        for (i = 0; i < min; ++i) {
            ServletMapping oldMap = (ServletMapping)oldMaps.get(i);
            oldMap.setUrlPattern((String)newPatterns.get(i));
        }
        try {
            for (i = min; i < newPatterns.size(); ++i) {
                ServletMapping map = (ServletMapping)webApp.createBean("ServletMapping");
                map.setServletName(servletName);
                map.setUrlPattern((String)newPatterns.get(i));
                webApp.addServletMapping(map);
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        for (int i3 = min; i3 < oldMaps.size(); ++i3) {
            webApp.removeServletMapping((ServletMapping)oldMaps.get(i3));
        }
    }

    public static ServletMapping[] getServletMappings(WebApp webApp, Servlet servlet) {
        List maps = DDUtils.getServletMappingList(webApp, servlet);
        ServletMapping[] newMappings = new ServletMapping[maps.size()];
        maps.toArray(newMappings);
        return newMappings;
    }

    public static FilterMapping[] getFilterMappings(WebApp webApp, Filter filter) {
        List maps = DDUtils.getFilterMappingList(webApp, filter);
        FilterMapping[] newMappings = new FilterMapping[maps.size()];
        maps.toArray(newMappings);
        return newMappings;
    }

    public static FilterMapping[] getFilterMappings(WebApp webApp, Servlet servlet) {
        ArrayList<FilterMapping> maps = new ArrayList<FilterMapping>();
        if (servlet == null) {
            return new FilterMapping[0];
        }
        FilterMapping[] mapping = webApp.getFilterMapping();
        for (int i = 0; i < mapping.length; ++i) {
            FilterMapping fm = mapping[i];
            if (fm.getServletName() == null || !fm.getServletName().equals(servlet.getServletName())) continue;
            maps.add(fm);
        }
        return maps.toArray(new FilterMapping[maps.size()]);
    }

    private static List getServletMappingList(WebApp webApp, Servlet servlet) {
        String servletName = servlet.getServletName();
        ArrayList<ServletMapping> maps = new ArrayList<ServletMapping>();
        if (servletName == null) {
            return maps;
        }
        ServletMapping[] mapping = webApp.getServletMapping();
        for (int i = 0; i < mapping.length; ++i) {
            if (!servlet.getServletName().equals(mapping[i].getServletName())) continue;
            maps.add(mapping[i]);
        }
        return maps;
    }

    private static List getFilterMappingList(WebApp webApp, Filter filter) {
        String filterName = filter.getFilterName();
        ArrayList<FilterMapping> maps = new ArrayList<FilterMapping>();
        if (filterName == null) {
            return maps;
        }
        FilterMapping[] mapping = webApp.getFilterMapping();
        for (int i = 0; i < mapping.length; ++i) {
            if (!filter.getFilterName().equals(mapping[i].getFilterName())) continue;
            maps.add(mapping[i]);
        }
        return maps;
    }

    public static void openEditorFor(DDDataObject dObj, String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        try {
            SourceGroup[] sourceGroups = DDUtils.getJavaSourceGroups(dObj);
            String resource = className.trim().replace('.', '/');
            for (int i = 0; i < sourceGroups.length; ++i) {
                DataObject javaDo;
                OpenCookie cookie;
                FileObject fo = sourceGroups[i].getRootFolder();
                FileObject target = fo.getFileObject(resource + ".java");
                if (target == null || (cookie = (OpenCookie)(javaDo = DataObject.find((FileObject)target)).getCookie(class$org$openide$cookies$OpenCookie == null ? DDUtils.class$("org.openide.cookies.OpenCookie") : class$org$openide$cookies$OpenCookie)) == null) continue;
                cookie.open();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_sourceNotFound")));
    }

    public static void openEditorForSingleFile(DDDataObject dObj, String fileName) {
        FileObject target;
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        FileObject docBase = null;
        try {
            docBase = DDUtils.getDocumentBase(dObj);
        }
        catch (IOException ex) {
            return;
        }
        if (docBase != null && (target = docBase.getFileObject(fileName.trim())) != null) {
            try {
                DataObject javaDo = DataObject.find((FileObject)target);
                OpenCookie cookie = (OpenCookie)javaDo.getCookie(OpenCookie.class);
                if (cookie != null) {
                    cookie.open();
                    return;
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_sourceNotFound")));
    }

    public static void openEditorForFiles(DDDataObject dObj, StringTokenizer tok) {
        FileObject docBase = null;
        try {
            docBase = DDUtils.getDocumentBase(dObj);
        }
        catch (IOException ex) {
            return;
        }
        if (!tok.hasMoreTokens()) {
            return;
        }
        boolean found = false;
        if (docBase != null) {
            while (tok.hasMoreTokens()) {
                FileObject target;
                String resource = tok.nextToken().trim();
                if (resource.length() <= 0 || (target = docBase.getFileObject(resource)) == null) continue;
                try {
                    DataObject javaDo = DataObject.find((FileObject)target);
                    OpenCookie cookie = (OpenCookie)javaDo.getCookie(class$org$openide$cookies$OpenCookie == null ? DDUtils.class$("org.openide.cookies.OpenCookie") : class$org$openide$cookies$OpenCookie);
                    if (cookie == null) continue;
                    cookie.open();
                    found = true;
                }
                catch (DataObjectNotFoundException ex) {}
            }
        }
        if (!found) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_sourcesNotFound")));
        }
    }

    public static SourceGroup[] getJavaSourceGroups(DDDataObject dObj) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        return sources.getSourceGroups("java");
    }

    public static SourceGroup[] getDocBaseGroups(DDDataObject dObj) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        return sources.getSourceGroups("doc_root");
    }

    public static FileObject getDocumentBase(DDDataObject dObj) throws IOException {
        WebModule wm = WebModule.getWebModule((FileObject)dObj.getPrimaryFile());
        if (wm == null) {
            return null;
        }
        return wm.getDocumentBase();
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo) {
        return DDUtils.getResourcePath(groups, fo, '.', false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator) {
        return DDUtils.getResourcePath(groups, fo, separator, false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }

    public static void removeServletMappings(WebApp webApp, String servletName) {
        if (servletName == null) {
            return;
        }
        ServletMapping[] oldMaps = webApp.getServletMapping();
        for (int i = 0; i < oldMaps.length; ++i) {
            if (!servletName.equals(oldMaps[i].getServletName())) continue;
            webApp.removeServletMapping(oldMaps[i]);
        }
    }

    public static Stack removeFilterMappings(WebApp webApp, String filterName) {
        Stack<Integer> deletedRows = new Stack<Integer>();
        if (filterName == null) {
            return deletedRows;
        }
        FilterMapping[] oldMaps = webApp.getFilterMapping();
        for (int i = 0; i < oldMaps.length; ++i) {
            if (!filterName.equals(oldMaps[i].getFilterName())) continue;
            webApp.removeFilterMapping(oldMaps[i]);
            deletedRows.push(new Integer(i));
        }
        return deletedRows;
    }

    public static void removeFilterMappingsForServlet(WebApp webApp, String servletName) {
        Stack deletedRows = new Stack();
        if (servletName == null) {
            return;
        }
        FilterMapping[] oldMaps = webApp.getFilterMapping();
        for (int i = 0; i < oldMaps.length; ++i) {
            if (!servletName.equals(oldMaps[i].getServletName())) continue;
            webApp.removeFilterMapping(oldMaps[i]);
        }
    }

    public static String addItem(String text, String newItem, boolean asFirst) {
        String[] stringArray = DDUtils.getStringArray(text);
        ArrayList<String> list = new ArrayList<String>();
        if (asFirst) {
            list.add(newItem);
            for (int i = 0; i < stringArray.length; ++i) {
                if (newItem.equals(stringArray[i])) continue;
                list.add(stringArray[i]);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (newItem.equals(stringArray[i])) continue;
                list.add(stringArray[i]);
            }
            list.add(newItem);
        }
        return DDUtils.getAsString(list);
    }

    private static String getAsString(List list) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)list.get(i));
        }
        return buf.toString();
    }

    public static String[] getServletNames(WebApp webApp) {
        Servlet[] allServlets = webApp.getServlet();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < allServlets.length; ++i) {
            String servletName = allServlets[i].getServletName();
            if (servletName == null || list.contains(allServlets[i])) continue;
            list.add(servletName);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    public static String[] getFilterNames(WebApp webApp) {
        Filter[] filters = webApp.getFilter();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < filters.length; ++i) {
            String filterName = filters[i].getFilterName();
            if (filterName == null || list.contains(filters[i])) continue;
            list.add(filterName);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    public static String checkServletMappig(String uri) {
        if (!uri.matches("[\\*/].*")) {
            return NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_WrongUriStart");
        }
        if (uri.length() > 1 && uri.endsWith("/")) {
            return NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_WrongUriEnd");
        }
        if (uri.matches(".*\\*.*\\*.*")) {
            return NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_TwoAsterisks");
        }
        if (uri.matches("..*\\*..*")) {
            return NbBundle.getMessage((Class)DDUtils.class, (String)"MSG_AsteriskInTheMiddle");
        }
        return null;
    }
}

