/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.junit.CreateTestAction;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.ProgressIndicator;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPlugin
extends JUnitPlugin {
    @Override
    protected JUnitPlugin.Location getTestLocation(JUnitPlugin.Location sourceLocation) {
        String testResName;
        FileObject[] testRoots;
        FileObject[] testRootsRaw;
        Utils utils;
        FileObject foRoot;
        ClassPath srcCP;
        FileObject fo = sourceLocation.getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null || (srcCP = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) == null || (foRoot = srcCP.findOwnerRoot(fo)) == null || (utils = new Utils(project)) == null || (testRootsRaw = utils.getTestFoldersRaw(foRoot)).length == 0 || (testRoots = Utils.skipNulls(testRootsRaw)).length == 0) {
            return null;
        }
        String baseResName = srcCP.getResourceName(fo, '/', false);
        String string = testResName = !fo.isFolder() ? DefaultPlugin.getTestResName(baseResName, fo.getExt()) : DefaultPlugin.getSuiteResName(baseResName);
        assert (testResName != null);
        List testFiles = ClassPathSupport.createClassPath((FileObject[])testRoots).findAllResources(testResName);
        if (testFiles.isEmpty()) {
            return null;
        }
        return DefaultPlugin.getOppositeLocation(sourceLocation, testFiles, true);
    }

    @Override
    protected JUnitPlugin.Location getTestedLocation(JUnitPlugin.Location testLocation) {
        FileObject[] sourceRoots;
        FileObject[] sourceRootsRaw;
        Utils utils;
        FileObject foRoot;
        ClassPath srcCP;
        Project project;
        FileObject fo = testLocation.getFileObject();
        if (fo.isFolder() || (project = FileOwnerQuery.getOwner((FileObject)fo)) == null || (srcCP = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) == null || (foRoot = srcCP.findOwnerRoot(fo)) == null || (utils = new Utils(project)) == null || (sourceRootsRaw = utils.getSourceFoldersRaw(foRoot)).length == 0 || (sourceRoots = Utils.skipNulls(sourceRootsRaw)).length == 0) {
            return null;
        }
        String baseResName = srcCP.getResourceName(fo, '/', false);
        String srcResName = DefaultPlugin.getSrcResName(baseResName, fo.getExt());
        if (srcResName == null) {
            return null;
        }
        List srcFiles = ClassPathSupport.createClassPath((FileObject[])sourceRoots).findAllResources(srcResName);
        if (srcFiles.isEmpty()) {
            return null;
        }
        return DefaultPlugin.getOppositeLocation(testLocation, srcFiles, false);
    }

    private static JUnitPlugin.Location getOppositeLocation(JUnitPlugin.Location sourceLocation, List<FileObject> candidateFiles, boolean sourceToTest) {
        String oppoClassName;
        JavaClass clazz;
        Feature element = sourceLocation.getJavaElement();
        if (element == null) {
            return new JUnitPlugin.Location(candidateFiles.get(0), null);
        }
        assert (element instanceof Method || element instanceof JavaClass);
        String oppoMethodName = null;
        if (element instanceof Method) {
            Method method = (Method)element;
            ClassDefinition classDef = method.getDeclaringClass();
            if (classDef instanceof JavaClass) {
                clazz = (JavaClass)classDef;
                String baseMethodName = method.getName();
                oppoMethodName = sourceToTest ? DefaultPlugin.getTestMethodName(baseMethodName) : DefaultPlugin.getSourceMethodName(baseMethodName);
            } else {
                clazz = null;
            }
        } else {
            clazz = (JavaClass)element;
        }
        if (clazz == null) {
            return new JUnitPlugin.Location(candidateFiles.get(0), null);
        }
        String baseClassName = clazz.getName();
        String string = oppoClassName = sourceToTest ? DefaultPlugin.getTestClassName(baseClassName) : DefaultPlugin.getSourceClassName(baseClassName);
        if (oppoClassName == null) {
            return new JUnitPlugin.Location(candidateFiles.get(0), null);
        }
        FileObject foWithClass = null;
        FileObject foWithMethod = null;
        JavaClass theJavaClass = null;
        Method theMethod = null;
        for (FileObject fileObj : candidateFiles) {
            Method method;
            Resource resource = JavaModel.getResource((FileObject)fileObj);
            assert (resource != null);
            JavaClass javaClass = DefaultPlugin.findJavaClass(resource, oppoClassName);
            if (javaClass == null) continue;
            if (foWithClass == null) {
                foWithClass = fileObj;
                theJavaClass = javaClass;
            }
            if (oppoMethodName == null || (method = sourceToTest ? DefaultPlugin.findTestMethod((ClassDefinition)javaClass, oppoMethodName) : DefaultPlugin.findSourceMethod((ClassDefinition)javaClass, oppoMethodName)) == null) continue;
            theMethod = method;
            foWithMethod = fileObj;
            break;
        }
        if (foWithMethod != null) {
            return new JUnitPlugin.Location(foWithMethod, (Feature)theMethod);
        }
        if (foWithClass != null) {
            return new JUnitPlugin.Location(foWithClass, (Feature)theJavaClass);
        }
        return new JUnitPlugin.Location(candidateFiles.get(0), null);
    }

    private static String getTestResName(String baseResName, String ext) {
        StringBuilder buf = new StringBuilder(baseResName.length() + ext.length() + 10);
        buf.append(baseResName).append("Test");
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getSuiteResName(String baseResName) {
        if (baseResName.length() == 0) {
            return JUnitSettings.getDefault().getRootSuiteClassName();
        }
        String suiteSuffix = "Suite";
        String lastNamePart = baseResName.substring(baseResName.lastIndexOf(47) + 1);
        StringBuilder buf = new StringBuilder(baseResName.length() + lastNamePart.length() + "Suite".length() + 6);
        buf.append(baseResName).append('/');
        buf.append(Character.toUpperCase(lastNamePart.charAt(0))).append(lastNamePart.substring(1));
        buf.append("Suite");
        buf.append(".java");
        return buf.toString();
    }

    private static String getSrcResName(String testResName, String ext) {
        if (!testResName.endsWith("Test")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(testResName.length() + ext.length());
        buf.append(testResName.substring(0, testResName.length() - 4));
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getTestClassName(String baseClassName) {
        return baseClassName + "Test";
    }

    private static String getSourceClassName(String testClassName) {
        String suffix = "Test";
        int suffixLen = "Test".length();
        return testClassName.length() > suffixLen && testClassName.endsWith("Test") ? testClassName.substring(0, testClassName.length() - suffixLen) : null;
    }

    private static String getSuiteName(String packageName) {
        if (packageName.length() == 0) {
            return JUnitSettings.getDefault().getRootSuiteClassName();
        }
        String suiteSuffix = "Suite";
        String lastNamePart = packageName.substring(packageName.lastIndexOf(46) + 1);
        StringBuffer buf = new StringBuffer(packageName.length() + lastNamePart.length() + "Suite".length() + 1);
        buf.append(packageName).append('.');
        buf.append(Character.toUpperCase(lastNamePart.charAt(0))).append(lastNamePart.substring(1));
        buf.append("Suite");
        return buf.toString();
    }

    private static String getTestMethodName(String baseMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        StringBuffer buf = new StringBuffer(prefixLen + baseMethodName.length());
        buf.append("test").append(baseMethodName);
        buf.setCharAt(prefixLen, Character.toUpperCase(baseMethodName.charAt(0)));
        return buf.toString();
    }

    private static String getSourceMethodName(String testMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        return testMethodName.length() > prefixLen && testMethodName.startsWith("test") ? new StringBuffer(testMethodName.length() - prefixLen).append(Character.toLowerCase(testMethodName.charAt(prefixLen))).append(testMethodName.substring(prefixLen + 1)).toString() : null;
    }

    private static JavaClass findJavaClass(Resource resource, String className) {
        for (Element e : resource.getChildren()) {
            if (!(e instanceof JavaClass) || !((JavaClass)e).getName().equals(className)) continue;
            return (JavaClass)e;
        }
        return null;
    }

    private static Method findTestMethod(ClassDefinition classDef, String methodName) {
        Method method = classDef.getMethod(methodName, Collections.EMPTY_LIST, false);
        return method != null && Modifier.isPublic(method.getModifiers()) && method.getTypeName().getName().equals("void") ? method : null;
    }

    private static Method findSourceMethod(ClassDefinition classDef, String methodName) {
        List classChildren = classDef.getChildren();
        if (classChildren == null || classChildren.isEmpty()) {
            return null;
        }
        for (Object o : classChildren) {
            Method method;
            if (!(o instanceof Method) || !(method = (Method)o).getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] createTests(FileObject[] filesToTest, FileObject targetRoot, Map<JUnitPlugin.CreateTestParam, Object> params) {
        FileObject[] createdFiles;
        CreationResults results;
        DataObject doSuiteTempl;
        boolean emptyTest = filesToTest == null || filesToTest.length == 0;
        boolean singleClass = !emptyTest && filesToTest.length == 1 && filesToTest[0].isData();
        String testClassName = emptyTest || singleClass ? (String)params.get((Object)JUnitPlugin.CreateTestParam.CLASS_NAME) : null;
        ClassPath testClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{targetRoot});
        DataObject doTestTempl = DefaultPlugin.loadTestTemplate("PROP_testClassTemplate");
        if (doTestTempl == null) {
            return null;
        }
        if (!emptyTest && !singleClass) {
            doSuiteTempl = DefaultPlugin.loadTestTemplate("PROP_testSuiteTemplate");
            if (doSuiteTempl == null) {
                return null;
            }
        } else {
            doSuiteTempl = null;
        }
        ProgressIndicator progress = new ProgressIndicator();
        progress.show();
        String msg = NbBundle.getMessage(CreateTestAction.class, (String)"MSG_StatusBar_CreateTest_Begin");
        progress.displayStatusText(msg);
        TestCreator testCreator = new TestCreator(params);
        try {
            if (emptyTest) {
                assert (testClassName != null);
                results = new CreationResults(1);
                try {
                    DataFolder targetFolderDataObj = DataFolder.findFolder((FileObject)targetRoot);
                    DataObject testDataObj = doTestTempl.createFromTemplate(targetFolderDataObj, testClassName);
                    FileObject foSource = testDataObj.getPrimaryFile();
                    Resource srcRc = JavaModel.getResource((FileObject)foSource);
                    JavaClass cls = TestUtil.getMainJavaClass(srcRc);
                    new TestCreator(params).createEmptyTest(srcRc, cls);
                    results.addCreated(testDataObj);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            } else if (singleClass) {
                if (testClassName == null) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)filesToTest[0], (String)"classpath/source");
                    String srcClassName = cp.getResourceName(filesToTest[0], '.', false);
                    testClassName = DefaultPlugin.getTestClassName(srcClassName);
                }
                try {
                    results = DefaultPlugin.createSingleTest(testCreator, testClassPath, filesToTest[0], testClassName, doTestTempl, null, progress, false);
                }
                catch (CreationError ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    results = new CreationResults(1);
                }
            } else {
                results = new CreationResults();
                for (FileObject fileToTest : filesToTest) {
                    try {
                        results.combine(DefaultPlugin.createTests(testCreator, fileToTest, testClassPath, doTestTempl, doSuiteTempl, null, progress));
                    }
                    catch (CreationError e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
        finally {
            progress.hide();
        }
        Set<CreationResults.SkippedClass> skipped = results.getSkipped();
        Set<DataObject> created = results.getCreated();
        if (!skipped.isEmpty()) {
            String message;
            if (skipped.size() == 1) {
                CreationResults.SkippedClass skippedClass = skipped.iterator().next();
                message = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_class", (Object)skippedClass.cls.getName(), (Object)DefaultPlugin.strReason(skippedClass.reason, "COMMA", "AND"));
            } else {
                TestCreator.TesteableResult reason = TestCreator.TesteableResult.OK;
                for (CreationResults.SkippedClass sc : skipped) {
                    reason = TestCreator.TesteableResult.combine(reason, sc.reason);
                }
                message = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_classes", (Object)DefaultPlugin.strReason(reason, "COMMA", "OR"));
            }
            TestUtil.notifyUser(message, 1);
        } else {
            int createdCount = created.size();
            if (createdCount == 1) {
                DataObject dobj = results.getCreated().iterator().next();
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    ec.open();
                }
            } else if (createdCount == 0) {
                Mutex.EVENT.writeAccess(new Runnable(){

                    public void run() {
                        TestUtil.notifyUser(NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_No_test_created"), 1);
                    }
                });
            }
        }
        if (created.isEmpty()) {
            createdFiles = null;
        } else {
            createdFiles = new FileObject[created.size()];
            int i = 0;
            for (DataObject dObj : created) {
                createdFiles[i++] = dObj.getPrimaryFile();
            }
        }
        return createdFiles;
    }

    public DataObject createSuiteTest(FileObject targetRootFolder, FileObject targetFolder, String suiteName, Map<JUnitPlugin.CreateTestParam, Object> params) {
        TestCreator testCreator = new TestCreator(params);
        ClassPath testClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{targetRootFolder});
        List testClassNames = TestUtil.getJavaFileNames(targetFolder, testClassPath);
        DataObject doSuiteTempl = DefaultPlugin.loadTestTemplate("PROP_testSuiteTemplate");
        if (doSuiteTempl == null) {
            return null;
        }
        try {
            return DefaultPlugin.createSuiteTest(testCreator, testClassPath, targetFolder, suiteName, new LinkedList(testClassNames), doSuiteTempl, null, null);
        }
        catch (CreationError ex) {
            return null;
        }
    }

    private static DataObject createSuiteTest(TestCreator testCreator, ClassPath testClassPath, FileObject folder, String suiteName, LinkedList suite, DataObject doSuiteT, LinkedList parentSuite, ProgressIndicator progress) throws CreationError {
        FileObject fo = folder;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        assert (cp != null) : "SOURCE classpath was not found for " + fo;
        if (cp == null) {
            return null;
        }
        String pkg = cp.getResourceName(fo, '/', false);
        String dotPkg = pkg.replace('/', '.');
        String fullSuiteName = suiteName != null ? pkg + '/' + suiteName : TestUtil.convertPackage2SuiteName(pkg);
        try {
            DataObject doTarget = DefaultPlugin.getTestClass(testClassPath, fullSuiteName, doSuiteT);
            Collection targetClasses = TestUtil.getAllClassesFromFile(doTarget.getPrimaryFile());
            for (JavaClass targetClass : targetClasses) {
                if (progress != null) {
                    progress.setMessage(DefaultPlugin.getCreatingMsg(targetClass.getName()), false);
                }
                try {
                    testCreator.createTestSuite(suite, dotPkg, targetClass);
                    DefaultPlugin.save(doTarget);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().log(65536, e.toString());
                    return null;
                }
                if (null == parentSuite) continue;
                parentSuite.add(targetClass.getName());
            }
            return doTarget;
        }
        catch (IOException ioe) {
            throw new CreationError(ioe);
        }
    }

    private static CreationResults createTests(TestCreator testCreator, FileObject fileObj, ClassPath testClassPath, DataObject doTestT, DataObject doSuiteT, LinkedList parentSuite, ProgressIndicator progress) throws CreationError {
        if (fileObj.isFolder()) {
            CreationResults results = new CreationResults();
            LinkedList mySuite = new LinkedList();
            progress.setMessage(DefaultPlugin.getScanningMsg(fileObj.getName()), false);
            for (FileObject childFileObj : fileObj.getChildren()) {
                if (progress.isCanceled()) {
                    results.setAbborted();
                    break;
                }
                results.combine(DefaultPlugin.createTests(testCreator, childFileObj, testClassPath, doTestT, doSuiteT, mySuite, progress));
                if (results.isAbborted()) break;
            }
            if (!results.isAbborted() && 0 < mySuite.size() & JUnitSettings.getDefault().isGenerateSuiteClasses()) {
                DefaultPlugin.createSuiteTest(testCreator, testClassPath, fileObj, null, mySuite, doSuiteT, parentSuite, progress);
            }
            return results;
        }
        if (fileObj.isData() && !"java".equals(fileObj.getExt())) {
            return CreationResults.EMPTY;
        }
        return DefaultPlugin.createSingleTest(testCreator, testClassPath, fileObj, null, doTestT, parentSuite, progress, true);
    }

    private static CreationResults createSingleTest(TestCreator testCreator, ClassPath testClassPath, FileObject foSource, String testClassName, DataObject doTestT, LinkedList parentSuite, ProgressIndicator progress, boolean skipNonTestable) throws CreationError {
        Resource srcRc = JavaModel.getResource((FileObject)foSource);
        String packageName = testClassName == null ? srcRc.getPackageName() : null;
        List srcChildren = srcRc.getChildren();
        CreationResults result = new CreationResults(srcChildren.size());
        boolean defClassProcessed = false;
        for (Element el : srcChildren) {
            TestCreator.TesteableResult testeable;
            if (!(el instanceof JavaClass) || el instanceof AnnotationType) continue;
            JavaClass theClass = (JavaClass)el;
            if (skipNonTestable && (testeable = testCreator.isClassTestable(theClass)).isFailed()) {
                if (progress == null) continue;
                progress.setMessage(DefaultPlugin.getIgnoringMsg(theClass.getName(), testeable.toString()), false);
                result.addSkipped(theClass, testeable);
                continue;
            }
            try {
                DataObject doTarget;
                Resource tgtRc;
                JavaClass targetClass;
                String testResourceName;
                String srcClassNameShort = theClass.getSimpleName();
                if (testClassName == null) {
                    testResourceName = TestUtil.getTestClassFullName(srcClassNameShort, packageName);
                } else if (!defClassProcessed && srcClassNameShort.equals(foSource.getName())) {
                    testResourceName = testClassName.replace('.', '/');
                    defClassProcessed = true;
                } else {
                    if (packageName == null) {
                        packageName = DefaultPlugin.packageName(testClassName);
                    }
                    testResourceName = TestUtil.getTestClassFullName(srcClassNameShort, packageName);
                }
                if ((targetClass = TestUtil.getMainJavaClass(tgtRc = JavaModel.getResource((FileObject)(doTarget = DefaultPlugin.getTestClass(testClassPath, testResourceName, doTestT)).getPrimaryFile()))) == null) continue;
                if (progress != null) {
                    progress.setMessage(DefaultPlugin.getCreatingMsg(targetClass.getName()), false);
                }
                testCreator.createTestClass(srcRc, theClass, tgtRc, targetClass);
                DefaultPlugin.save(doTarget);
                result.addCreated(doTarget);
                if (null == parentSuite) continue;
                parentSuite.add(targetClass.getName());
            }
            catch (IOException ioe) {
                throw new CreationError(ioe);
            }
        }
        return result;
    }

    private static String packageName(String fullName) {
        int i = fullName.lastIndexOf(46);
        return fullName.substring(0, i > 0 ? i : 0);
    }

    private static DataObject getTestClass(ClassPath cp, String testClassName, DataObject doTemplate) throws DataObjectNotFoundException, IOException {
        String clazz;
        FileObject fo = cp.findResource(testClassName + ".java");
        if (fo != null) {
            return DataObject.find((FileObject)fo);
        }
        assert (cp.getRoots().length == 1);
        FileObject root = cp.getRoots()[0];
        int index = testClassName.lastIndexOf(47);
        String pkg = index > -1 ? testClassName.substring(0, index) : "";
        String string = clazz = index > -1 ? testClassName.substring(index + 1) : testClassName;
        if (pkg.length() > 0) {
            root = FileUtil.createFolder((FileObject)root, (String)pkg);
        }
        return doTemplate.createFromTemplate(DataFolder.findFolder((FileObject)root), clazz);
    }

    private static void save(DataObject dO) throws IOException {
        SaveCookie sc = (SaveCookie)dO.getCookie(SaveCookie.class);
        if (null != sc) {
            sc.save();
        }
    }

    private static DataObject loadTestTemplate(String templateID) {
        String path = NbBundle.getMessage(DefaultPlugin.class, (String)templateID);
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(path);
            if (fo == null) {
                DefaultPlugin.noTemplateMessage(path);
                return null;
            }
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            DefaultPlugin.noTemplateMessage(path);
            return null;
        }
    }

    private static void noTemplateMessage(String temp) {
        String msg = NbBundle.getMessage(CreateTestAction.class, (String)"MSG_template_not_found", (Object)temp);
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    private static String strReason(TestCreator.TesteableResult reason, String commaKey, String andKey) {
        String strComma = NbBundle.getMessage(CreateTestAction.class, (String)commaKey);
        String strAnd = NbBundle.getMessage(CreateTestAction.class, (String)andKey);
        String strReason = reason.getReason(strComma.substring(1, strComma.length() - 1), strAnd.substring(1, strAnd.length() - 1));
        return strReason;
    }

    private static String getCreatingMsg(String className) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_creating", (Object)className);
    }

    private static String getScanningMsg(String sourceName) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_scanning", (Object)sourceName);
    }

    private static String getIgnoringMsg(String sourceName, String reason) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_ignoring", (Object)sourceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CreationResults {
        static final CreationResults EMPTY = new CreationResults();
        Set<DataObject> created;
        Set<SkippedClass> skipped;
        boolean abborted = false;

        CreationResults() {
            this(20);
        }

        CreationResults(int expectedSize) {
            this.created = new HashSet<DataObject>(expectedSize * 2, 0.5f);
            this.skipped = new HashSet<SkippedClass>(expectedSize * 2, 0.5f);
        }

        void setAbborted() {
            this.abborted = true;
        }

        boolean isAbborted() {
            return this.abborted;
        }

        boolean addCreated(DataObject test) {
            return this.created.add(test);
        }

        boolean addSkipped(JavaClass c, TestCreator.TesteableResult reason) {
            return this.skipped.add(new SkippedClass(c, reason));
        }

        Set<SkippedClass> getSkipped() {
            return this.skipped;
        }

        Set<DataObject> getCreated() {
            return this.created;
        }

        void combine(CreationResults rhs) {
            if (rhs.abborted) {
                this.abborted = true;
            }
            this.created.addAll(rhs.created);
            this.skipped.addAll(rhs.skipped);
        }

        static final class SkippedClass {
            final JavaClass cls;
            final TestCreator.TesteableResult reason;

            SkippedClass(JavaClass cls, TestCreator.TesteableResult reason) {
                this.cls = cls;
                this.reason = reason;
            }
        }
    }

    private static final class CreationError
    extends Exception {
        CreationError() {
        }

        CreationError(Throwable cause) {
            super(cause);
        }
    }
}

