/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUISupport {
    private TableUISupport() {
    }

    public static void connectAvailable(JList availableTablesList, TableClosure tableClosure) {
        availableTablesList.setModel(new AvailableTablesModel(tableClosure));
        if (!(availableTablesList.getCellRenderer() instanceof AvailableTableRenderer)) {
            availableTablesList.setCellRenderer(new AvailableTableRenderer());
        }
    }

    public static void connectSelected(JList selectedTablesList, TableClosure tableClosure) {
        selectedTablesList.setModel(new SelectedTablesModel(tableClosure));
        if (!(selectedTablesList.getCellRenderer() instanceof SelectedTableRenderer)) {
            selectedTablesList.setCellRenderer(new SelectedTableRenderer());
        }
    }

    public static Set<Table> getSelectedTables(JList list) {
        HashSet<Table> result = new HashSet<Table>();
        Object[] selectedValues = list.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            result.add((Table)selectedValues[i]);
        }
        return result;
    }

    public static void connectClassNames(JTable table, SelectedTables selectedTables) {
        table.setModel(new TableClassNamesModel(selectedTables));
        TableUISupport.setRenderer(table.getColumnModel().getColumn(0));
        TableUISupport.setRenderer(table.getColumnModel().getColumn(1));
    }

    private static void setRenderer(TableColumn column) {
        if (!(column.getCellRenderer() instanceof TableClassNameRenderer)) {
            column.setCellRenderer(new TableClassNameRenderer());
        }
    }

    private static final class TableClassNameRenderer
    extends DefaultTableCellRenderer {
        private static Color errorForeground = UIManager.getColor("nb.errorForeground");
        private static Color nonErrorForeground;

        private TableClassNameRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean joinTable = false;
            boolean validClass = true;
            String problemDisplayName = null;
            if (jTable.getModel() instanceof TableClassNamesModel) {
                TableClassNamesModel model = (TableClassNamesModel)jTable.getModel();
                Table table = model.getTableAt(row);
                joinTable = table.isJoin();
                if (column == 1 && !(validClass = model.isValidClass(table))) {
                    problemDisplayName = model.getProblemDisplayName(table);
                }
            }
            Object realValue = null;
            realValue = joinTable && column == 1 ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTable") : value;
            JComponent component = (JComponent)super.getTableCellRendererComponent(jTable, realValue, isSelected, hasFocus, row, column);
            component.setEnabled(!joinTable);
            component.setToolTipText(joinTable ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTableDescription") : problemDisplayName);
            component.setForeground(validClass ? nonErrorForeground : errorForeground);
            return component;
        }

        static {
            if (errorForeground == null) {
                errorForeground = Color.RED;
            }
            nonErrorForeground = UIManager.getColor("Label.foreground");
        }
    }

    private static final class TableClassNamesModel
    extends AbstractTableModel {
        private SelectedTables selectedTables;
        private final List<Table> tables;

        public TableClassNamesModel(SelectedTables selectedTables) {
            this.selectedTables = selectedTables;
            this.tables = selectedTables.getTables();
        }

        public Table getTableAt(int rowIndex) {
            return this.tables.get(rowIndex);
        }

        public boolean isValidClass(Table table) {
            return !this.selectedTables.hasProblem(table);
        }

        public String getProblemDisplayName(Table table) {
            return this.selectedTables.getProblemDisplayNameForTable(table);
        }

        public int getRowCount() {
            return this.tables.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.tables.get(rowIndex).getName();
                }
                case 1: {
                    Table table = this.tables.get(rowIndex);
                    return this.selectedTables.getClassName(table);
                }
            }
            assert (false);
            return null;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return;
            }
            Table table = this.tables.get(rowIndex);
            this.selectedTables.setClassName(table, (String)value);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Table table = this.tables.get(rowIndex);
            return !table.isJoin() && columnIndex == 1;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_DatabaseTable");
                }
                case 1: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_ClassName");
                }
            }
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectedTableRenderer
    extends DefaultListCellRenderer {
        private SelectedTableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Table table = null;
            Object displayName = null;
            boolean referenced = false;
            TableClosure tableClosure = null;
            if (value instanceof Table) {
                table = (Table)value;
                displayName = table.getName();
                if (list.getModel() instanceof SelectedTablesModel) {
                    SelectedTablesModel model = (SelectedTablesModel)list.getModel();
                    tableClosure = model.getTableClosure();
                    referenced = tableClosure.getReferencedTables().contains(table);
                }
            } else {
                displayName = value;
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            component.setEnabled(!referenced);
            component.setToolTipText(referenced ? SelectedTableRenderer.getTableTooltip(table, tableClosure) : null);
            return component;
        }

        private static String getTableTooltip(Table table, TableClosure tableClosure) {
            String bundleKey;
            Set<Table> relatedTables;
            ArrayList<Table> tables = new ArrayList<Table>();
            if (table.isJoin()) {
                relatedTables = table.getReferencedTables();
                bundleKey = "LBL_RelatedTableJoin";
            } else {
                relatedTables = table.getReferencedByTables();
                bundleKey = "LBL_RelatedTableRefBy";
            }
            for (Table refTable : relatedTables) {
                if (!tableClosure.getSelectedTables().contains(refTable)) continue;
                tables.add(refTable);
            }
            return NbBundle.getMessage(TableUISupport.class, (String)bundleKey, (Object)SelectedTableRenderer.createTableList(tables));
        }

        private static String createTableList(List<Table> tables) {
            assert (tables.size() > 0);
            if (tables.size() == 1) {
                return tables.iterator().next().getName();
            }
            Collections.sort(tables);
            String separator = NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableListSep");
            Iterator<Table> i = tables.iterator();
            StringBuilder builder = new StringBuilder(i.next().getName());
            String lastTable = i.next().getName();
            while (i.hasNext()) {
                builder.append(separator);
                builder.append(lastTable);
                lastTable = i.next().getName();
            }
            return NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableList", (Object)builder.toString(), (Object)lastTable);
        }
    }

    private static final class AvailableTableRenderer
    extends DefaultListCellRenderer {
        private AvailableTableRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Table.DisabledReason disabledReason = null;
            String displayName = null;
            if (value instanceof Table) {
                Table tableItem = (Table)value;
                disabledReason = tableItem.getDisabledReason();
                displayName = disabledReason != null ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableNameWithDisabledReason", (Object)tableItem.getName(), (Object)disabledReason.getDisplayName()) : tableItem.getName();
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            component.setEnabled(disabledReason == null);
            component.setToolTipText(disabledReason != null ? disabledReason.getDescription() : null);
            return component;
        }
    }

    private static final class SelectedTablesModel
    extends AbstractListModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public SelectedTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        public Object getElementAt(int index) {
            return this.displayTables.get(index);
        }

        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        public void stateChanged(ChangeEvent event) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getSelectedTables());
            Collections.sort(this.displayTables);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }

        public TableClosure getTableClosure() {
            return this.tableClosure;
        }
    }

    private static final class AvailableTablesModel
    extends AbstractListModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public AvailableTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        public Object getElementAt(int index) {
            return this.displayTables.get(index);
        }

        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        public void stateChanged(ChangeEvent event) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getAvailableTables());
            Collections.sort(this.displayTables);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }
    }
}

