/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class LogSupport {
    private Map links = Collections.synchronizedMap(new HashMap());
    private Annotation errAnnot;

    public Link getLink(String errorMsg, String path, int line) {
        Link newLink = new Link(errorMsg, path, line);
        Link cachedLink = (Link)this.links.get(newLink);
        if (cachedLink != null) {
            return cachedLink;
        }
        this.links.put(newLink, newLink);
        return newLink;
    }

    public void detachAnnotation() {
        if (this.errAnnot != null) {
            this.errAnnot.detach();
        }
    }

    public class Link
    implements OutputListener {
        private String msg;
        private String path;
        private int line;
        private int hashCode = 0;

        Link(String msg, String path, int line) {
            this.msg = msg;
            this.path = path;
            this.line = line;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.line;
                result = 37 * result + (this.path != null ? this.path.hashCode() : 0);
                this.hashCode = result = 37 * result + (this.msg != null ? this.msg.hashCode() : 0);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Link) {
                Link anotherLink = (Link)obj;
                if ((this.msg != null && this.msg.equals(anotherLink.msg) || this.msg == anotherLink.msg) && (this.path != null && this.path.equals(anotherLink.path) || this.path == anotherLink.path) && this.line == anotherLink.line) {
                    return true;
                }
            }
            return false;
        }

        public void outputLineAction(OutputEvent ev) {
            FileObject sourceFile = GlobalPathRegistry.getDefault().findResource(this.path);
            if (sourceFile == null) {
                sourceFile = FileUtil.toFileObject((File)new File(this.path));
            }
            DataObject dataObject = null;
            if (sourceFile != null) {
                try {
                    dataObject = DataObject.find((FileObject)sourceFile);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (dataObject != null) {
                String errorMsg;
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                editorCookie.open();
                Line errorLine = null;
                try {
                    errorLine = editorCookie.getLineSet().getCurrent(this.line - 1);
                }
                catch (IndexOutOfBoundsException iobe) {
                    return;
                }
                if (LogSupport.this.errAnnot != null) {
                    LogSupport.this.errAnnot.detach();
                }
                if ((errorMsg = this.msg) == null || errorMsg.equals("")) {
                    errorMsg = NbBundle.getMessage(Link.class, (String)"MSG_ExceptionOccurred");
                }
                LogSupport.this.errAnnot = new ErrorAnnotation(errorMsg);
                LogSupport.this.errAnnot.attach((Annotatable)errorLine);
                LogSupport.this.errAnnot.moveToFront();
                errorLine.show(0);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            if (LogSupport.this.errAnnot != null) {
                LogSupport.this.errAnnot.detach();
            }
            if (!LogSupport.this.links.isEmpty()) {
                LogSupport.this.links.clear();
            }
        }

        public void outputLineSelected(OutputEvent ev) {
        }
    }

    static class ErrorAnnotation
    extends Annotation {
        private String shortDesc = null;

        public ErrorAnnotation(String desc) {
            this.shortDesc = desc;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-tomcat5-error";
        }

        public String getShortDescription() {
            return this.shortDesc;
        }
    }

    public static class LineInfo {
        private String path;
        private int line;
        private String message;
        private boolean error;
        private boolean accessible;

        public LineInfo(String path, int line, String message, boolean error, boolean accessible) {
            this.path = path;
            this.line = line;
            this.message = message;
            this.error = error;
            this.accessible = accessible;
        }

        public String path() {
            return this.path;
        }

        public int line() {
            return this.line;
        }

        public String message() {
            return this.message;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isAccessible() {
            return this.accessible;
        }

        public String toString() {
            return "path=" + this.path + " line=" + this.line + " message=" + this.message + " isError=" + this.error + " isAccessible=" + this.accessible;
        }
    }
}

