/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.webservices.ui.WebServiceNode;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class WebServicesChildren
extends Children.Keys
implements PropertyChangeListener {
    Webservices webServices;
    WebServicesSupport wsSupport;
    FileObject srcRoot;
    DDProvider wsDDProvider;
    FileObject ddFolder;
    FileChangeListener ddFolderListener;

    public WebServicesChildren(FileObject srcRoot) {
        this.srcRoot = srcRoot;
        Project project = FileOwnerQuery.getOwner((FileObject)srcRoot);
        this.wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)project.getProjectDirectory());
        this.wsDDProvider = DDProvider.getDefault();
        this.ddFolderListener = new DDFolderFileChangeListener();
    }

    protected void addNotify() {
        super.addNotify();
        this.ddFolder = this.wsSupport.getWsDDFolder();
        if (this.ddFolder != null) {
            this.ddFolder.addFileChangeListener(this.ddFolderListener);
            FileObject wsDD = this.ddFolder.getFileObject("webservices", "xml");
            if (wsDD != null) {
                try {
                    this.webServices = this.wsDDProvider.getDDRoot(this.wsSupport.getWebservicesDD());
                    this.webServices.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IOException e) {
                    this.webServices = null;
                }
            }
            this.updateKeys();
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        if (this.ddFolder != null) {
            this.ddFolder.removeFileChangeListener(this.ddFolderListener);
        }
        super.removeNotify();
    }

    private void updateKeys() {
        ArrayList<WebServiceWrapper> keys = new ArrayList<WebServiceWrapper>();
        try {
            this.webServices = this.wsDDProvider.getDDRoot(this.wsSupport.getWebservicesDD());
        }
        catch (IOException e) {
            this.webServices = null;
        }
        if (this.webServices != null) {
            WebserviceDescription[] webServiceDescriptions = this.webServices.getWebserviceDescription();
            for (int i = 0; i < webServiceDescriptions.length; ++i) {
                WebserviceDescription webServiceDescription = webServiceDescriptions[i];
                WebServiceWrapper key = new WebServiceWrapper(webServiceDescription);
                keys.add(key);
            }
        }
        this.setKeys(keys);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WebServiceWrapper) {
            WebServiceWrapper wrapper = (WebServiceWrapper)key;
            return new Node[]{new WebServiceNode(this.webServices, wrapper.getWebServiceDescription(), this.srcRoot)};
        }
        return new Node[0];
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateKeys();
    }

    class DDFolderFileChangeListener
    extends FileChangeAdapter {
        DDFolderFileChangeListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject fo = fe.getFile();
            if (fo.getNameExt().equals("webservices.xml")) {
                try {
                    WebServicesChildren.this.webServices = WebServicesChildren.this.wsDDProvider.getDDRoot(WebServicesChildren.this.wsSupport.getWebservicesDD());
                    WebServicesChildren.this.webServices.addPropertyChangeListener((PropertyChangeListener)WebServicesChildren.this);
                }
                catch (IOException e) {
                    WebServicesChildren.this.webServices = null;
                }
            }
        }
    }

    static class WebServiceWrapper {
        WebserviceDescription webServiceDescription;

        public WebServiceWrapper(WebserviceDescription webServiceDescription) {
            this.webServiceDescription = webServiceDescription;
        }

        public WebserviceDescription getWebServiceDescription() {
            return this.webServiceDescription;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WebServiceWrapper) {
                WebServiceWrapper otherObject = (WebServiceWrapper)obj;
                return this.getWebServiceDescription().getWebserviceDescriptionName().equals(otherObject.getWebServiceDescription().getWebserviceDescriptionName());
            }
            return false;
        }

        public int hashCode() {
            return this.getWebServiceDescription().getWebserviceDescriptionName().hashCode();
        }
    }
}

