/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanel;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class SQLCloneableEditor
extends CloneableEditor {
    private transient JPanel container;
    private transient JSplitPane splitter;
    private transient SQLResultPanel resultComponent;
    private transient SQLExecutionImpl sqlExecution;
    private transient Lookup originalLookup;
    private transient InstanceContent instanceContent = new InstanceContent();
    private transient Lookup ourLookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private transient SQLCloneableEditorLookup resultingLookup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SQLCloneableEditor() {
        super(null);
    }

    public SQLCloneableEditor(SQLEditorSupport support) {
        super((CloneableEditorSupport)support);
        this.initialize();
    }

    public boolean hasResultComponent() {
        return this.resultComponent != null;
    }

    public SQLResultPanel getResultComponent() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.resultComponent == null) {
            this.createResultComponent();
        }
        return this.resultComponent;
    }

    private void createResultComponent() {
        JPanel container = this.findContainer((Component)((Object)this));
        if (container == null) {
            return;
        }
        Component editor = container.getComponent(0);
        container.removeAll();
        this.resultComponent = new SQLResultPanel();
        this.splitter = new JSplitPane(0, editor, this.resultComponent);
        this.splitter.setBorder(null);
        container.add(this.splitter);
        this.splitter.setDividerLocation(250);
        this.splitter.setDividerSize(7);
        container.invalidate();
        container.validate();
        container.repaint();
        this.getActionMap().setParent(new DelegateActionMap(this.getActionMap().getParent(), this.getEditorPane()));
        if (((Object)((Object)this)).equals(TopComponent.getRegistry().getActivated())) {
            this.requestFocusInWindow();
        }
    }

    private JPanel findContainer(Component parent) {
        if (!(parent instanceof JComponent)) {
            return null;
        }
        Component[] components = ((JComponent)parent).getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JPanel && "sqlEditorContainer".equals(component.getName())) {
                return (JPanel)component;
            }
            JPanel container = this.findContainer(component);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    public synchronized Lookup getLookup() {
        Lookup currentLookup = super.getLookup();
        if (currentLookup != this.originalLookup) {
            this.originalLookup = currentLookup;
            if (this.resultingLookup == null) {
                this.resultingLookup = new SQLCloneableEditorLookup();
            }
            this.resultingLookup.updateLookups(new Lookup[]{this.originalLookup, this.ourLookup});
        }
        return this.resultingLookup;
    }

    protected void componentDeactivated() {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        super.componentDeactivated();
    }

    protected void componentClosed() {
        this.sqlExecution.editorClosed();
        super.componentClosed();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        super.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.initialize();
    }

    private void initialize() {
        this.sqlExecution = new SQLExecutionImpl();
        this.instanceContent.add((Object)this.sqlExecution);
    }

    private SQLEditorSupport sqlEditorSupport() {
        return (SQLEditorSupport)this.cloneableEditorSupport();
    }

    static {
        $assertionsDisabled = !SQLCloneableEditor.class.desiredAssertionStatus();
    }

    private final class SQLExecutionImpl
    implements SQLExecution,
    PropertyChangeListener {
        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

        public SQLExecutionImpl() {
            SQLCloneableEditor.this.sqlEditorSupport().addSQLPropertyChangeListener(this);
        }

        private void editorClosed() {
            SQLCloneableEditor.this.sqlEditorSupport().removeSQLPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.propChangeSupport.firePropertyChange(event);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.removePropertyChangeListener(listener);
        }

        public DatabaseConnection getDatabaseConnection() {
            return SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection();
        }

        public void setDatabaseConnection(DatabaseConnection dbconn) {
            SQLCloneableEditor.this.sqlEditorSupport().setDatabaseConnection(dbconn);
        }

        public void execute() {
            String text = (String)Mutex.EVENT.readAccess(new Mutex.Action(){

                public Object run() {
                    return SQLExecutionImpl.this.getText(SQLCloneableEditor.this.getEditorPane());
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(text, 0, text.length());
        }

        public void executeSelection() {
            final int[] offsets = new int[2];
            String text = (String)Mutex.EVENT.readAccess(new Mutex.Action(){

                public Object run() {
                    int endOffset;
                    JEditorPane editorPane = SQLCloneableEditor.this.getEditorPane();
                    int startOffset = editorPane.getSelectionStart();
                    if (startOffset == (endOffset = editorPane.getSelectionEnd())) {
                        offsets[0] = offsets[1] = editorPane.getCaretPosition();
                    } else {
                        offsets[0] = startOffset;
                        offsets[1] = endOffset;
                    }
                    return SQLExecutionImpl.this.getText(editorPane);
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(text, offsets[0], offsets[1]);
        }

        public boolean isExecuting() {
            return SQLCloneableEditor.this.sqlEditorSupport().isExecuting();
        }

        public boolean isSelection() {
            Boolean result = (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

                public Object run() {
                    JEditorPane editorPane = SQLCloneableEditor.this.getEditorPane();
                    return editorPane.getSelectionStart() < editorPane.getSelectionEnd();
                }
            });
            return result;
        }

        public String toString() {
            return "SQLExecution[support=" + SQLCloneableEditor.this.sqlEditorSupport().messageName() + ", dbconn=" + SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection() + "]";
        }

        private String getText(JEditorPane editorPane) {
            Document doc = editorPane.getDocument();
            try {
                return doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return "";
            }
        }
    }

    private static final class SQLCloneableEditorLookup
    extends ProxyLookup {
        public SQLCloneableEditorLookup() {
            super(new Lookup[0]);
        }

        public void updateLookups(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }

    private static final class DelegateActionMap
    extends ActionMap {
        private ActionMap delegate;
        private JEditorPane editorPane;

        public DelegateActionMap(ActionMap delegate, JEditorPane editorPane) {
            this.delegate = delegate;
            this.editorPane = editorPane;
        }

        public void remove(Object key) {
            super.remove(key);
        }

        public Action get(Object key) {
            boolean isEditorPaneFocused;
            boolean bl = isEditorPaneFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this.editorPane;
            if (isEditorPaneFocused) {
                return this.delegate.get(key);
            }
            return null;
        }

        public void put(Object key, Action action) {
            this.delegate.put(key, action);
        }

        public void setParent(ActionMap map) {
            this.delegate.setParent(map);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] keys() {
            return this.delegate.keys();
        }

        public ActionMap getParent() {
            return this.delegate.getParent();
        }

        public void clear() {
            this.delegate.clear();
        }

        public Object[] allKeys() {
            return this.delegate.allKeys();
        }
    }
}

