/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.SafeModule;
import org.netbeans.updater.UpdateTracking;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class L10NUpdate
extends ModuleUpdate {
    private static final String ATTR_LONG_DESC = "OpenIDE-Module-Long-Description";
    private String langcode;
    private String brandingcode;
    private SpecificationVersion specversion;
    private int majorversion;
    private String l10nname;
    private String l10ndesc;
    private L10NModuleInfo remoteinfo;

    L10NUpdate(URL xmlURL, Node node, Element documentElement) {
        super(xmlURL, node, documentElement);
    }

    L10NUpdate(File nbmFile, Node node, Element documentElement) {
        super(nbmFile, node, documentElement);
    }

    ModuleInfo readRemoteInfo() throws IllegalArgumentException {
        NodeList nodeList = ((Element)this.getNode()).getElementsByTagName("l10n");
        if (nodeList.getLength() > 0) {
            Node n = nodeList.item(0);
            this.langcode = this.getAttribute(n, "langcode");
            this.brandingcode = this.getAttribute(n, "brandingcode");
            this.specversion = new SpecificationVersion(this.getAttribute(n, "module_spec_version"));
            String mvAttr = this.getAttribute(n, "module_major_version");
            this.majorversion = mvAttr != null ? Integer.parseInt(mvAttr) : -1;
            this.l10nname = this.getAttribute(n, "OpenIDE-Module-Name");
            this.l10ndesc = this.getAttribute(n, ATTR_LONG_DESC);
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription(this.l10ndesc);
            }
        }
        this.remoteinfo = new L10NModuleInfo();
        this.remoteinfo.setName(this.l10nname);
        this.remoteinfo.setCodeNameBase(this.getInfoCodenamebase());
        this.remoteinfo.setMajorversion(this.majorversion);
        this.remoteinfo.setSpecificationVersion(this.specversion);
        this.remoteinfo.setDependency(this.getInfoCodenamebase(), this.majorversion);
        return this.remoteinfo;
    }

    ModuleInfo readLocalInfo() {
        ModuleInfo localmodule = super.readLocalInfo();
        L10NModuleInfo localinfo = null;
        if (localmodule != null) {
            SafeModule.ModuleStatus status;
            if (this.l10nname == null || this.l10nname.equals("")) {
                this.remoteinfo.setName(localmodule.getDisplayName());
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription((String)localmodule.getLocalizedAttribute(ATTR_LONG_DESC));
            }
            if ((status = SafeModule.getModuleStatus(this.getInfoCodenamebase())) != null) {
                String jarpath = status.getJarPath() + "locale/" + status.getJarName();
                if (this.brandingcode != null && this.brandingcode.length() > 0) {
                    jarpath = jarpath + "_" + this.brandingcode;
                }
                if (this.langcode != null && this.langcode.length() > 0) {
                    jarpath = jarpath + "_" + this.langcode;
                }
                jarpath = jarpath + ".jar";
                SpecificationVersion specvers = this.getTrackingSpecVersion(jarpath);
                localinfo = new L10NModuleInfo();
                localinfo.setName(this.remoteinfo.getDisplayName());
                localinfo.setCodeNameBase(this.getInfoCodenamebase());
                if (specvers != null) {
                    localinfo.setSpecificationVersion(specvers);
                }
            }
            this.markNamesWithL10N();
        }
        return localinfo;
    }

    private void markNamesWithL10N() {
        String desc = "";
        if (this.langcode != null && this.langcode.length() > 0) {
            String lang = new Locale(this.langcode, "").getDisplayLanguage();
            desc = NbBundle.getMessage((Class)L10NUpdate.class, (String)"TXT_L10N_Prefix", (Object)lang);
        }
        if (this.brandingcode != null && this.brandingcode.length() > 0) {
            if (this.langcode != null && this.langcode.length() > 0) {
                desc = desc + ", ";
            }
            desc = desc + NbBundle.getMessage((Class)L10NUpdate.class, (String)"TXT_L10N_Branding", (Object)this.brandingcode);
        }
        if (desc.length() > 0) {
            desc = desc + NbBundle.getMessage((Class)L10NUpdate.class, (String)"TXT_L10N_DescEnd");
        }
        desc = desc + this.getDescription();
        this.setDescription(desc);
        if (this.l10nname == null || this.l10nname.equals("")) {
            String dname = this.remoteinfo.getDisplayName() + " (";
            if (this.langcode != null && this.langcode.length() > 0) {
                dname = dname + this.langcode;
            }
            if (this.brandingcode != null && this.brandingcode.length() > 0) {
                if (this.langcode != null && this.langcode.length() > 0) {
                    dname = dname + " ";
                }
                dname = dname + this.brandingcode;
            }
            dname = dname + ")";
            this.remoteinfo.setName(dname);
        }
    }

    private SpecificationVersion getTrackingSpecVersion(String jarpath) {
        Iterator it = UpdateTracking.clusters(true).iterator();
        while (it.hasNext()) {
            SpecificationVersion svI;
            File clusterDir = (File)it.next();
            UpdateTracking tracking = UpdateTracking.getTracking(clusterDir, false);
            if (tracking == null) continue;
            String specversU = tracking.getL10NSpecificationVersion(this.getInfoCodenamebase(), true, jarpath);
            String specversI = tracking.getL10NSpecificationVersion(this.getInfoCodenamebase(), false, jarpath);
            if (specversU == null && specversI == null) continue;
            SpecificationVersion svU = specversU != null ? new SpecificationVersion(specversU) : null;
            SpecificationVersion specificationVersion = svI = specversI != null ? new SpecificationVersion(specversI) : null;
            if (svI != null && svU == null) {
                return svI;
            }
            if (svI == null && svU != null) {
                return svU;
            }
            if (svI.compareTo((Object)svU) > 0) {
                return svI;
            }
            return svU;
        }
        return null;
    }

    private String getAttribute(Node n, String attribute) {
        Node attr = n.getAttributes().getNamedItem(attribute);
        return attr == null ? null : attr.getNodeValue();
    }

    String getLangcode() {
        return this.langcode;
    }

    String getBrandingcode() {
        return this.brandingcode;
    }

    int getMajorversion() {
        return this.majorversion;
    }

    String getL10nname() {
        return this.l10nname;
    }

    String getL10ndesc() {
        return this.l10ndesc;
    }

    boolean isUpdateAvailable() {
        return this.getLocalModule() != null && (this.getLocalModule().getSpecificationVersion() == null || this.getLocalModule().getSpecificationVersion().compareTo((Object)this.remoteinfo.getSpecificationVersion()) < 0);
    }

    boolean isRemoteModuleAvailable(List modules) {
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            ModuleUpdate module = (ModuleUpdate)it.next();
            if (!module.getCodeNameBase().equals(this.remoteinfo.getCodeNameBase()) || module.getRemoteModule().getSpecificationVersion().compareTo((Object)this.remoteinfo.getSpecificationVersion()) > 0) continue;
            if (this.remoteinfo.getDisplayName() == null || this.remoteinfo.getDisplayName().equals("")) {
                this.remoteinfo.setName(module.getRemoteModule().getDisplayName());
            }
            if (this.getDescription() == null || this.getDescription().equals("")) {
                this.setDescription((String)module.getRemoteModule().getLocalizedAttribute(ATTR_LONG_DESC));
            }
            this.markNamesWithL10N();
            return true;
        }
        return false;
    }

    class L10NModuleInfo
    extends ModuleInfo {
        private SpecificationVersion specversion;
        private String name;
        private Set dep;
        private String codenamebase;
        private int majorversion;

        void setSpecificationVersion(SpecificationVersion specversion) {
            this.specversion = specversion;
        }

        void setName(String name) {
            this.name = name;
        }

        void setCodeNameBase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        void setMajorversion(int majorversion) {
            this.majorversion = majorversion;
        }

        void setDependency(String codenamebase, int majorversion) {
            String body = codenamebase;
            if (majorversion > 0) {
                body = body + "/" + majorversion;
            }
            this.dep = Dependency.create((int)1, (String)body);
        }

        public SpecificationVersion getSpecificationVersion() {
            return this.specversion;
        }

        public String getDisplayName() {
            return this.name;
        }

        public Object getAttribute(String attr) {
            return null;
        }

        public String getCodeName() {
            return this.codenamebase + "/" + this.majorversion;
        }

        public String getCodeNameBase() {
            return this.codenamebase;
        }

        public int getCodeNameRelease() {
            return this.majorversion;
        }

        public Set getDependencies() {
            return this.dep;
        }

        public Object getLocalizedAttribute(String attr) {
            return null;
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean owns(Class clazz) {
            return false;
        }
    }
}

