/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.file;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileReader;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiFileFormat;

public class StandardMidiFileReader
extends MidiFileReader {
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_ONE_BYTE = 1;
    private static final int STATUS_TWO_BYTES = 2;
    private static final int STATUS_SYSEX = 3;
    private static final int STATUS_META = 4;

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 1297377380) {
            throw new InvalidMidiDataException("not a MIDI file: wrong header magic");
        }
        int n2 = dataInputStream.readInt();
        if (n2 < 6) {
            throw new InvalidMidiDataException("corrupt MIDI file: wrong header length");
        }
        short s = dataInputStream.readShort();
        if (s < 0 || s > 2) {
            throw new InvalidMidiDataException("corrupt MIDI file: illegal type");
        }
        if (s == 2) {
            throw new InvalidMidiDataException("this implementation doesn't support type 2 MIDI files");
        }
        short s2 = dataInputStream.readShort();
        if (s2 <= 0) {
            throw new InvalidMidiDataException("corrupt MIDI file: number of tracks must be positive");
        }
        if (s == 0 && s2 != 1) {
            throw new InvalidMidiDataException("corrupt MIDI file:  type 0 files must contain exactely one track");
        }
        int n3 = dataInputStream.readUnsignedShort();
        float f = -1.0f;
        int n4 = -1;
        if ((n3 & 0x8000) != 0) {
            int n5 = -(n3 >>> 8 & 0xFF);
            switch (n5) {
                case 24: {
                    f = 24.0f;
                    break;
                }
                case 25: {
                    f = 25.0f;
                    break;
                }
                case 29: {
                    f = 29.97f;
                    break;
                }
                case 30: {
                    f = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("corrupt MIDI file: illegal frame division type");
                }
            }
            n4 = n3 & 0xFF;
        } else {
            f = 0.0f;
            n4 = n3 & Short.MAX_VALUE;
        }
        dataInputStream.skip(n2 - 6);
        TMidiFileFormat tMidiFileFormat = new TMidiFileFormat(s, f, n4, -1, -1, s2);
        return tMidiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            midiFileFormat = this.getMidiFileFormat(inputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            midiFileFormat = this.getMidiFileFormat(fileInputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return midiFileFormat;
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = uRL.openStream();
        try {
            return this.getSequence(inputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(invalidMidiDataException);
            }
            inputStream.close();
            throw invalidMidiDataException;
        }
        catch (IOException iOException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(iOException);
            }
            inputStream.close();
            throw iOException;
        }
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getSequence(fileInputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(invalidMidiDataException);
            }
            ((InputStream)fileInputStream).close();
            throw invalidMidiDataException;
        }
        catch (IOException iOException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(iOException);
            }
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
        Sequence sequence = new Sequence(midiFileFormat.getDivisionType(), midiFileFormat.getResolution());
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = ((TMidiFileFormat)midiFileFormat).getTrackCount();
        int n2 = 0;
        while (n2 < n) {
            Track track = sequence.createTrack();
            this.readTrack(dataInputStream, track);
            ++n2;
        }
        return sequence;
    }

    private final void readTrack(DataInputStream dataInputStream, Track track) throws InvalidMidiDataException, IOException {
        int n;
        while ((n = dataInputStream.readInt()) != 1297379947) {
            int n2 = dataInputStream.readInt();
            if (n2 % 2 != 0) {
                ++n2;
            }
            dataInputStream.skip(n2);
        }
        n = dataInputStream.readInt();
        long l = 0L;
        long[] lArray = new long[]{n};
        int[] nArray = new int[]{-1};
        while (lArray[0] > 0L) {
            long l2 = StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, lArray);
            MidiEvent midiEvent = StandardMidiFileReader.readEvent(dataInputStream, lArray, nArray, l += l2);
            track.add(midiEvent);
        }
    }

    private static final MidiEvent readEvent(DataInputStream dataInputStream, long[] lArray, int[] nArray, long l) throws InvalidMidiDataException, IOException {
        int n = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
        MidiMessage midiMessage = null;
        boolean bl = false;
        int n2 = 0;
        if (n < 128) {
            if (nArray[0] != -1) {
                bl = true;
                n2 = n;
                n = nArray[0];
            } else {
                throw new InvalidMidiDataException("corrupt MIDI file: status byte missing");
            }
        }
        switch (StandardMidiFileReader.getType(n)) {
            case 1: {
                int n3 = 0;
                if (bl) {
                    n3 = n2;
                } else {
                    n3 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                    nArray[0] = n;
                }
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(n, n3, 0);
                midiMessage = shortMessage;
                break;
            }
            case 2: {
                int n4 = 0;
                if (bl) {
                    n4 = n2;
                } else {
                    n4 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                    nArray[0] = n;
                }
                int n5 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                ShortMessage shortMessage = new ShortMessage();
                shortMessage.setMessage(n, n4, n5);
                midiMessage = shortMessage;
                break;
            }
            case 3: {
                if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                    nArray[0] = -1;
                }
                int n6 = (int)StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, lArray);
                byte[] byArray = new byte[n6];
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                    byArray[n7] = (byte)n8;
                    ++n7;
                }
                SysexMessage sysexMessage = new SysexMessage();
                sysexMessage.setMessage(n, byArray, n6);
                midiMessage = sysexMessage;
                break;
            }
            case 4: {
                if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                    nArray[0] = -1;
                }
                int n9 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                int n10 = (int)StandardMidiFileReader.readVariableLengthQuantity(dataInputStream, lArray);
                byte[] byArray = new byte[n10];
                int n11 = 0;
                while (n11 < n10) {
                    int n12 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
                    byArray[n11] = (byte)n12;
                    ++n11;
                }
                MetaMessage metaMessage = new MetaMessage();
                metaMessage.setMessage(n9, byArray, n10);
                midiMessage = metaMessage;
                break;
            }
        }
        MidiEvent midiEvent = new MidiEvent(midiMessage, l);
        return midiEvent;
    }

    private static final int getType(int n) {
        if (n < 240) {
            int n2 = n & 0xF0;
            switch (n2) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 224: {
                    return 2;
                }
                case 192: 
                case 208: {
                    return 1;
                }
            }
            return 0;
        }
        if (n == 240 || n == 247) {
            return 3;
        }
        if (n == 255) {
            return 4;
        }
        return 0;
    }

    public static long readVariableLengthQuantity(DataInputStream dataInputStream, long[] lArray) throws InvalidMidiDataException, IOException {
        long l = 0L;
        int n = 0;
        while (n < 4) {
            int n2 = StandardMidiFileReader.readUnsignedByte(dataInputStream, lArray);
            ++n;
            l <<= 7;
            l |= (long)(n2 & 0x7F);
            if (n2 >= 128) continue;
            return l;
        }
        throw new InvalidMidiDataException("not a MIDI file: unterminated variable-length quantity");
    }

    public static int readUnsignedByte(DataInputStream dataInputStream, long[] lArray) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        lArray[0] = lArray[0] - 1L;
        return n;
    }
}

