/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.DataOutput;
import java.io.IOException;

class BitBuffer {
    private static final int InitSize = 256;
    private static final int NBits = 32;
    private static final int BitsInByte = 8;
    private static final int BytesInInt = 4;
    private int _avail = 32;
    private int _word = 0;
    private int _free = 0;
    private int _size = 256;
    private int[] _array = new int[256];

    BitBuffer() {
    }

    public void append(int n) {
        this._word = this._word << 1 | n;
        if (--this._avail == 0) {
            this.store(this._word);
            this._word = 0;
            this._avail = 32;
        }
    }

    public void append(int n, int n2) {
        if (n2 < this._avail) {
            this._word = this._word << n2 | n;
            this._avail -= n2;
        } else if (n2 > this._avail) {
            int n3 = n2 - this._avail;
            this.store(this._word << this._avail | n >>> n3);
            this._word = n;
            this._avail = 32 - n3;
        } else {
            this.store(this._word << n2 | n);
            this._word = 0;
            this._avail = 32;
        }
    }

    public int bitCount() {
        return 32 * this._free - this._avail;
    }

    public int byteCount() {
        return this._free * 4 - this._avail / 8;
    }

    public void clear() {
        this._word = 0;
        this._avail = 32;
        this._free = 0;
    }

    public void close() {
        if (this._avail < 32) {
            this.store(this._word << this._avail);
        } else {
            this._avail = 0;
        }
    }

    public void concatenate(BitBuffer bitBuffer) {
        if (32 * (this._size - this._free) + this._avail < bitBuffer.bitCount()) {
            this.growArray(this._free + bitBuffer._free + 1);
        }
        if (this._avail == 0) {
            System.arraycopy(bitBuffer._array, 0, this._array, this._free, bitBuffer._free);
            this._avail = bitBuffer._avail;
            this._free += bitBuffer._free;
        } else {
            int n = this._free - 1;
            int n2 = 0;
            do {
                int n3 = n++;
                this._array[n3] = this._array[n3] | bitBuffer._array[n2] >>> 32 - this._avail;
                this._array[n] = bitBuffer._array[n2++] << this._avail;
            } while (n2 < bitBuffer._free);
            this._free += bitBuffer._free;
            if ((this._avail += bitBuffer._avail) >= 32) {
                this._avail -= 32;
                --this._free;
            }
        }
    }

    private void growArray(int n) {
        this._size = n;
        int[] nArray = new int[this._size];
        System.arraycopy(this._array, 0, nArray, 0, this._free);
        this._array = nArray;
    }

    public void setFrom(BitBuffer bitBuffer) {
        this._word = bitBuffer._word;
        this._avail = bitBuffer._avail;
        this._free = bitBuffer._free;
        if (this._free > this._size) {
            this._size = bitBuffer._free;
            this._array = new int[this._size];
        }
        System.arraycopy(bitBuffer._array, 0, this._array, 0, this._free);
    }

    private void store(int n) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = n;
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this._free - 1) {
            dataOutput.writeInt(this._array[n]);
            ++n;
        }
        int n2 = this._array[this._free - 1];
        int n3 = 4 - this._avail / 8;
        int n4 = 32;
        while (n3-- > 0) {
            dataOutput.writeByte(n2 >>> (n4 -= 8) & 0xFF);
        }
    }
}

