/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class ContextClassLoaderMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    private PrivilegedAction m_get = new GetContextClassLoaderAction();

    public String getType() {
        return "contextclassloader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                super.addNotificationListener(metadata, listener, filter, handback);
                Object var7_6 = null;
                this.setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        } else {
            super.addNotificationListener(metadata, listener, filter, handback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                super.removeNotificationListener(metadata, listener, filter, handback);
                Object var7_6 = null;
                this.setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        } else {
            super.removeNotificationListener(metadata, listener, filter, handback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                super.instantiate(metadata, className, params, args);
                Object var7_6 = null;
                this.setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        } else {
            super.instantiate(metadata, className, params, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                super.registration(metadata, operation);
                Object var5_4 = null;
                this.setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        } else {
            super.registration(metadata, operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                MBeanInfo mBeanInfo = super.getMBeanInfo(metadata);
                Object var5_4 = null;
                this.setContextClassLoader(cl);
                return mBeanInfo;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        }
        return super.getMBeanInfo(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                Object object = super.invoke(metadata, method, params, args);
                Object var8_7 = null;
                this.setContextClassLoader(cl);
                return object;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        }
        return super.invoke(metadata, method, params, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                AttributeList attributeList = super.getAttributes(metadata, attributes);
                Object var6_5 = null;
                this.setContextClassLoader(cl);
                return attributeList;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        }
        return super.getAttributes(metadata, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                AttributeList attributeList = super.setAttributes(metadata, attributes);
                Object var6_5 = null;
                this.setContextClassLoader(cl);
                return attributeList;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        }
        return super.setAttributes(metadata, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                Object object = super.getAttribute(metadata, attribute);
                Object var6_5 = null;
                this.setContextClassLoader(cl);
                return object;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        }
        return super.getAttribute(metadata, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        if (this.isEnabled()) {
            ClassLoader cl = this.getContextClassLoader();
            try {
                this.setContextClassLoader(metadata.classloader);
                super.setAttribute(metadata, attribute);
                Object var5_4 = null;
                this.setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setContextClassLoader(cl);
                throw throwable;
            }
        } else {
            super.setAttribute(metadata, attribute);
        }
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(this.m_get);
    }

    private void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private static class GetContextClassLoaderAction
    implements PrivilegedAction {
        private GetContextClassLoaderAction() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

