/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.server.extensions.internal;

import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;


/**
 * The main plugin class to be used in the desktop.
 */
public class ServerExtensionsPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static ServerExtensionsPlugin plugin;	
	//Resource bundle.
	private ResourceBundle resourceBundle;
	/** The name of our properties that are not needed during startup. */
	protected static final String PROPERTIES = "org/eclipse/wst/rdb/server/extensions/internal/nls/ServerExtensionsMessages"; //$NON-NLS-1$	
	/** A static reference to our resource bundle. */
	protected static ResourceBundle properties = null;	
	
	/**
	 * The constructor.
	 */
	public ServerExtensionsPlugin() {
		super();
		plugin = this;		
	}

	/**
	 * Returns the shared instance.
	 */
	public static ServerExtensionsPlugin getDefault() {
		return plugin;
	}

	/**
	    * Gets translated text with substitutions from the resource bundle.
	    * @param key The key specified in plugin.properties for the string.
	    * @param substitutions An Object array containing substitions for {0}, {1}, etc.
	    * @return The string value for the given key, with substitutions.
	    */
	   public static String getString(String key, Object[] substitutions)
	   {
	      String str = ServerExtensionsPlugin.getResourceBundle().getString(key);
	      if (substitutions != null)
	         str = MessageFormat.format(str, substitutions);
	      return str;
	   }


	 /**
	    * Gets the resource bundle for non-startup properties.
	    * @return The bundle named by #PROPERTIES.
	    */
	   public static ResourceBundle getResourceBundle()
	   {
	      if (properties == null)
	      {
	         try
	         {
	            properties = ResourceBundle.getBundle(PROPERTIES);
	         }
	         catch (java.util.MissingResourceException exception)
	         {
	            plugin.writeLog(IStatus.ERROR, 0, "ServerExtensionsPlugin:getResourceBundle.",exception); //$NON-NLS-1$
	         }
	      }
	      return properties;
	   }

	public static String getString(String key) {
		try {
			return ServerExtensionsPlugin.getResourceBundle().getString(key);
		} catch (MissingResourceException e) {
		    return '!' + key + '!';
		}
	}
	
	public static URL getInstallURL ()
	{
	     return getDefault().getBundle().getEntry("/"); //$NON-NLS-1$
	}
	
	/**
	 * This gets a .gif from the icons folder.
	 */
	public ImageDescriptor getImageDescriptor(String key) {
		try {
			return ImageDescriptor.createFromURL(
	        		new URL(
		               getInstallURL(),
		               "icons" + java.io.File.separator + key + ".gif")); //$NON-NLS-1$ //$NON-NLS-2$
			
		}
		catch (Exception e) {
	         writeLog(IStatus.ERROR, 0, e.getMessage(), e);
		}
		return null;
	}	

	/**
	 * Method writeLog.
	 * @param severity - the severity; one of IStatus.OK, IStatus.ERROR, IStatus.INFO, or IStatus.WARNING
	 * @param code - the plug-in-specific status code, or OK
	 * @param message - a human-readable message, localized to the current locale
	 * @param exception- a low-level exception, or null if not applicable
	*/
	public void writeLog(int severity, int code, String message, Throwable exception) {
	   if (message == null)
	       message = ""; //$NON-NLS-1$
	   getLog().log(new Status(severity, getUniqueIdentifier(), code, message, exception));
	}
	
	public static String getUniqueIdentifier()
	{
	     return getDefault().getBundle().getSymbolicName();
	}	

}
