/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPTranslationAdapter
implements INodeAdapter,
IDocumentListener {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jsptranslation"));
    private IDocument fJspDocument = null;
    private IDocument fJavaDocument = null;
    private JSPTranslationExtension fJSPTranslation = null;
    private boolean fDocumentIsDirty = true;
    private IDOMModel fXMLModel;
    private JSPTranslator fTranslator = null;
    private NullProgressMonitor fTranslationMonitor = null;
    static /* synthetic */ Class class$0;

    public JSPTranslationAdapter(IDOMModel xmlModel) {
        this.setXMLModel(xmlModel);
        this.initializeJavaPlugins();
    }

    protected void initializeJavaPlugins() {
        JavaCore.getPlugin();
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type.equals(clazz);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    private void setDocument(IDocument doc) {
        if (this.fJspDocument != null) {
            this.fJspDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (doc != null) {
            doc.addDocumentListener((IDocumentListener)this);
            this.fJspDocument = doc;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fDocumentIsDirty = true;
    }

    public void release() {
        if (this.fJspDocument != null) {
            this.fJspDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fTranslationMonitor != null) {
            this.fTranslationMonitor.setCanceled(true);
        }
        if (this.fJSPTranslation != null) {
            if (DEBUG) {
                System.out.println("JSPTranslationAdapter releasing:" + this.fJSPTranslation);
            }
            this.fJSPTranslation.release();
        }
    }

    public synchronized JSPTranslationExtension getJSPTranslation() {
        if (this.fJSPTranslation == null || this.fDocumentIsDirty) {
            JSPTranslator translator = null;
            if (this.getXMLModel() != null && this.getXMLModel().getIndexedRegion(0) != null) {
                translator = this.getTranslator((IDOMNode)this.getXMLModel().getIndexedRegion(0));
                translator.translate();
                StringBuffer javaContents = translator.getTranslation();
                this.fJavaDocument = new Document(javaContents.toString());
            } else {
                translator = new JSPTranslator();
                StringBuffer emptyContents = translator.getEmptyTranslation();
                this.fJavaDocument = new Document(emptyContents.toString());
            }
            if (this.fJSPTranslation != null) {
                if (DEBUG) {
                    System.out.println("JSPTranslationAdapter releasing:" + this.fJSPTranslation);
                }
                this.fJSPTranslation.release();
            }
            this.fJSPTranslation = new JSPTranslationExtension((IDocument)this.getXMLModel().getStructuredDocument(), this.fJavaDocument, this.getJavaProject(), translator);
            this.fDocumentIsDirty = false;
        }
        return this.fJSPTranslation;
    }

    private JSPTranslator getTranslator(IDOMNode xmlNode) {
        if (this.fTranslator == null) {
            this.fTranslationMonitor = new NullProgressMonitor();
            this.fTranslator = new JSPTranslator();
            this.fTranslator.reset(xmlNode, (IProgressMonitor)this.fTranslationMonitor);
        } else {
            this.fTranslator.reset(xmlNode, (IProgressMonitor)this.fTranslationMonitor);
        }
        return this.fTranslator;
    }

    public void setXMLModel(IDOMModel xmlModel) {
        this.fXMLModel = xmlModel;
        this.setDocument((IDocument)this.fXMLModel.getStructuredDocument());
    }

    private IDOMModel getXMLModel() {
        return this.fXMLModel;
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        try {
            String baseLocation = this.getXMLModel().getBaseLocation();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baseLocation);
            IProject project = null;
            if (filePath.segmentCount() > 0) {
                project = root.getProject(filePath.segment(0));
            }
            if (project != null) {
                javaProject = JavaCore.create(project);
            }
        }
        catch (Exception ex) {
            if (this.getXMLModel() != null) {
                Logger.logException("(JSPTranslationAdapter) problem getting java project from the XMLModel's baseLocation > " + this.getXMLModel().getBaseLocation(), ex);
            }
            Logger.logException("(JSPTranslationAdapter) problem getting java project", ex);
        }
        return javaProject;
    }
}

