/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public abstract class J2EEArtifactImportOperation
extends AbstractDataModelOperation {
    protected Archive moduleFile;
    protected IVirtualComponent virtualComponent;
    protected IAdaptable info;
    protected final int PROJECT_CREATION_WORK = 30;

    public J2EEArtifactImportOperation(IDataModel model) {
        super(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable anInfo) throws ExecutionException {
        IStatus iStatus;
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            this.info = anInfo;
            this.moduleFile = (Archive)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Importing_archive, new Object[]{this.moduleFile.getURI()}), this.computeTotalWork());
            this.doExecute(monitor);
            iStatus = OK_STATUS;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {}
            catch (Throwable throwable2) {
                Object var6_10 = null;
                J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
                this.model.dispose();
                monitor.done();
                throw throwable2;
            }
            if (this.virtualComponent != null) {
                J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.virtualComponent.getProject());
            }
            Object var6_11 = null;
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
            this.model.dispose();
            monitor.done();
            throw throwable;
        }
        try {
            if (this.virtualComponent != null) {
                J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.virtualComponent.getProject());
            }
            Object var6_9 = null;
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
            this.model.dispose();
            monitor.done();
            throw throwable;
        }
        this.model.dispose();
        monitor.done();
        return iStatus;
    }

    protected int computeTotalWork() {
        return 30 + this.moduleFile.getFiles().size();
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        this.virtualComponent = this.createVirtualComponent(this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION"), (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        try {
            this.importModuleFile((IProgressMonitor)new SubProgressMonitor(monitor, this.moduleFile.getFiles().size()));
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fixupManifestRefs() {
    }

    protected IVirtualComponent createVirtualComponent(IDataModel aModel, IProgressMonitor monitor) throws ExecutionException {
        IVirtualComponent iVirtualComponent;
        try {
            aModel.getDefaultOperation().execute(monitor, this.info);
            String projectName = aModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            iVirtualComponent = ComponentCore.createComponent((IProject)project);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iVirtualComponent;
    }

    protected abstract SaveStrategy createSaveStrategy(IVirtualComponent var1);

    protected void modifyStrategy(SaveStrategy saveStrat) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void importModuleFile(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, this.moduleFile.getFiles().size());
                ComponentSaveStrategyImpl aStrategy = (ComponentSaveStrategyImpl)this.createSaveStrategy(this.virtualComponent);
                aStrategy.setProgressMonitor(monitor);
                aStrategy.setOverwriteHandler((IOverwriteHandler)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER"));
                aStrategy.setDataModel(this.model);
                this.modifyStrategy((SaveStrategy)aStrategy);
                this.moduleFile.save((SaveStrategy)aStrategy);
            }
            catch (OverwriteHandlerException overwriteHandlerException) {
                throw new InterruptedException();
            }
            catch (Exception ex) {
                throw new WFTWrappedException((Throwable)ex, EJBArchiveOpsResourceHandler.ERROR_IMPORTING_MODULE_FILE);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        monitor.done();
    }

    protected static void addToClasspath(IDataModel importModel, List extraEntries) throws JavaModelException {
        if (extraEntries.size() > 0) {
            IJavaProject javaProject = JavaCore.create((IProject)((IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT")).getProject());
            IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> nonDuplicateList = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < extraEntries.size()) {
                IClasspathEntry extraEntry = (IClasspathEntry)extraEntries.get(i);
                boolean include = true;
                int j = 0;
                while (include && j < javaClasspath.length) {
                    if (extraEntry.equals(javaClasspath[j])) {
                        include = false;
                    }
                    ++j;
                }
                if (include) {
                    nonDuplicateList.add(extraEntry);
                }
                ++i;
            }
            if (nonDuplicateList.size() > 0) {
                IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + nonDuplicateList.size()];
                System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                int j = 0;
                while (j < nonDuplicateList.size()) {
                    newJavaClasspath[javaClasspath.length + j] = (IClasspathEntry)nonDuplicateList.get(j);
                    ++j;
                }
                javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected void fixModuleReference(IDataModel importModel, String[] manifestEntries) {
        IVirtualComponent comp = (IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
        if (J2EEProjectUtilities.isEJBProject(comp.getProject()) && manifestEntries.length > 0) {
            int j = 0;
            while (j < manifestEntries.length) {
                block8: {
                    String name = manifestEntries[j];
                    int endIndex = name.length() - 4;
                    if (endIndex >= 1) {
                        IVirtualComponent refcomp;
                        name = name.substring(0, endIndex);
                        IProject project = null;
                        try {
                            project = ProjectUtilities.getProject((String)name);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block8;
                        }
                        if (project != null && project.isAccessible() && project.exists() && (refcomp = ComponentCore.createComponent((IProject)project)).exists()) {
                            ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
                            list.add(refcomp);
                            CreateReferenceComponentsOp op = ComponentUtilities.createReferenceComponentOperation((IVirtualComponent)comp, list);
                            try {
                                op.execute(null, null);
                            }
                            catch (ExecutionException e) {
                                Logger.getLogger().logError((Throwable)e);
                            }
                        }
                    }
                }
                ++j;
            }
        }
    }
}

