/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.JavaMOFUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class JavaToWSDLMethodCommand
extends AbstractDataModelOperation {
    private static String JAVA_EXTENSION = ".java";
    private static String CLASS_EXTENSION = ".class";
    private Hashtable fMethodNames;
    private String fClassName;
    private String fbeanBaseName;
    private JavaWSDLParameter javaWSDLParam_;
    private IProject serviceProject_;

    public JavaToWSDLMethodCommand() {
    }

    public JavaToWSDLMethodCommand(JavaWSDLParameter javaParameter, IProject serviceProject) {
        this.javaWSDLParam_ = javaParameter;
        this.serviceProject_ = serviceProject;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        this.fbeanBaseName = this.javaWSDLParam_.getBeanName();
        environment.getLog().log(1, 5070, (Object)this, "execute", (Object)("beanBaseName = " + this.fbeanBaseName));
        try {
            JavaClass javaClass;
            this.fMethodNames = new Hashtable();
            Hashtable oldMethodsNames = this.javaWSDLParam_.getMethods();
            String qName = this.fbeanBaseName;
            if (qName.toLowerCase().endsWith(JAVA_EXTENSION) || qName.toLowerCase().endsWith(CLASS_EXTENSION)) {
                qName = qName.substring(0, qName.lastIndexOf(46));
            }
            if (!(javaClass = JavaMOFUtils.getJavaClass((String)qName, (IProject)this.serviceProject_)).isExistingType()) {
                environment.getLog().log(4, 5022, (Object)this, "execute", (Object)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_JAVA_MOF_REFLECT_FAILED, (Object[])new String[]{qName}));
                IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_JAVA_MOF_REFLECT_FAILED, (Object[])new String[]{qName}));
                environment.getStatusHandler().reportError(status);
                return status;
            }
            this.fClassName = javaClass.getQualifiedName();
            String beanName = this.fClassName.lastIndexOf(46) != -1 ? this.fClassName.substring(this.fClassName.lastIndexOf(46) + 1, this.fClassName.length()) : this.fClassName;
            this.gatherMethods(javaClass, beanName, oldMethodsNames);
            this.javaWSDLParam_.setMethods(this.fMethodNames);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            environment.getLog().log(4, 5023, (Object)this, "execute", (Object)AxisCreationUIMessages.MSG_ERROR_READ_BEAN);
            IStatus status = StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_JAVA_TO_METHOD, (Throwable)e);
            environment.getStatusHandler().reportError(status);
            return status;
        }
    }

    private void gatherMethods(JavaClass javaClass, String beanName, Hashtable oldMethodsNames) {
        String javaName = javaClass.getJavaName();
        if (!(javaClass.isInterface() || javaName.equalsIgnoreCase("javax.ejb.EJBObject[]") || javaName.equalsIgnoreCase("javax.ejb.EJBObject") || javaName.equalsIgnoreCase("java.lang.Object[]") || javaName.equalsIgnoreCase("java.lang.Object"))) {
            List publicMethods = javaClass.getPublicMethods();
            Iterator it = publicMethods.iterator();
            while (it.hasNext()) {
                Method method = (Method)it.next();
                if (method.isConstructor() || beanName.equals(method.getName()) || this.isDuplicateMethodName(method.getMethodElementSignature())) continue;
                String methodName = method.getMethodElementSignature();
                Boolean isSelected = new Boolean(true);
                if (oldMethodsNames != null && oldMethodsNames.containsKey(methodName)) {
                    isSelected = (Boolean)oldMethodsNames.get(methodName);
                }
                this.fMethodNames.put(methodName, isSelected);
            }
            this.gatherMethods(javaClass.getSupertype(), beanName, oldMethodsNames);
        }
    }

    private boolean isDuplicateMethodName(String methodName) {
        return this.fMethodNames == null ? false : this.fMethodNames.containsKey(methodName);
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }
}

