/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.MayReturnNullPropertyDatabase;

public class NonNullReturnValueAnnotationChecker
implements JavaClassAndMethodChooser {
    private static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug.nullreturn");
    private MayReturnNullPropertyDatabase database;
    private JavaClassAndMethod annotatedMethod;
    private Boolean property;

    public NonNullReturnValueAnnotationChecker(MayReturnNullPropertyDatabase database) {
        this.database = database;
    }

    public Boolean getProperty() {
        return this.property;
    }

    public JavaClassAndMethod getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public boolean choose(JavaClassAndMethod javaClassAndMethod) {
        Boolean prop;
        XMethod xmethod = javaClassAndMethod.toXMethod();
        if (DEBUG) {
            System.out.print("Checking " + xmethod + " for @NonNull or @CheckForNull...");
        }
        if ((prop = (Boolean)this.database.getProperty(xmethod)) != null) {
            this.property = prop;
            this.annotatedMethod = javaClassAndMethod;
            if (DEBUG) {
                System.out.println(prop != false ? "@CheckForNull" : "@NonNull");
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("not found");
        }
        return false;
    }
}

