/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.AbstractErrorConverter;
import ca.sqlpower.sql.OracleErrorConverter;
import ca.sqlpower.sql.PLErrorConverter;
import ca.sqlpower.sql.PostgreSQLErrorConverter;
import ca.sqlpower.sql.SQLServerErrorConverter;
import java.sql.SQLException;

public class ErrorConverterFactory {
    private static PLErrorConverter plErrorConverter = new PLErrorConverter();
    private static OracleErrorConverter oracleErrorConverter = new OracleErrorConverter();
    private static SQLServerErrorConverter sqlServerErrorConverter = new SQLServerErrorConverter();
    private static PostgreSQLErrorConverter pgErrorConverter = new PostgreSQLErrorConverter();

    public static AbstractErrorConverter getInstance(SQLException e) {
        String message = e.getMessage();
        if (message.indexOf("PLSchemaException") >= 0) {
            return plErrorConverter;
        }
        if (message.indexOf("icrosoft") >= 0) {
            return sqlServerErrorConverter;
        }
        if (message.indexOf("Backend") >= 0 || message.indexOf("ERROR: ") >= 0) {
            return pgErrorConverter;
        }
        if (message.startsWith("ORA") || message.indexOf("THIN") >= 0 || message.indexOf("Io exception: The Network Adapter") >= 0 || message.indexOf("invalid arguments in call") >= 0 || message.indexOf("Invalid column name") >= 0 || message.indexOf("(ERROR=(") >= 0) {
            return oracleErrorConverter;
        }
        throw new IllegalArgumentException("unrecognized database type for message: " + message);
    }
}

