/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.SQLDatabase;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class SetDataSourceAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(SetDataSourceAction.class);
    protected ArchitectDataSource dbcs;
    protected SQLDatabase db;

    public SetDataSourceAction(SQLDatabase db, ArchitectDataSource dbcs) {
        super(dbcs.getName());
        if (dbcs == null) {
            throw new NullPointerException("Null DBCS is not allowed, doofus");
        }
        this.dbcs = dbcs;
        if (db == null) {
            throw new NullPointerException("Null db is not allowed, dimwad");
        }
        this.db = db;
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("Setting data source of " + this.db + " to " + this.dbcs));
        ArchitectDataSource tSpec = this.db.getDataSource();
        tSpec.setDisplayName(this.dbcs.getDisplayName());
        tSpec.getParentType().setJdbcDriver(this.dbcs.getDriverClass());
        tSpec.setUrl(this.dbcs.getUrl());
        tSpec.setUser(this.dbcs.getUser());
        tSpec.setPass(this.dbcs.getPass());
        tSpec.setPlSchema(this.dbcs.getPlSchema());
        tSpec.setPlDbType(this.dbcs.getPlDbType());
        tSpec.setOdbcDsn(this.dbcs.getOdbcDsn());
    }
}

