/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.MonitorableWorker;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.architect.swingui.WizardPanel;
import ca.sqlpower.architect.swingui.action.ExportDDLAction;
import ca.sqlpower.architect.swingui.action.ExportPLTransAction;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class QuickStartPanel4
implements WizardPanel {
    private static final Logger logger = Logger.getLogger(WizardPanel.class);
    private QuickStartWizard wizard;
    private JTextArea summaryOutput;
    private JScrollPane sp;
    private PanelBuilder pb;
    private JPanel panel;

    public QuickStartPanel4(QuickStartWizard wizard) {
        this.wizard = wizard;
    }

    public JComponent getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            FormLayout layout = new FormLayout("10dlu,min:grow,10dlu", "20dlu,fill:100dlu:grow, 20dlu");
            CellConstraints cc = new CellConstraints();
            this.pb = new PanelBuilder(layout, this.panel);
            this.pb.add((Component)new JLabel("Here is your summary, Click finish"), cc.xy(2, 1));
            this.summaryOutput = new JTextArea();
            this.sp = new JScrollPane(this.summaryOutput);
            this.pb.add((Component)this.sp, cc.xy(2, 2));
            this.pb.add((Component)new JLabel(""), cc.xy(2, 3));
        }
        this.setTextArea();
        return this.pb.getPanel();
    }

    public void setTextArea() {
        PLExport ple = this.wizard.getPlExport();
        StringBuffer text = new StringBuffer();
        text.append("These tables will be created in database: " + ple.getTargetDataSource().getName() + "\n");
        for (int ii = 0; ii < this.wizard.getSourceTables().size(); ++ii) {
            SQLTable t = (SQLTable)this.wizard.getSourceTables().get(ii);
            text.append("  " + (ii + 1) + ".  " + DDLUtils.toQualifiedName(ple.getTargetCatalog(), ple.getTargetSchema(), t.getName()) + "\n");
        }
        text.append("\n");
        text.append("Job " + ple.getJobId() + " will be created in database: " + ple.getRepositoryDataSource().getName() + "\n");
        this.summaryOutput.setText(text.toString());
    }

    public boolean applyChanges() {
        this.wizard.addSourceDatabases(this.wizard.getSourceTables());
        try {
            DDLGenerator ddlg = DDLUtils.createDDLGenerator(this.wizard.getPlExport().getTargetDataSource());
            ddlg.setTargetCatalog(this.wizard.getPlExport().getTargetCatalog());
            ddlg.setTargetSchema(this.wizard.getPlExport().getTargetSchema());
            ArchitectFrame.getMainInstance().getProject().setModified(false);
            ArchitectFrame.getMainInstance().newProjectAction.actionPerformed(new ActionEvent(this, 0, null));
            PlayPen p = ArchitectFrame.getMainInstance().getProject().getPlayPen();
            p.getDatabase().setDataSource(this.wizard.getPlExport().getTargetDataSource());
            ExportDDLAction eda = (ExportDDLAction)ArchitectFrame.getMainInstance().exportDDLAction;
            ExportPLTransAction epta = ArchitectFrame.getMainInstance().exportPLTransAction;
            ArrayList statements = new ArrayList();
            ProgressMonitor pm = new ProgressMonitor(this.panel, "Copying objects from DBTree", "...", 0, 100);
            PlayPen playPen = p;
            playPen.getClass();
            PlayPen.AddObjectsTask aot = playPen.new PlayPen.AddObjectsTask(this.wizard.getSourceTables(), new Point(50, 50), pm, this.wizard.getParentDialog());
            QuickStartWizard.GenerateStatementsTask gst = new QuickStartWizard.GenerateStatementsTask(statements, ddlg, p.getDatabase(), this.wizard.getParentDialog());
            SQLScriptDialog ssd = new SQLScriptDialog(this.wizard.getParentDialog(), "Preview SQL Script", "The Architect will create these tables:", false, ddlg, this.wizard.getPlExport().getTargetDataSource(), false);
            MonitorableWorker scriptWorker = ssd.getExecuteTask();
            ssd.setStatementResultList(this.wizard.getPlExport().getExportResultList());
            ExportDDLAction exportDDLAction = eda;
            exportDDLAction.getClass();
            ExportDDLAction.ConflictFinderProcess cfp = new ExportDDLAction.ConflictFinderProcess(exportDDLAction, this.wizard.getParentDialog(), new SQLDatabase(this.wizard.getPlExport().getTargetDataSource()), ddlg, statements);
            ExportDDLAction exportDDLAction2 = eda;
            exportDDLAction2.getClass();
            ExportDDLAction.ConflictResolverProcess crp = new ExportDDLAction.ConflictResolverProcess(exportDDLAction2, this.wizard.getParentDialog(), cfp);
            ExportPLTransAction exportPLTransAction = epta;
            exportPLTransAction.getClass();
            ExportPLTransAction.ExportTxProcess etp = new ExportPLTransAction.ExportTxProcess(exportPLTransAction, this.wizard.getPlExport(), epta.getExportingTables(), this.wizard.getParentDialog(), ((WizardDialog)this.wizard.getParentDialog()).getProgressBar(), ((WizardDialog)this.wizard.getParentDialog()).getProgressLabel());
            aot.setNextProcess(gst);
            gst.setNextProcess(cfp);
            cfp.setNextProcess(crp);
            crp.setNextProcess(scriptWorker);
            scriptWorker.setNextProcess(etp);
            ((WizardDialog)this.wizard.getParentDialog()).getNextButton().setEnabled(false);
            new Thread((Runnable)aot, "Wizard-Objects-Adder").start();
        }
        catch (InstantiationException e) {
            logger.error((Object)"problem running Quick Start Wizard", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"problem running Quick Start Wizard", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"problem running Quick Start Wizard", (Throwable)e);
        }
        catch (ArchitectException e) {
            logger.error((Object)"problem running Quick Start Wizard", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"problem running Quick Start Wizard", (Throwable)e);
        }
        return true;
    }

    public void discardChanges() {
    }

    public String getTitle() {
        return "Architect Quick Start - Step 4 of 5 - Confirm Selections";
    }
}

