/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayout
implements ArchitectLayout {
    protected Rectangle frame;
    HashMap<String, Object> properties = new HashMap();

    @Override
    public void setup(Collection<? extends LayoutNode> nodes, Collection<? extends LayoutEdge> edges, Rectangle rect) {
        this.frame = rect;
    }

    protected AbstractLayout() {
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Dimension getNewArea(List<? extends LayoutNode> nodes) {
        Dimension d = new Dimension();
        long area = 0L;
        for (LayoutNode layoutNode : nodes) {
            Rectangle b = layoutNode.getBounds();
            area += (long)(b.width * b.height);
        }
        double areaFudgeFactor = 16.0;
        double newWidth = Math.sqrt(1.2941176470588236 * (double)area * 16.0);
        double newHeight = 0.7727272727272727 * newWidth;
        d.setSize((int)newWidth, (int)newHeight);
        return d;
    }
}

