/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.jdbc;

import ca.sqlpower.architect.jdbc.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.CachedRowSet;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgresDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    public static final int UGLY_DEFAULT_VARCHAR_SIZE = 1024;
    private static final int DIGITS_IN_INT8 = 20;
    private static final int DIGITS_IN_INT4 = 10;
    private static final int DIGITS_IN_FLOAT4 = 38;
    private static final int DIGITS_IN_FLOAT8 = 308;

    public PostgresDatabaseMetaDataDecorator(DatabaseMetaData delegate) {
        super(delegate);
    }

    public ResultSet getCatalogs() throws SQLException {
        String theCatalog = this.getConnection().getCatalog();
        if (theCatalog == null || theCatalog.length() == 0) {
            theCatalog = this.getUserName();
        }
        Statement st = null;
        ResultSet rs = null;
        CachedRowSet crs = new CachedRowSet();
        st = this.getConnection().createStatement();
        rs = st.executeQuery("SELECT '" + theCatalog + "'");
        crs.populate(rs);
        rs.close();
        st.close();
        return crs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs = super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        CachedRowSet crs = new CachedRowSet();
        crs.populate(rs);
        rs.close();
        while (crs.next()) {
            if (crs.getInt(5) == 12 && crs.getInt(7) <= 0) {
                crs.updateInt(7, 1024);
                continue;
            }
            if ("int4".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 10);
                continue;
            }
            if ("int8".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 20);
                continue;
            }
            if ("float4".equalsIgnoreCase(crs.getString(6))) {
                crs.updateInt(7, 38);
                continue;
            }
            if (!"float8".equalsIgnoreCase(crs.getString(6))) continue;
            crs.updateInt(7, 308);
        }
        crs.beforeFirst();
        return crs;
    }
}

