/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.jsptags;

import com.darwinsys.util.DateUtils;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class CalendarTag
extends TagSupport {
    private static final long serialVersionUID = -1398213412504718137L;

    public int doEndTag() throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            JspWriter out = this.pageContext.getOut();
            this.doCal(request, out);
            return 0;
        }
        catch (IOException t) {
            System.err.println("Tag caught: " + t);
            throw new JspException(t.toString());
        }
    }

    private void doCal(HttpServletRequest request, JspWriter out) throws IOException {
        out.println("<!-- $Id: CalendarTag.java,v 1.4 2006/04/28 22:32:09 ian Exp $ -->");
        Calendar calendar = Calendar.getInstance();
        int yy = calendar.get(1);
        int mm = calendar.get(2);
        out.println("<table border=1>");
        out.println("<tr><th colspan=7>" + DateUtils.getMonthName(mm) + ", " + yy + "</tr>");
        out.println("<tr><td>Su<td>Mo<td>Tu<td>We<td>Th<td>Fr<td>Sa</tr>");
        int leadGap = calendar.get(7) - 1;
        int daysInMonth = calendar.getActualMaximum(5);
        out.print("<tr>");
        int i = 0;
        while (i < leadGap) {
            out.print("<td>&nbsp;");
            ++i;
        }
        i = 1;
        while (i <= daysInMonth) {
            out.print("<td>");
            out.print(i);
            out.print("</td>");
            if ((leadGap + i) % 7 == 0) {
                out.println("</tr>");
                out.print("<tr>");
            }
            ++i;
        }
        out.println("</tr>");
        out.println("</table>");
        out.println("<!-- end of output from CalendarTag-->");
    }
}

