/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.FileIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;

public class FileIOTest
extends TestCase {
    public static final String FILENAME = "fileiotest.dat";
    File tmpDir;
    public static final String MESSAGE = "The quick brown fox jumps over the lazy dog.";

    public void setUp() {
        try {
            this.tmpDir = File.createTempFile("test", "dir");
            this.tmpDir.delete();
            this.tmpDir.mkdir();
        }
        catch (IOException ex) {
            throw new IllegalStateException("FileIOTest: can't create fileiotest.dat");
        }
    }

    protected void tearDown() throws Exception {
        File file = new File(this.tmpDir, FILENAME);
        if (file.exists()) {
            file.delete();
        }
        if (this.tmpDir != null & this.tmpDir.exists()) {
            this.tmpDir.delete();
        }
    }

    private void makeFileIOTestDat() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.tmpDir + "/" + FILENAME));
        out.print(MESSAGE);
        out.close();
    }

    public void testReaderToString() {
        try {
            this.makeFileIOTestDat();
            String s = FileIO.readerToString(new FileReader(FILENAME));
            FileIOTest.assertEquals((String)MESSAGE, (String)s);
            FileIOTest.assertEquals((long)s.length(), (long)new File(FILENAME).length());
        }
        catch (Exception ex) {
            System.err.println(ex);
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public void testCopyFileByName() {
        String fileName = FILENAME;
        String targetFileName = "fileiotest.dat.bak";
        try {
            this.makeFileIOTestDat();
            FileIO.copyFile(fileName, targetFileName);
            String s1 = FileIO.readerToString(new FileReader(fileName));
            String s2 = FileIO.readerToString(new FileReader(targetFileName));
            FileIOTest.assertEquals((String)s1, (String)s2);
        }
        catch (IOException ex) {
            System.err.println(ex);
            throw new RuntimeException(ex.toString());
        }
    }

    public void testCopyFileByFile() {
        String fileName = FILENAME;
        String targetFileName = "fileiotest.dat.bak";
        try {
            this.makeFileIOTestDat();
            FileIO.copyFile(fileName, targetFileName);
            String s1 = FileIO.readerToString(new FileReader(fileName));
            String s2 = FileIO.readerToString(new FileReader(targetFileName));
            FileIOTest.assertEquals((String)s1, (String)s2);
        }
        catch (IOException ex) {
            System.err.println(ex);
            throw new RuntimeException(ex.toString());
        }
    }

    public void testCopyRecursivelyFiles() throws IOException {
        System.out.println("my tmpdir = " + this.tmpDir);
        File thisTestWorkDir = new File(this.tmpDir, "testFrom");
        File foo = null;
        File bar = null;
        File targetCopyDir = null;
        File newFoo = null;
        File newBar = null;
        File bleah = null;
        try {
            thisTestWorkDir.delete();
            thisTestWorkDir.mkdir();
            foo = new File(thisTestWorkDir, "foo");
            foo.createNewFile();
            bleah = new File(thisTestWorkDir, "bleah");
            bleah.mkdir();
            bar = new File(thisTestWorkDir, "bleah/bar");
            bar.createNewFile();
            targetCopyDir = new File(this.tmpDir, "testTo");
            targetCopyDir.mkdir();
            FileIOTest.assertEquals((int)0, (int)targetCopyDir.listFiles().length);
            newFoo = new File(targetCopyDir, "foo");
            FileIOTest.assertFalse((boolean)newFoo.exists());
            newBar = new File(targetCopyDir, "bleah/bar");
            FileIOTest.assertFalse((boolean)newBar.exists());
            FileIO.copyRecursively(thisTestWorkDir, targetCopyDir);
            FileIOTest.assertTrue((boolean)newFoo.exists());
            FileIOTest.assertTrue((boolean)bleah.exists());
            FileIOTest.assertTrue((boolean)newBar.exists());
            FileIOTest.assertEquals((int)2, (int)targetCopyDir.listFiles().length);
        }
        finally {
            if (bar != null) {
                bar.delete();
            }
            if (bleah != null) {
                bleah.delete();
            }
            if (foo != null) {
                foo.delete();
            }
            if (thisTestWorkDir != null) {
                thisTestWorkDir.delete();
            }
            if (newFoo != null) {
                newFoo.delete();
            }
            if (newBar != null) {
                newBar.delete();
            }
            if (targetCopyDir != null) {
                targetCopyDir.delete();
            }
        }
    }

    public void testDeleteRecursively() throws Exception {
        File f1 = new File(this.tmpDir, "file1");
        f1.createNewFile();
        File d1 = new File(this.tmpDir, "happyDir1");
        d1.mkdir();
        File d1f1 = new File(this.tmpDir, "d1f1");
        d1f1.createNewFile();
        FileIOTest.assertTrue((boolean)d1f1.exists());
        FileIO.deleteRecursively(this.tmpDir);
        FileIOTest.assertFalse((boolean)d1f1.exists());
        FileIOTest.assertFalse((boolean)d1.exists());
        FileIOTest.assertFalse((boolean)f1.exists());
        FileIOTest.assertFalse((boolean)this.tmpDir.exists());
    }

    public void testCopyRecursivelyFromJar() throws IOException {
        System.out.println(" my tmpdir = " + this.tmpDir);
        File targetFoo = null;
        File targetBar = null;
        File newDestDir = null;
        File jarFile = new File(this.tmpDir, "test.jar");
        try {
            JarOutputStream jf = new JarOutputStream(new FileOutputStream(jarFile));
            ZipEntry ze = new ZipEntry("foo");
            jf.putNextEntry(ze);
            jf.write("Hello\n".getBytes());
            ZipEntry zBar = new ZipEntry("bar");
            jf.putNextEntry(zBar);
            jf.write("Hello II\n".getBytes());
            jf.close();
            newDestDir = new File(this.tmpDir, "testTo");
            newDestDir.mkdir();
            targetFoo = new File(newDestDir, "foo");
            FileIOTest.assertFalse((boolean)targetFoo.exists());
            targetBar = new File(newDestDir, "bar");
            FileIOTest.assertFalse((boolean)targetBar.exists());
            FileIOTest.assertEquals((int)0, (int)newDestDir.listFiles().length);
            FileIO.copyRecursively(new JarFile(jarFile), new JarEntry("/"), newDestDir);
            FileIOTest.assertTrue((boolean)targetFoo.exists());
            FileIOTest.assertEquals((long)6L, (long)targetFoo.length());
            FileIOTest.assertTrue((boolean)targetBar.exists());
            FileIOTest.assertEquals((long)9L, (long)targetBar.length());
            FileIOTest.assertEquals((int)2, (int)newDestDir.listFiles().length);
        }
        finally {
            if (jarFile != null) {
                jarFile.delete();
            }
            if (targetFoo != null) {
                targetFoo.delete();
            }
            if (targetBar != null) {
                targetBar.delete();
            }
            if (newDestDir != null) {
                newDestDir.delete();
            }
        }
    }
}

