'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.10/tcllib-1.10/modules/math/interpolate.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\" Copyright (c) 2004 Kevn B. Kenny <kennykb@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::interpolate" n 1.0.2 math "Tcl Math Library"
.BS
.SH NAME
math::interpolate \- Interpolation routines
.SH SYNOPSIS
package require \fBTcl  ?8.4?\fR
.sp
package require \fBstruct \fR
.sp
package require \fBmath::interpolate  ?1.0.2?\fR
.sp
\fB::math::interpolate::defineTable\fR \fIname\fR \fIcolnames\fR \fIvalues\fR
.sp
\fB::math::interpolate::interp-1d-table\fR \fIname\fR \fIxval\fR
.sp
\fB::math::interpolate::interp-table\fR \fIname\fR \fIxval\fR \fIyval\fR
.sp
\fB::math::interpolate::interp-linear\fR \fIxyvalues\fR \fIxval\fR
.sp
\fB::math::interpolate::interp-lagrange\fR \fIxyvalues\fR \fIxval\fR
.sp
\fB::math::interpolate::prepare_cubic_splines\fR \fIxcoord\fR \fIycoord\fR
.sp
\fB::math::interpolate::interp_cubic_splines\fR \fIcoeffs\fR \fIx\fR
.sp
\fB::math::interpolate::interp-spatial\fR \fIxyvalues\fR \fIcoord\fR
.sp
\fB::math::interpolate::interp-spatial-params\fR \fImax_search\fR \fIpower\fR
.sp
\fB::math::interpolate::neville\fR \fIxlist\fR \fIylist\fR \fIx\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package implements several interpolation algorithms:
.IP \(bu
Interpolation into a table (one or two independent variables), this is useful
for example, if the data are static, like with tables of statistical functions.
.IP \(bu
Linear interpolation into a given set of data (organised as (x,y) pairs).
.IP \(bu
Lagrange interpolation. This is mainly of theoretical interest, because there is
no guarantee about error bounds. One possible use: if you need a line or
a parabola through given points (it will calculate the values, but not return
the coefficients).
.sp
A variation is Neville's method which has better behaviour and error
bounds.
.IP \(bu
Spatial interpolation using a straightforward distance-weight method. This procedure
allows any number of spatial dimensions and any number of dependent variables.
.IP \(bu
Interpolation in one dimension using cubic splines.
.PP
.PP
This document describes the procedures and explains their usage.
.SH PROCEDURES
The interpolation package defines the following public procedures:
.TP
\fB::math::interpolate::defineTable\fR \fIname\fR \fIcolnames\fR \fIvalues\fR
Define a table with one or two independent variables (the distinction is implicit in
the data). The procedure returns the name of the table - this name is used whenever you
want to interpolate the values. \fINote:\fR this procedure is a convenient wrapper for the
struct::matrix procedure. Therefore you can access the data at any location in your program.
.RS
.TP
\fIname\fR string (in) Name of the table to be created
.TP
\fIcolnames\fR list (in) List of column names
.TP
\fIvalues\fR list (in) List of values (the number of elements should be a
multiple of the number of columns. See \fBEXAMPLES\fR for more information on the
interpretation of the data.
.sp
The values must be sorted with respect to the independent variable(s).
.RE
.sp
.TP
\fB::math::interpolate::interp-1d-table\fR \fIname\fR \fIxval\fR
Interpolate into the one-dimensional table "name" and return a list of values, one for
each dependent column.
.RS
.TP
\fIname\fR string (in) Name of an existing table
.TP
\fIxval\fR float (in) Value of the independent \fIrow\fR variable
.RE
.sp
.TP
\fB::math::interpolate::interp-table\fR \fIname\fR \fIxval\fR \fIyval\fR
Interpolate into the two-dimensional table "name" and return the interpolated value.
.RS
.TP
\fIname\fR string (in) Name of an existing table
.TP
\fIxval\fR float (in) Value of the independent \fIrow\fR variable
.TP
\fIyval\fR float (in) Value of the independent \fIcolumn\fR variable
.RE
.sp
.TP
\fB::math::interpolate::interp-linear\fR \fIxyvalues\fR \fIxval\fR
Interpolate linearly into the list of x,y pairs and return the interpolated value.
.RS
.TP
\fIxyvalues\fR list (in) List of pairs of (x,y) values, sorted to increasing x.
They are used as the breakpoints of a piecewise linear function.
.TP
\fIxval\fR float (in) Value of the independent variable for which the value of y
must be computed.
.RE
.sp
.TP
\fB::math::interpolate::interp-lagrange\fR \fIxyvalues\fR \fIxval\fR
Use the list of x,y pairs to construct the unique polynomial of lowest degree
that passes through all points and return the interpolated value.
.RS
.TP
\fIxyvalues\fR list (in) List of pairs of (x,y) values
.TP
\fIxval\fR float (in) Value of the independent variable for which the value of y
must be computed.
.RE
.sp
.TP
\fB::math::interpolate::prepare_cubic_splines\fR \fIxcoord\fR \fIycoord\fR
Returns a list of coefficients for the second routine
\fIinterp_cubic_splines\fR to actually interpolate.
.RS
.TP
\fIxcoord\fR list List of x-coordinates for the value of the
function to be interpolated is known. The coordinates must be strictly
ascending. At least three points are required.
.TP
\fIycoord\fR list List of y-coordinates (the values of the
function at the given x-coordinates).
.RE
.sp
.TP
\fB::math::interpolate::interp_cubic_splines\fR \fIcoeffs\fR \fIx\fR
Returns the interpolated value at coordinate x. The coefficients are
computed by the procedure \fIprepare_cubic_splines\fR.
.RS
.TP
\fIcoeffs\fR list List of coefficients as returned by
prepare_cubic_splines
.TP
\fIx\fR float x-coordinate at which to estimate the function. Must
be between the first and last x-coordinate for which values were given.
.RE
.sp
.TP
\fB::math::interpolate::interp-spatial\fR \fIxyvalues\fR \fIcoord\fR
Use a straightforward interpolation method with weights as function of the
inverse distance to interpolate in 2D and N-dimensional space
.sp
The list xyvalues is a list of lists:
.nf

    {   {x1 y1 z1 {v11 v12 v13 v14}}
	{x2 y2 z2 {v21 v22 v23 v24}}
	...
    }

.fi
The last element of each inner list is either a single number or a list in itself.
In the latter case the return value is a list with the same number of elements.
.sp
The method is influenced by the search radius and the power of the inverse distance
.RS
.TP
\fIxyvalues\fR list (in) List of lists, each sublist being a list of coordinates and
of dependent values.
.TP
\fIcoord\fR list (in) List of coordinates for which the values must be calculated
.RE
.sp
.TP
\fB::math::interpolate::interp-spatial-params\fR \fImax_search\fR \fIpower\fR
Set the parameters for spatial interpolation
.RS
.TP
\fImax_search\fR float (in) Search radius (data points further than this are ignored)
.TP
\fIpower\fR integer (in) Power for the distance (either 1 or 2; defaults to 2)
.RE
.TP
\fB::math::interpolate::neville\fR \fIxlist\fR \fIylist\fR \fIx\fR
Interpolates between the tabulated values of a function
whose abscissae are \fIxlist\fR
and whose ordinates are \fIylist\fR to produce an estimate for the value
of the function at \fIx\fR.  The result is a two-element list; the first
element is the function's estimated value, and the second is an estimate
of the absolute error of the result.  Neville's algorithm for polynomial
interpolation is used.  Note that a large table of values will use an
interpolating polynomial of high degree, which is likely to result in
numerical instabilities; one is better off using only a few tabulated
values near the desired abscissa.
.PP
.SH EXAMPLES
\fITODO\fR
Example of using the cubic splines:
.PP
Suppose the following values are given:
.nf

    x       y
  0.1     1.0
  0.3     2.1
  0.4     2.2
  0.8     4.11
  1.0     4.12

.fi
Then to estimate the values at 0.1, 0.2, 0.3, ... 1.0, you can use:
.nf

   set coeffs [::math::interpolate::prepare_cubic_splines  {0.1 0.3 0.4 0.8  1.0}  {1.0 2.1 2.2 4.11 4.12}]
   foreach x {0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0} {
      puts "$x: [::math::interpolate::interp_cubic_splines $coeffs $x]"
   }

.fi
to get the following output:
.nf

0.1: 1.0
0.2: 1.68044117647
0.3: 2.1
0.4: 2.2
0.5: 3.11221507353
0.6: 4.25242647059
0.7: 5.41804227941
0.8: 4.11
0.9: 3.95675857843
1.0: 4.12

.fi
As you can see, the values at the abscissae are reproduced perfectly.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: interpolate\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
interpolation, math, spatial interpolation
.SH COPYRIGHT
.nf
Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>
Copyright (c) 2004 Kevn B. Kenny <kennykb@users.sourceforge.net>

.fi