#!/bin/sh
# Test suite for f77 examples.
#
# Copyright (C) 2004  Alan W. Irwin
# Copyright (C) 2004  Andrew Ross
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Library Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# This is called from plplot-test.sh with $f77dir, $device, $dsuffix,
# and $options defined.

# To build the f77 examples before running this script do the following:
# pushd $f77dir; make; popd

if test "yes" = "yes"; then
# This stanza only works if fortran has command-line parsing capability.
# However, this is the preferred method because it allows access to
# command-line parsing of the $options (e.g., familying options for png
# and jpeg devices) that have been passed from plplot-test.sh

# Do non-standard example 16a because it illustrates plshade functionality
# with cmap1 (and also because the result looks nice.)
  $f77dir/x16af -dev $device -o ${OUTPUT_DIR}/x16af.$dsuffix $options

# Do the standard non-interactive examples.
# skip 14, 17, and 20 because they are interactive, and 20 not implemented.
# skip 21 because it delivers variable results depending on computer timing
# and load (and not implemented yet).
  for index in 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 22 23; do
    $f77dir/x${index}f -dev $device -o ${OUTPUT_DIR}/x${index}f.$dsuffix $options
  done
else
# Fall back to this method if this fortran platform does not have
# command-line parsing capability.  Command-line $options must be ignored
# for this method.
# Do non-standard example 16a because it illustrates plshade functionality
# with cmap1 (and also because the result looks nice.)
  $f77dir/x16af <<EOF >/dev/null
$device
${OUTPUT_DIR}/x16af.$dsuffix
EOF

# Do the standard non-interactive examples.
# skip 14, 17, and 20 because they are interactive, and 20 not implemented.
# skip 21 because it delivers variable results depending on computer timing
# and load (and not implemented yet).
  for index in 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 22 23; do
     $f77dir/x${index}f <<EOF >/dev/null
$device
${OUTPUT_DIR}/x${index}f.$dsuffix
EOF
  done
fi
