/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* 
 * HISTORY
*/ 
/* (c) Copyright 1990, Integrated Computer Solutions, Inc. */
/*   Author:  Chris D. Peterson */

#ifndef _XmToolbar_h
#define _XmToolbar_h

#include <Xm/Xm.h>

/************************************************************
*	INCLUDE FILES
*************************************************************/

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct _XmToolbarClassRec	*XmToolbarWidgetClass;
typedef struct _XmToolbarRec		*XmToolbarWidget;

typedef struct _XmToolbarCallbackStruct
{
  int    reason;	/* the reason for the callback */
  XEvent *event;        /* the event struct */
  Widget toolbar_item;  /* toolbar item for which the event occured */
  int position;         /* position of item */
  int group;            /* group number of item */
} XmToolbarCallbackStruct, *XmToolbarCallbackPtr;

/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/

extern WidgetClass xmToolbarWidgetClass; 

/************************************************************
*	EXTERNAL FUNCTIONS
*************************************************************/

extern Widget XmCreateToolbar(
#ifndef _NO_PROTO
Widget, String, ArgList, Cardinal
#endif
);

extern void XmToolbarMapGroup( 
#ifndef _NO_PROTO
Widget , unsigned char  
#endif
);

extern void XmToolbarUnmapGroup( 
#ifndef _NO_PROTO
Widget , unsigned char  
#endif
);


extern void XmToolbarManageGroup( 
#ifndef _NO_PROTO
Widget , unsigned char  
#endif
);


extern void XmToolbarUnmanageGroup( 
#ifndef _NO_PROTO
Widget , unsigned char  
#endif
);


extern void XmToolbarDestroyGroup( 
#ifndef _NO_PROTO
Widget , unsigned char  
#endif
);

extern void XmToolbarInsertBefore(
#ifndef _NO_PROTO
Widget, Widget
#endif
);

#if defined(__cplusplus)
}
#endif

#endif /* _XmToolbar_h */
