# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - authentication using a remote wiki

    @copyright: 2005 by Florian Festi,
                2007 by MoinMoin:ThomasWaldmann
    @license: GNU GPL, see COPYING for details.
"""

verbose = False

import xmlrpclib
from MoinMoin import auth, wikiutil, user

def interwiki(request, **kw):
    username = kw.get('name')
    password = kw.get('password')
    login = kw.get('login')
    user_obj = kw.get('user_obj')

    if login:
        if verbose: request.log("interwiki auth: trying to auth %r" % username)
        username = username.replace(' ', ':', 1) # XXX Hack because ':' is not allowed in name field
        wikitag, wikiurl, name, err = wikiutil.resolve_wiki(request, username)

        if verbose: request.log("interwiki auth: resolve wiki returned: %r %r %r %r" % (wikitag, wikiurl, name, err))
        if err or wikitag not in request.cfg.trusted_wikis:
            return user_obj, True

        if password:
            homewiki = xmlrpclib.ServerProxy(wikiurl + "?action=xmlrpc2")
            auth_token = homewiki.getAuthToken(name, password)
            
            if not auth_token:
                if verbose: request.log("interwiki auth: %r wiki did not return an auth token." % wikitag)
                return user_obj, True

            if verbose: request.log("interwiki: successfully got an auth token for %r" % name)
            if verbose: request.log("interwiki: trying to get user profile data for %r" % name)

            mc = xmlrpclib.MultiCall(homewiki)
            mc.applyAuthToken(auth_token)
            mc.getUserProfile()
            result, account_data = mc()
            
            if result != "SUCCESS":
                if verbose: request.log("interwiki auth: %r wiki did not accept auth token." % wikitag)
                return user_obj, True

            if not account_data:
                if verbose: request.log("interwiki auth: %r wiki did not return a user profile." % wikitag)
                return user_obj, True

            if verbose: request.log("interwiki auth: %r wiki returned a user profile." % wikitag)
            
            # TODO: check auth_attribs items
            u = user.User(request, name=name, auth_method='interwiki', auth_attribs=('name', 'aliasname', 'password', 'email', ))
            for key, value in account_data.iteritems():
                if key not in request.cfg.user_transient_fields:
                    setattr(u, key, value)
            u.valid = 1
            u.create_or_update(True)
            if verbose: request.log("interwiki: successful interwiki auth for %r" % name)
            return u, True # moin_session has to set the cookie

    return user_obj, True
