# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - unsubscribe from notifications to a page.

    @copyright: 2000-2004 Juergen Hermann <jh@web.de>,
                2006 MoinMoin:ThomasWaldmann
    @license: GNU GPL, see COPYING for details.
"""
from MoinMoin.Page import Page

def execute(pagename, request):
    """ Unsubscribe the user from pagename """
    _ = request.getText
    cfg = request.cfg
    msg = None

    if request.user.isSubscribedTo([pagename]):
        # Try to unsubscribe
        if request.user.unsubscribe(pagename):
            msg = _('Your subscription to this page has been removed.', formatted=False)
        else:
            msg = _("Can't remove regular expression subscription!", formatted=False) + u' ' + \
                  _("Edit the subscription regular expressions in your "
                    "UserPreferences.", formatted=True)
    else:
        # The user is not subscribed
        msg = _('You need to be subscribed to unsubscribe.', formatted=False)

    Page(request, pagename).send_page(msg=msg)

