/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Image.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef IMAGE_H
#define IMAGE_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <string>
#include "animorph/Color.h"
#include "Widget.h"
#include "Panel.h"
#include "Texture.h"

using Animorph::Color;

using std::string;

namespace mhgui {

class Tooltip;
class ImageSysListener;
class ImageData;

/* ========================================================================== */
/**
 */
/* ========================================================================== */
class Image : public Widget
{
  //Textures
private:
  string            imageFilename;
  Texture           texture;

  bool              textureIsInited; // used by lazyLoadTexture

  ImageSysListener *imageSysListener;
  float             alpha;
  Color overlay;
  bool overlayEffect;

  // intentionally not implemented
  Image           (const Image&);
  Image& operator=(const Image&);

public:
  Image (uint32_t inId, const string& inFilename, const Rect& inGeometry);
  virtual ~Image();

  void  setAlpha (float);
  float getAlpha() const {return alpha;}

  /*!
   * Set the Color for the overlay rectangle. The overlay is enabled at this time.
   * @param c The color for the overlay. Transparency is set by the alpha component.
   */
  void setOverlayRectangle (const Color& c);

  void setOverlayRectangle (bool overlayEffect);

  const Texture& getTextures (); //return the textureID

  virtual void show ();
  virtual void hide ();
  virtual void draw ();
  virtual void drawOverlay ();

protected:
  bool lazyLoadTexture ();
};

} // namespace mhgui

#endif //IMAGE_H
