require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM32_CPUFUNC_H_)) {
    eval 'sub _ARM32_CPUFUNC_H_ () {1;}' unless defined(&_ARM32_CPUFUNC_H_);
    if(defined(&_KERNEL)) {
	require 'sys/types.ph';
	require 'arm/cpuconf.ph';
	eval 'sub cpu_id () {
	    eval q( ($cpufuncs->{cf_id})());
	}' unless defined(&cpu_id);
	eval 'sub cpu_cpwait () {
	    eval q( ($cpufuncs->{cf_cpwait})());
	}' unless defined(&cpu_cpwait);
	eval 'sub cpu_control {
	    my($c, $e) = @_;
    	    eval q( ($cpufuncs->{cf_control})($c, $e));
	}' unless defined(&cpu_control);
	eval 'sub cpu_domains {
	    my($d) = @_;
    	    eval q( ($cpufuncs->{cf_domains})($d));
	}' unless defined(&cpu_domains);
	eval 'sub cpu_setttb {
	    my($t) = @_;
    	    eval q( ($cpufuncs->{cf_setttb})($t));
	}' unless defined(&cpu_setttb);
	eval 'sub cpu_faultstatus () {
	    eval q( ($cpufuncs->{cf_faultstatus})());
	}' unless defined(&cpu_faultstatus);
	eval 'sub cpu_faultaddress () {
	    eval q( ($cpufuncs->{cf_faultaddress})());
	}' unless defined(&cpu_faultaddress);
	eval 'sub cpu_tlb_flushID () {
	    eval q( ($cpufuncs->{cf_tlb_flushID})());
	}' unless defined(&cpu_tlb_flushID);
	eval 'sub cpu_tlb_flushID_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushID_SE})($e));
	}' unless defined(&cpu_tlb_flushID_SE);
	eval 'sub cpu_tlb_flushI () {
	    eval q( ($cpufuncs->{cf_tlb_flushI})());
	}' unless defined(&cpu_tlb_flushI);
	eval 'sub cpu_tlb_flushI_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushI_SE})($e));
	}' unless defined(&cpu_tlb_flushI_SE);
	eval 'sub cpu_tlb_flushD () {
	    eval q( ($cpufuncs->{cf_tlb_flushD})());
	}' unless defined(&cpu_tlb_flushD);
	eval 'sub cpu_tlb_flushD_SE {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_tlb_flushD_SE})($e));
	}' unless defined(&cpu_tlb_flushD_SE);
	eval 'sub cpu_icache_sync_all () {
	    eval q( ($cpufuncs->{cf_icache_sync_all})());
	}' unless defined(&cpu_icache_sync_all);
	eval 'sub cpu_icache_sync_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_icache_sync_range})(($a), ($s)));
	}' unless defined(&cpu_icache_sync_range);
	eval 'sub cpu_dcache_wbinv_all () {
	    eval q( ($cpufuncs->{cf_dcache_wbinv_all})());
	}' unless defined(&cpu_dcache_wbinv_all);
	eval 'sub cpu_dcache_wbinv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_wbinv_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_wbinv_range);
	eval 'sub cpu_dcache_inv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_inv_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_inv_range);
	eval 'sub cpu_dcache_wb_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_dcache_wb_range})(($a), ($s)));
	}' unless defined(&cpu_dcache_wb_range);
	eval 'sub cpu_idcache_wbinv_all () {
	    eval q( ($cpufuncs->{cf_idcache_wbinv_all})());
	}' unless defined(&cpu_idcache_wbinv_all);
	eval 'sub cpu_idcache_wbinv_range {
	    my($a, $s) = @_;
    	    eval q( ($cpufuncs->{cf_idcache_wbinv_range})(($a), ($s)));
	}' unless defined(&cpu_idcache_wbinv_range);
	eval 'sub cpu_flush_prefetchbuf () {
	    eval q( ($cpufuncs->{cf_flush_prefetchbuf})());
	}' unless defined(&cpu_flush_prefetchbuf);
	eval 'sub cpu_drain_writebuf () {
	    eval q( ($cpufuncs->{cf_drain_writebuf})());
	}' unless defined(&cpu_drain_writebuf);
	eval 'sub cpu_flush_brnchtgt_C () {
	    eval q( ($cpufuncs->{cf_flush_brnchtgt_C})());
	}' unless defined(&cpu_flush_brnchtgt_C);
	eval 'sub cpu_flush_brnchtgt_E {
	    my($e) = @_;
    	    eval q( ($cpufuncs->{cf_flush_brnchtgt_E})($e));
	}' unless defined(&cpu_flush_brnchtgt_E);
	eval 'sub cpu_sleep {
	    my($m) = @_;
    	    eval q( ($cpufuncs->{cf_sleep})($m));
	}' unless defined(&cpu_sleep);
	eval 'sub cpu_dataabt_fixup {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_dataabt_fixup})($a));
	}' unless defined(&cpu_dataabt_fixup);
	eval 'sub cpu_prefetchabt_fixup {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_prefetchabt_fixup})($a));
	}' unless defined(&cpu_prefetchabt_fixup);
	eval 'sub ABORT_FIXUP_OK () {0;}' unless defined(&ABORT_FIXUP_OK);
	eval 'sub ABORT_FIXUP_FAILED () {1;}' unless defined(&ABORT_FIXUP_FAILED);
	eval 'sub ABORT_FIXUP_RETURN () {2;}' unless defined(&ABORT_FIXUP_RETURN);
	eval 'sub cpu_context_switch {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_context_switch})($a));
	}' unless defined(&cpu_context_switch);
	eval 'sub cpu_setup {
	    my($a) = @_;
    	    eval q( ($cpufuncs->{cf_setup})($a));
	}' unless defined(&cpu_setup);
	eval 'sub ARCHITECTURE_NOT_PRESENT () {1;}' unless defined(&ARCHITECTURE_NOT_PRESENT);
	eval 'sub ARCHITECTURE_NOT_SUPPORTED () {2;}' unless defined(&ARCHITECTURE_NOT_SUPPORTED);
	if(defined(&CPU_ARM3)) {
	}
	if(defined( &CPU_ARM6) || defined( &CPU_ARM7)) {
	}
	if(defined(&CPU_ARM6)) {
	}
	if(defined(&CPU_ARM7)) {
	}
	if(defined(&CPU_ARM7TDMI)) {
	}
	if(defined(&CPU_ARM8)) {
	}
	if(defined(&CPU_SA110)) {
	}
	if(defined( &CPU_SA1100) || defined( &CPU_SA1110)) {
	}
	if(defined( &CPU_SA110) || defined( &CPU_SA1100) || defined( &CPU_SA1110)) {
	}
	if(defined(&CPU_ARM9)) {
	}
	if(defined(&CPU_ARM10)) {
	}
	if(defined( &CPU_ARM9) || defined( &CPU_ARM10) || defined( &CPU_SA110) || defined( &CPU_SA1100) || defined( &CPU_SA1110) || defined( &CPU_XSCALE_80200) || defined( &CPU_XSCALE_80321) || defined( &CPU_XSCALE_PXA2X0) || defined( &CPU_XSCALE_IXP425)) {
	}
	if(defined( &CPU_IXP12X0)) {
	}
	if(defined( &CPU_XSCALE_80200) || defined( &CPU_XSCALE_80321) || defined( &CPU_XSCALE_PXA2X0) || defined( &CPU_XSCALE_IXP425) || ((defined(&ARM_MMU_XSCALE) ? &ARM_MMU_XSCALE : 0) == 1)) {
	}
	eval 'sub tlb_flush () { &cpu_tlb_flushID;}' unless defined(&tlb_flush);
	eval 'sub setttb () { &cpu_setttb;}' unless defined(&setttb);
	eval 'sub drain_writebuf () { &cpu_drain_writebuf;}' unless defined(&drain_writebuf);
	if(defined(&__PROG32)) {
	    eval 'sub __set_cpsr_c {
	        my($bic,$eor) = @_;
    		eval q({  &u_int32_t  &tmp,  &ret;  &__asm  &__volatile( \\"mrs     %0, cpsr\\\\n\\" \\"bic	 %1, %0, %2\\\\n\\" \\"eor	 %1, %1, %3\\\\n\\" \\"msr     cpsr_c, %1\\\\n\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &tmp) : \\"r\\" ($bic), \\"r\\" ($eor));  &ret; });
	    }' unless defined(&__set_cpsr_c);
	    eval 'sub __get_cpsr {
	        eval q({  &u_int32_t  &ret;  &__asm  &__volatile(\\"mrs	%0, cpsr\\" : \\"=&r\\" ( &ret));  &ret; });
	    }' unless defined(&__get_cpsr);
	    eval 'sub disable_interrupts {
	        my($mask) = @_;
    		eval q(( &__set_cpsr_c(($mask) & ( &I32_bit |  &F32_bit), ($mask) & ( &I32_bit |  &F32_bit))));
	    }' unless defined(&disable_interrupts);
	    eval 'sub enable_interrupts {
	        my($mask) = @_;
    		eval q(( &__set_cpsr_c(($mask) & ( &I32_bit |  &F32_bit), 0)));
	    }' unless defined(&enable_interrupts);
	    eval 'sub restore_interrupts {
	        my($old_cpsr) = @_;
    		eval q(( &__set_cpsr_c(( &I32_bit |  &F32_bit), ($old_cpsr) & ( &I32_bit |  &F32_bit))));
	    }' unless defined(&restore_interrupts);
	} else {
	    eval 'sub disable_interrupts {
	        my($mask) = @_;
    		eval q(( &set_r15(($mask) & ( &R15_IRQ_DISABLE |  &R15_FIQ_DISABLE), ($mask) & ( &R15_IRQ_DISABLE |  &R15_FIQ_DISABLE))));
	    }' unless defined(&disable_interrupts);
	    eval 'sub enable_interrupts {
	        my($mask) = @_;
    		eval q(( &set_r15(($mask) & ( &R15_IRQ_DISABLE |  &R15_FIQ_DISABLE), 0)));
	    }' unless defined(&enable_interrupts);
	    eval 'sub restore_interrupts {
	        my($old_r15) = @_;
    		eval q(( &set_r15(( &R15_IRQ_DISABLE |  &R15_FIQ_DISABLE), ($old_r15) & ( &R15_IRQ_DISABLE |  &R15_FIQ_DISABLE))));
	    }' unless defined(&restore_interrupts);
	}
    }
}
1;
