require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_PCI_PCIREG_H_)) {
    eval 'sub _DEV_PCI_PCIREG_H_ () {1;}' unless defined(&_DEV_PCI_PCIREG_H_);
    eval 'sub PCI_ID_REG () {0x;}' unless defined(&PCI_ID_REG);
    eval 'sub PCI_VENDOR_SHIFT () {0;}' unless defined(&PCI_VENDOR_SHIFT);
    eval 'sub PCI_VENDOR_MASK () {0xffff;}' unless defined(&PCI_VENDOR_MASK);
    eval 'sub PCI_VENDOR {
        my($id) = @_;
	    eval q(((($id) >>  &PCI_VENDOR_SHIFT) &  &PCI_VENDOR_MASK));
    }' unless defined(&PCI_VENDOR);
    eval 'sub PCI_PRODUCT_SHIFT () {16;}' unless defined(&PCI_PRODUCT_SHIFT);
    eval 'sub PCI_PRODUCT_MASK () {0xffff;}' unless defined(&PCI_PRODUCT_MASK);
    eval 'sub PCI_PRODUCT {
        my($id) = @_;
	    eval q(((($id) >>  &PCI_PRODUCT_SHIFT) &  &PCI_PRODUCT_MASK));
    }' unless defined(&PCI_PRODUCT);
    eval 'sub PCI_ID_CODE {
        my($vid,$pid) = @_;
	    eval q((((($vid) &  &PCI_VENDOR_MASK) <<  &PCI_VENDOR_SHIFT) | ((($pid) &  &PCI_PRODUCT_MASK) <<  &PCI_PRODUCT_SHIFT)));
    }' unless defined(&PCI_ID_CODE);
    eval 'sub PCI_COMMAND_STATUS_REG () {0x4;}' unless defined(&PCI_COMMAND_STATUS_REG);
    eval 'sub PCI_COMMAND_IO_ENABLE () {0x1;}' unless defined(&PCI_COMMAND_IO_ENABLE);
    eval 'sub PCI_COMMAND_MEM_ENABLE () {0x2;}' unless defined(&PCI_COMMAND_MEM_ENABLE);
    eval 'sub PCI_COMMAND_MASTER_ENABLE () {0x4;}' unless defined(&PCI_COMMAND_MASTER_ENABLE);
    eval 'sub PCI_COMMAND_SPECIAL_ENABLE () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL_ENABLE);
    eval 'sub PCI_COMMAND_INVALIDATE_ENABLE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE_ENABLE);
    eval 'sub PCI_COMMAND_PALETTE_ENABLE () {0x20;}' unless defined(&PCI_COMMAND_PALETTE_ENABLE);
    eval 'sub PCI_COMMAND_PARITY_ENABLE () {0x40;}' unless defined(&PCI_COMMAND_PARITY_ENABLE);
    eval 'sub PCI_COMMAND_STEPPING_ENABLE () {0x80;}' unless defined(&PCI_COMMAND_STEPPING_ENABLE);
    eval 'sub PCI_COMMAND_SERR_ENABLE () {0x100;}' unless defined(&PCI_COMMAND_SERR_ENABLE);
    eval 'sub PCI_COMMAND_BACKTOBACK_ENABLE () {0x200;}' unless defined(&PCI_COMMAND_BACKTOBACK_ENABLE);
    eval 'sub PCI_STATUS_CAPLIST_SUPPORT () {0x100000;}' unless defined(&PCI_STATUS_CAPLIST_SUPPORT);
    eval 'sub PCI_STATUS_66MHZ_SUPPORT () {0x200000;}' unless defined(&PCI_STATUS_66MHZ_SUPPORT);
    eval 'sub PCI_STATUS_UDF_SUPPORT () {0x400000;}' unless defined(&PCI_STATUS_UDF_SUPPORT);
    eval 'sub PCI_STATUS_BACKTOBACK_SUPPORT () {0x800000;}' unless defined(&PCI_STATUS_BACKTOBACK_SUPPORT);
    eval 'sub PCI_STATUS_PARITY_ERROR () {0x1000000;}' unless defined(&PCI_STATUS_PARITY_ERROR);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x2000000;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x4000000;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x6000000;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_TARGET_TARGET_ABORT () {0x8000000;}' unless defined(&PCI_STATUS_TARGET_TARGET_ABORT);
    eval 'sub PCI_STATUS_MASTER_TARGET_ABORT () {0x10000000;}' unless defined(&PCI_STATUS_MASTER_TARGET_ABORT);
    eval 'sub PCI_STATUS_MASTER_ABORT () {0x20000000;}' unless defined(&PCI_STATUS_MASTER_ABORT);
    eval 'sub PCI_STATUS_SPECIAL_ERROR () {0x40000000;}' unless defined(&PCI_STATUS_SPECIAL_ERROR);
    eval 'sub PCI_STATUS_PARITY_DETECT () {0x80000000;}' unless defined(&PCI_STATUS_PARITY_DETECT);
    eval 'sub PCI_COMMAND_STATUS_BITS () {("\\020\\01IO\\02MEM\\03MASTER\\04SPECIAL\\05INVALIDATE\\06PALETTE\\07PARITY" "\\010STEPPING\\011SERR\\012BACKTOBACK\\025CAPLIST\\026CLK66\\027UDF" "\\030BACK2BACK_STAT\\031PARITY_STAT\\032DEVSEL_MEDIUM\\033DEVSEL_SLOW" "\\034TARGET_TARGET_ABORT\\035MASTER_TARGET_ABORT\\036MASTER_ABORT" "\\037SPECIAL_ERROR\\040PARITY_DETECT");}' unless defined(&PCI_COMMAND_STATUS_BITS);
    eval 'sub PCI_CLASS_REG () {0x8;}' unless defined(&PCI_CLASS_REG);
    eval 'sub PCI_CLASS_SHIFT () {24;}' unless defined(&PCI_CLASS_SHIFT);
    eval 'sub PCI_CLASS_MASK () {0xff;}' unless defined(&PCI_CLASS_MASK);
    eval 'sub PCI_CLASS {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_CLASS_SHIFT) &  &PCI_CLASS_MASK));
    }' unless defined(&PCI_CLASS);
    eval 'sub PCI_SUBCLASS_SHIFT () {16;}' unless defined(&PCI_SUBCLASS_SHIFT);
    eval 'sub PCI_SUBCLASS_MASK () {0xff;}' unless defined(&PCI_SUBCLASS_MASK);
    eval 'sub PCI_SUBCLASS {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_SUBCLASS_SHIFT) &  &PCI_SUBCLASS_MASK));
    }' unless defined(&PCI_SUBCLASS);
    eval 'sub PCI_INTERFACE_SHIFT () {8;}' unless defined(&PCI_INTERFACE_SHIFT);
    eval 'sub PCI_INTERFACE_MASK () {0xff;}' unless defined(&PCI_INTERFACE_MASK);
    eval 'sub PCI_INTERFACE {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_INTERFACE_SHIFT) &  &PCI_INTERFACE_MASK));
    }' unless defined(&PCI_INTERFACE);
    eval 'sub PCI_REVISION_SHIFT () {0;}' unless defined(&PCI_REVISION_SHIFT);
    eval 'sub PCI_REVISION_MASK () {0xff;}' unless defined(&PCI_REVISION_MASK);
    eval 'sub PCI_REVISION {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_REVISION_SHIFT) &  &PCI_REVISION_MASK));
    }' unless defined(&PCI_REVISION);
    eval 'sub PCI_CLASS_PREHISTORIC () {0x;}' unless defined(&PCI_CLASS_PREHISTORIC);
    eval 'sub PCI_CLASS_MASS_STORAGE () {0x1;}' unless defined(&PCI_CLASS_MASS_STORAGE);
    eval 'sub PCI_CLASS_NETWORK () {0x2;}' unless defined(&PCI_CLASS_NETWORK);
    eval 'sub PCI_CLASS_DISPLAY () {0x3;}' unless defined(&PCI_CLASS_DISPLAY);
    eval 'sub PCI_CLASS_MULTIMEDIA () {0x4;}' unless defined(&PCI_CLASS_MULTIMEDIA);
    eval 'sub PCI_CLASS_MEMORY () {0x5;}' unless defined(&PCI_CLASS_MEMORY);
    eval 'sub PCI_CLASS_BRIDGE () {0x6;}' unless defined(&PCI_CLASS_BRIDGE);
    eval 'sub PCI_CLASS_COMMUNICATIONS () {0x7;}' unless defined(&PCI_CLASS_COMMUNICATIONS);
    eval 'sub PCI_CLASS_SYSTEM () {0x8;}' unless defined(&PCI_CLASS_SYSTEM);
    eval 'sub PCI_CLASS_INPUT () {0x9;}' unless defined(&PCI_CLASS_INPUT);
    eval 'sub PCI_CLASS_DOCK () {0xa;}' unless defined(&PCI_CLASS_DOCK);
    eval 'sub PCI_CLASS_PROCESSOR () {0xb;}' unless defined(&PCI_CLASS_PROCESSOR);
    eval 'sub PCI_CLASS_SERIALBUS () {0xc;}' unless defined(&PCI_CLASS_SERIALBUS);
    eval 'sub PCI_CLASS_WIRELESS () {0xd;}' unless defined(&PCI_CLASS_WIRELESS);
    eval 'sub PCI_CLASS_I2O () {0xe;}' unless defined(&PCI_CLASS_I2O);
    eval 'sub PCI_CLASS_SATCOM () {0xf;}' unless defined(&PCI_CLASS_SATCOM);
    eval 'sub PCI_CLASS_CRYPTO () {0x10;}' unless defined(&PCI_CLASS_CRYPTO);
    eval 'sub PCI_CLASS_DASP () {0x11;}' unless defined(&PCI_CLASS_DASP);
    eval 'sub PCI_CLASS_UNDEFINED () {0xff;}' unless defined(&PCI_CLASS_UNDEFINED);
    eval 'sub PCI_SUBCLASS_PREHISTORIC_MISC () {0x;}' unless defined(&PCI_SUBCLASS_PREHISTORIC_MISC);
    eval 'sub PCI_SUBCLASS_PREHISTORIC_VGA () {0x1;}' unless defined(&PCI_SUBCLASS_PREHISTORIC_VGA);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SCSI () {0x;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SCSI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_IDE () {0x1;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_IDE);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_FLOPPY () {0x2;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_FLOPPY);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_IPI () {0x3;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_IPI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_RAID () {0x4;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_RAID);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_ATA () {0x5;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_ATA);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SATA () {0x6;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SATA);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SAS () {0x7;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SAS);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_MISC);
    eval 'sub PCI_SUBCLASS_NETWORK_ETHERNET () {0x;}' unless defined(&PCI_SUBCLASS_NETWORK_ETHERNET);
    eval 'sub PCI_SUBCLASS_NETWORK_TOKENRING () {0x1;}' unless defined(&PCI_SUBCLASS_NETWORK_TOKENRING);
    eval 'sub PCI_SUBCLASS_NETWORK_FDDI () {0x2;}' unless defined(&PCI_SUBCLASS_NETWORK_FDDI);
    eval 'sub PCI_SUBCLASS_NETWORK_ATM () {0x3;}' unless defined(&PCI_SUBCLASS_NETWORK_ATM);
    eval 'sub PCI_SUBCLASS_NETWORK_ISDN () {0x4;}' unless defined(&PCI_SUBCLASS_NETWORK_ISDN);
    eval 'sub PCI_SUBCLASS_NETWORK_WORLDFIP () {0x5;}' unless defined(&PCI_SUBCLASS_NETWORK_WORLDFIP);
    eval 'sub PCI_SUBCLASS_NETWORK_PCIMGMULTICOMP () {0x6;}' unless defined(&PCI_SUBCLASS_NETWORK_PCIMGMULTICOMP);
    eval 'sub PCI_SUBCLASS_NETWORK_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_NETWORK_MISC);
    eval 'sub PCI_SUBCLASS_DISPLAY_VGA () {0x;}' unless defined(&PCI_SUBCLASS_DISPLAY_VGA);
    eval 'sub PCI_SUBCLASS_DISPLAY_XGA () {0x1;}' unless defined(&PCI_SUBCLASS_DISPLAY_XGA);
    eval 'sub PCI_SUBCLASS_DISPLAY_3D () {0x2;}' unless defined(&PCI_SUBCLASS_DISPLAY_3D);
    eval 'sub PCI_SUBCLASS_DISPLAY_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DISPLAY_MISC);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_VIDEO () {0x;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_VIDEO);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_AUDIO () {0x1;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_AUDIO);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_TELEPHONY () {0x2;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_TELEPHONY);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_HDAUDIO () {0x3;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_HDAUDIO);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_MISC);
    eval 'sub PCI_SUBCLASS_MEMORY_RAM () {0x;}' unless defined(&PCI_SUBCLASS_MEMORY_RAM);
    eval 'sub PCI_SUBCLASS_MEMORY_FLASH () {0x1;}' unless defined(&PCI_SUBCLASS_MEMORY_FLASH);
    eval 'sub PCI_SUBCLASS_MEMORY_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MEMORY_MISC);
    eval 'sub PCI_SUBCLASS_BRIDGE_HOST () {0x;}' unless defined(&PCI_SUBCLASS_BRIDGE_HOST);
    eval 'sub PCI_SUBCLASS_BRIDGE_ISA () {0x1;}' unless defined(&PCI_SUBCLASS_BRIDGE_ISA);
    eval 'sub PCI_SUBCLASS_BRIDGE_EISA () {0x2;}' unless defined(&PCI_SUBCLASS_BRIDGE_EISA);
    eval 'sub PCI_SUBCLASS_BRIDGE_MC () {0x3;}' unless defined(&PCI_SUBCLASS_BRIDGE_MC);
    eval 'sub PCI_SUBCLASS_BRIDGE_PCI () {0x4;}' unless defined(&PCI_SUBCLASS_BRIDGE_PCI);
    eval 'sub PCI_SUBCLASS_BRIDGE_PCMCIA () {0x5;}' unless defined(&PCI_SUBCLASS_BRIDGE_PCMCIA);
    eval 'sub PCI_SUBCLASS_BRIDGE_NUBUS () {0x6;}' unless defined(&PCI_SUBCLASS_BRIDGE_NUBUS);
    eval 'sub PCI_SUBCLASS_BRIDGE_CARDBUS () {0x7;}' unless defined(&PCI_SUBCLASS_BRIDGE_CARDBUS);
    eval 'sub PCI_SUBCLASS_BRIDGE_RACEWAY () {0x8;}' unless defined(&PCI_SUBCLASS_BRIDGE_RACEWAY);
    eval 'sub PCI_SUBCLASS_BRIDGE_STPCI () {0x9;}' unless defined(&PCI_SUBCLASS_BRIDGE_STPCI);
    eval 'sub PCI_SUBCLASS_BRIDGE_INFINIBAND () {0xa;}' unless defined(&PCI_SUBCLASS_BRIDGE_INFINIBAND);
    eval 'sub PCI_SUBCLASS_BRIDGE_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_BRIDGE_MISC);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_SERIAL () {0x;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_SERIAL);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_PARALLEL () {0x1;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_PARALLEL);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MPSERIAL () {0x2;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MPSERIAL);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MODEM () {0x3;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MODEM);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_GPIB () {0x4;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_GPIB);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_SMARTCARD () {0x5;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_SMARTCARD);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MISC);
    eval 'sub PCI_SUBCLASS_SYSTEM_PIC () {0x;}' unless defined(&PCI_SUBCLASS_SYSTEM_PIC);
    eval 'sub PCI_SUBCLASS_SYSTEM_DMA () {0x1;}' unless defined(&PCI_SUBCLASS_SYSTEM_DMA);
    eval 'sub PCI_SUBCLASS_SYSTEM_TIMER () {0x2;}' unless defined(&PCI_SUBCLASS_SYSTEM_TIMER);
    eval 'sub PCI_SUBCLASS_SYSTEM_RTC () {0x3;}' unless defined(&PCI_SUBCLASS_SYSTEM_RTC);
    eval 'sub PCI_SUBCLASS_SYSTEM_PCIHOTPLUG () {0x4;}' unless defined(&PCI_SUBCLASS_SYSTEM_PCIHOTPLUG);
    eval 'sub PCI_SUBCLASS_SYSTEM_SDHC () {0x5;}' unless defined(&PCI_SUBCLASS_SYSTEM_SDHC);
    eval 'sub PCI_SUBCLASS_SYSTEM_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_SYSTEM_MISC);
    eval 'sub PCI_SUBCLASS_INPUT_KEYBOARD () {0x;}' unless defined(&PCI_SUBCLASS_INPUT_KEYBOARD);
    eval 'sub PCI_SUBCLASS_INPUT_DIGITIZER () {0x1;}' unless defined(&PCI_SUBCLASS_INPUT_DIGITIZER);
    eval 'sub PCI_SUBCLASS_INPUT_MOUSE () {0x2;}' unless defined(&PCI_SUBCLASS_INPUT_MOUSE);
    eval 'sub PCI_SUBCLASS_INPUT_SCANNER () {0x3;}' unless defined(&PCI_SUBCLASS_INPUT_SCANNER);
    eval 'sub PCI_SUBCLASS_INPUT_GAMEPORT () {0x4;}' unless defined(&PCI_SUBCLASS_INPUT_GAMEPORT);
    eval 'sub PCI_SUBCLASS_INPUT_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_INPUT_MISC);
    eval 'sub PCI_SUBCLASS_DOCK_GENERIC () {0x;}' unless defined(&PCI_SUBCLASS_DOCK_GENERIC);
    eval 'sub PCI_SUBCLASS_DOCK_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DOCK_MISC);
    eval 'sub PCI_SUBCLASS_PROCESSOR_386 () {0x;}' unless defined(&PCI_SUBCLASS_PROCESSOR_386);
    eval 'sub PCI_SUBCLASS_PROCESSOR_486 () {0x1;}' unless defined(&PCI_SUBCLASS_PROCESSOR_486);
    eval 'sub PCI_SUBCLASS_PROCESSOR_PENTIUM () {0x2;}' unless defined(&PCI_SUBCLASS_PROCESSOR_PENTIUM);
    eval 'sub PCI_SUBCLASS_PROCESSOR_ALPHA () {0x10;}' unless defined(&PCI_SUBCLASS_PROCESSOR_ALPHA);
    eval 'sub PCI_SUBCLASS_PROCESSOR_POWERPC () {0x20;}' unless defined(&PCI_SUBCLASS_PROCESSOR_POWERPC);
    eval 'sub PCI_SUBCLASS_PROCESSOR_MIPS () {0x30;}' unless defined(&PCI_SUBCLASS_PROCESSOR_MIPS);
    eval 'sub PCI_SUBCLASS_PROCESSOR_COPROC () {0x40;}' unless defined(&PCI_SUBCLASS_PROCESSOR_COPROC);
    eval 'sub PCI_SUBCLASS_SERIALBUS_FIREWIRE () {0x;}' unless defined(&PCI_SUBCLASS_SERIALBUS_FIREWIRE);
    eval 'sub PCI_SUBCLASS_SERIALBUS_ACCESS () {0x1;}' unless defined(&PCI_SUBCLASS_SERIALBUS_ACCESS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SSA () {0x2;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SSA);
    eval 'sub PCI_SUBCLASS_SERIALBUS_USB () {0x3;}' unless defined(&PCI_SUBCLASS_SERIALBUS_USB);
    eval 'sub PCI_SUBCLASS_SERIALBUS_FIBER () {0x4;}' unless defined(&PCI_SUBCLASS_SERIALBUS_FIBER);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SMBUS () {0x5;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SMBUS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_INFINIBAND () {0x6;}' unless defined(&PCI_SUBCLASS_SERIALBUS_INFINIBAND);
    eval 'sub PCI_SUBCLASS_SERIALBUS_IPMI () {0x7;}' unless defined(&PCI_SUBCLASS_SERIALBUS_IPMI);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SERCOS () {0x8;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SERCOS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_CANBUS () {0x9;}' unless defined(&PCI_SUBCLASS_SERIALBUS_CANBUS);
    eval 'sub PCI_SUBCLASS_WIRELESS_IRDA () {0x;}' unless defined(&PCI_SUBCLASS_WIRELESS_IRDA);
    eval 'sub PCI_SUBCLASS_WIRELESS_CONSUMERIR () {0x1;}' unless defined(&PCI_SUBCLASS_WIRELESS_CONSUMERIR);
    eval 'sub PCI_SUBCLASS_WIRELESS_RF () {0x10;}' unless defined(&PCI_SUBCLASS_WIRELESS_RF);
    eval 'sub PCI_SUBCLASS_WIRELESS_BLUETOOTH () {0x11;}' unless defined(&PCI_SUBCLASS_WIRELESS_BLUETOOTH);
    eval 'sub PCI_SUBCLASS_WIRELESS_BROADBAND () {0x12;}' unless defined(&PCI_SUBCLASS_WIRELESS_BROADBAND);
    eval 'sub PCI_SUBCLASS_WIRELESS_802_11A () {0x20;}' unless defined(&PCI_SUBCLASS_WIRELESS_802_11A);
    eval 'sub PCI_SUBCLASS_WIRELESS_802_11B () {0x21;}' unless defined(&PCI_SUBCLASS_WIRELESS_802_11B);
    eval 'sub PCI_SUBCLASS_WIRELESS_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_WIRELESS_MISC);
    eval 'sub PCI_SUBCLASS_I2O_STANDARD () {0x;}' unless defined(&PCI_SUBCLASS_I2O_STANDARD);
    eval 'sub PCI_SUBCLASS_SATCOM_TV () {0x1;}' unless defined(&PCI_SUBCLASS_SATCOM_TV);
    eval 'sub PCI_SUBCLASS_SATCOM_AUDIO () {0x2;}' unless defined(&PCI_SUBCLASS_SATCOM_AUDIO);
    eval 'sub PCI_SUBCLASS_SATCOM_VOICE () {0x3;}' unless defined(&PCI_SUBCLASS_SATCOM_VOICE);
    eval 'sub PCI_SUBCLASS_SATCOM_DATA () {0x4;}' unless defined(&PCI_SUBCLASS_SATCOM_DATA);
    eval 'sub PCI_SUBCLASS_CRYPTO_NETCOMP () {0x;}' unless defined(&PCI_SUBCLASS_CRYPTO_NETCOMP);
    eval 'sub PCI_SUBCLASS_CRYPTO_ENTERTAINMENT () {0x10;}' unless defined(&PCI_SUBCLASS_CRYPTO_ENTERTAINMENT);
    eval 'sub PCI_SUBCLASS_CRYPTO_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_CRYPTO_MISC);
    eval 'sub PCI_SUBCLASS_DASP_DPIO () {0x;}' unless defined(&PCI_SUBCLASS_DASP_DPIO);
    eval 'sub PCI_SUBCLASS_DASP_TIMEFREQ () {0x1;}' unless defined(&PCI_SUBCLASS_DASP_TIMEFREQ);
    eval 'sub PCI_SUBCLASS_DASP_SYNC () {0x10;}' unless defined(&PCI_SUBCLASS_DASP_SYNC);
    eval 'sub PCI_SUBCLASS_DASP_MGMT () {0x20;}' unless defined(&PCI_SUBCLASS_DASP_MGMT);
    eval 'sub PCI_SUBCLASS_DASP_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DASP_MISC);
    eval 'sub PCI_BHLC_REG () {0xc;}' unless defined(&PCI_BHLC_REG);
    eval 'sub PCI_BIST_SHIFT () {24;}' unless defined(&PCI_BIST_SHIFT);
    eval 'sub PCI_BIST_MASK () {0xff;}' unless defined(&PCI_BIST_MASK);
    eval 'sub PCI_BIST {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_BIST_SHIFT) &  &PCI_BIST_MASK));
    }' unless defined(&PCI_BIST);
    eval 'sub PCI_HDRTYPE_SHIFT () {16;}' unless defined(&PCI_HDRTYPE_SHIFT);
    eval 'sub PCI_HDRTYPE_MASK () {0xff;}' unless defined(&PCI_HDRTYPE_MASK);
    eval 'sub PCI_HDRTYPE {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_HDRTYPE_SHIFT) &  &PCI_HDRTYPE_MASK));
    }' unless defined(&PCI_HDRTYPE);
    eval 'sub PCI_HDRTYPE_TYPE {
        my($bhlcr) = @_;
	    eval q(( &PCI_HDRTYPE($bhlcr) & 0x7f));
    }' unless defined(&PCI_HDRTYPE_TYPE);
    eval 'sub PCI_HDRTYPE_MULTIFN {
        my($bhlcr) = @_;
	    eval q((( &PCI_HDRTYPE($bhlcr) & 0x80) != 0));
    }' unless defined(&PCI_HDRTYPE_MULTIFN);
    eval 'sub PCI_LATTIMER_SHIFT () {8;}' unless defined(&PCI_LATTIMER_SHIFT);
    eval 'sub PCI_LATTIMER_MASK () {0xff;}' unless defined(&PCI_LATTIMER_MASK);
    eval 'sub PCI_LATTIMER {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_LATTIMER_SHIFT) &  &PCI_LATTIMER_MASK));
    }' unless defined(&PCI_LATTIMER);
    eval 'sub PCI_CACHELINE_SHIFT () {0;}' unless defined(&PCI_CACHELINE_SHIFT);
    eval 'sub PCI_CACHELINE_MASK () {0xff;}' unless defined(&PCI_CACHELINE_MASK);
    eval 'sub PCI_CACHELINE {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_CACHELINE_SHIFT) &  &PCI_CACHELINE_MASK));
    }' unless defined(&PCI_CACHELINE);
    eval 'sub PCI_MAPS () {0x10;}' unless defined(&PCI_MAPS);
    eval 'sub PCI_CARDBUSCIS () {0x28;}' unless defined(&PCI_CARDBUSCIS);
    eval 'sub PCI_SUBVEND_0 () {0x2c;}' unless defined(&PCI_SUBVEND_0);
    eval 'sub PCI_SUBDEV_0 () {0x2e;}' unless defined(&PCI_SUBDEV_0);
    eval 'sub PCI_INTLINE () {0x3c;}' unless defined(&PCI_INTLINE);
    eval 'sub PCI_INTPIN () {0x3d;}' unless defined(&PCI_INTPIN);
    eval 'sub PCI_MINGNT () {0x3e;}' unless defined(&PCI_MINGNT);
    eval 'sub PCI_MAXLAT () {0x3f;}' unless defined(&PCI_MAXLAT);
    eval 'sub PCI_SECSTAT_1 () {0;}' unless defined(&PCI_SECSTAT_1);
    eval 'sub PCI_PRIBUS_1 () {0x18;}' unless defined(&PCI_PRIBUS_1);
    eval 'sub PCI_SECBUS_1 () {0x19;}' unless defined(&PCI_SECBUS_1);
    eval 'sub PCI_SUBBUS_1 () {0x1a;}' unless defined(&PCI_SUBBUS_1);
    eval 'sub PCI_SECLAT_1 () {0x1b;}' unless defined(&PCI_SECLAT_1);
    eval 'sub PCI_IOBASEL_1 () {0x1c;}' unless defined(&PCI_IOBASEL_1);
    eval 'sub PCI_IOLIMITL_1 () {0x1d;}' unless defined(&PCI_IOLIMITL_1);
    eval 'sub PCI_IOBASEH_1 () {0;}' unless defined(&PCI_IOBASEH_1);
    eval 'sub PCI_IOLIMITH_1 () {0;}' unless defined(&PCI_IOLIMITH_1);
    eval 'sub PCI_MEMBASE_1 () {0x20;}' unless defined(&PCI_MEMBASE_1);
    eval 'sub PCI_MEMLIMIT_1 () {0x22;}' unless defined(&PCI_MEMLIMIT_1);
    eval 'sub PCI_PMBASEL_1 () {0x24;}' unless defined(&PCI_PMBASEL_1);
    eval 'sub PCI_PMLIMITL_1 () {0x26;}' unless defined(&PCI_PMLIMITL_1);
    eval 'sub PCI_PMBASEH_1 () {0;}' unless defined(&PCI_PMBASEH_1);
    eval 'sub PCI_PMLIMITH_1 () {0;}' unless defined(&PCI_PMLIMITH_1);
    eval 'sub PCI_BRIDGECTL_1 () {0;}' unless defined(&PCI_BRIDGECTL_1);
    eval 'sub PCI_SUBVEND_1 () {0x34;}' unless defined(&PCI_SUBVEND_1);
    eval 'sub PCI_SUBDEV_1 () {0x36;}' unless defined(&PCI_SUBDEV_1);
    eval 'sub PCI_SECSTAT_2 () {0x16;}' unless defined(&PCI_SECSTAT_2);
    eval 'sub PCI_PRIBUS_2 () {0x18;}' unless defined(&PCI_PRIBUS_2);
    eval 'sub PCI_SECBUS_2 () {0x19;}' unless defined(&PCI_SECBUS_2);
    eval 'sub PCI_SUBBUS_2 () {0x1a;}' unless defined(&PCI_SUBBUS_2);
    eval 'sub PCI_SECLAT_2 () {0x1b;}' unless defined(&PCI_SECLAT_2);
    eval 'sub PCI_MEMBASE0_2 () {0x1c;}' unless defined(&PCI_MEMBASE0_2);
    eval 'sub PCI_MEMLIMIT0_2 () {0x20;}' unless defined(&PCI_MEMLIMIT0_2);
    eval 'sub PCI_MEMBASE1_2 () {0x24;}' unless defined(&PCI_MEMBASE1_2);
    eval 'sub PCI_MEMLIMIT1_2 () {0x28;}' unless defined(&PCI_MEMLIMIT1_2);
    eval 'sub PCI_IOBASE0_2 () {0x2c;}' unless defined(&PCI_IOBASE0_2);
    eval 'sub PCI_IOLIMIT0_2 () {0x30;}' unless defined(&PCI_IOLIMIT0_2);
    eval 'sub PCI_IOBASE1_2 () {0x34;}' unless defined(&PCI_IOBASE1_2);
    eval 'sub PCI_IOLIMIT1_2 () {0x38;}' unless defined(&PCI_IOLIMIT1_2);
    eval 'sub PCI_BRIDGECTL_2 () {0x3e;}' unless defined(&PCI_BRIDGECTL_2);
    eval 'sub PCI_SUBVEND_2 () {0x40;}' unless defined(&PCI_SUBVEND_2);
    eval 'sub PCI_SUBDEV_2 () {0x42;}' unless defined(&PCI_SUBDEV_2);
    eval 'sub PCI_PCCARDIF_2 () {0x44;}' unless defined(&PCI_PCCARDIF_2);
    eval 'sub PCI_MAPREG_START () {0x10;}' unless defined(&PCI_MAPREG_START);
    eval 'sub PCI_MAPREG_END () {0x28;}' unless defined(&PCI_MAPREG_END);
    eval 'sub PCI_MAPREG_PPB_END () {0x18;}' unless defined(&PCI_MAPREG_PPB_END);
    eval 'sub PCI_MAPREG_PCB_END () {0x14;}' unless defined(&PCI_MAPREG_PCB_END);
    eval 'sub PCI_MAPREG_TYPE {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_TYPE_MASK));
    }' unless defined(&PCI_MAPREG_TYPE);
    eval 'sub PCI_MAPREG_TYPE_MASK () {0x1;}' unless defined(&PCI_MAPREG_TYPE_MASK);
    eval 'sub PCI_MAPREG_TYPE_MEM () {0x;}' unless defined(&PCI_MAPREG_TYPE_MEM);
    eval 'sub PCI_MAPREG_TYPE_IO () {0x1;}' unless defined(&PCI_MAPREG_TYPE_IO);
    eval 'sub PCI_MAPREG_MEM_TYPE {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM_TYPE_MASK));
    }' unless defined(&PCI_MAPREG_MEM_TYPE);
    eval 'sub PCI_MAPREG_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_MAPREG_MEM_TYPE_MASK);
    eval 'sub PCI_MAPREG_MEM_TYPE_32BIT () {0x;}' unless defined(&PCI_MAPREG_MEM_TYPE_32BIT);
    eval 'sub PCI_MAPREG_MEM_TYPE_32BIT_1M () {0x2;}' unless defined(&PCI_MAPREG_MEM_TYPE_32BIT_1M);
    eval 'sub PCI_MAPREG_MEM_TYPE_64BIT () {0x4;}' unless defined(&PCI_MAPREG_MEM_TYPE_64BIT);
    eval 'sub _PCI_MAPREG_TYPEBITS {
        my($reg) = @_;
	    eval q(( &PCI_MAPREG_TYPE($reg) ==  &PCI_MAPREG_TYPE_IO ? $reg &  &PCI_MAPREG_TYPE_MASK : $reg & ( &PCI_MAPREG_TYPE_MASK| &PCI_MAPREG_MEM_TYPE_MASK)));
    }' unless defined(&_PCI_MAPREG_TYPEBITS);
    eval 'sub PCI_MAPREG_MEM_PREFETCHABLE {
        my($mr) = @_;
	    eval q(((($mr) &  &PCI_MAPREG_MEM_PREFETCHABLE_MASK) != 0));
    }' unless defined(&PCI_MAPREG_MEM_PREFETCHABLE);
    eval 'sub PCI_MAPREG_MEM_PREFETCHABLE_MASK () {0x8;}' unless defined(&PCI_MAPREG_MEM_PREFETCHABLE_MASK);
    eval 'sub PCI_MAPREG_MEM_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_MEM_ADDR);
    eval 'sub PCI_MAPREG_MEM_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_MEM_ADDR($mr) & - &PCI_MAPREG_MEM_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_MEM_SIZE);
    eval 'sub PCI_MAPREG_MEM_ADDR_MASK () {0xfffffff0;}' unless defined(&PCI_MAPREG_MEM_ADDR_MASK);
    eval 'sub PCI_MAPREG_MEM64_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM64_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_MEM64_ADDR);
    eval 'sub PCI_MAPREG_MEM64_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_MEM64_ADDR($mr) & - &PCI_MAPREG_MEM64_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_MEM64_SIZE);
    eval 'sub PCI_MAPREG_MEM64_ADDR_MASK () {1.844674407370955e+19;}' unless defined(&PCI_MAPREG_MEM64_ADDR_MASK);
    eval 'sub PCI_MAPREG_IO_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_IO_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_IO_ADDR);
    eval 'sub PCI_MAPREG_IO_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_IO_ADDR($mr) & - &PCI_MAPREG_IO_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_IO_SIZE);
    eval 'sub PCI_MAPREG_IO_ADDR_MASK () {0xfffffffe;}' unless defined(&PCI_MAPREG_IO_ADDR_MASK);
    eval 'sub PCI_CARDBUS_CIS_REG () {0x28;}' unless defined(&PCI_CARDBUS_CIS_REG);
    eval 'sub PCI_SUBSYS_ID_REG () {0x2c;}' unless defined(&PCI_SUBSYS_ID_REG);
    eval 'sub PCI_ROM_REG () {0x30;}' unless defined(&PCI_ROM_REG);
    eval 'sub PCI_ROM_ENABLE () {0x1;}' unless defined(&PCI_ROM_ENABLE);
    eval 'sub PCI_ROM_ADDR_MASK () {0xfffff800;}' unless defined(&PCI_ROM_ADDR_MASK);
    eval 'sub PCI_ROM_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_ROM_ADDR_MASK));
    }' unless defined(&PCI_ROM_ADDR);
    eval 'sub PCI_ROM_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_ROM_ADDR($mr) & - &PCI_ROM_ADDR($mr)));
    }' unless defined(&PCI_ROM_SIZE);
    eval 'sub PCI_CAPLISTPTR_REG () {0x34;}' unless defined(&PCI_CAPLISTPTR_REG);
    eval 'sub PCI_CARDBUS_CAPLISTPTR_REG () {0x14;}' unless defined(&PCI_CARDBUS_CAPLISTPTR_REG);
    eval 'sub PCI_CAPLIST_PTR {
        my($cpr) = @_;
	    eval q((($cpr) & 0xff));
    }' unless defined(&PCI_CAPLIST_PTR);
    eval 'sub PCI_CAPLIST_NEXT {
        my($cr) = @_;
	    eval q(((($cr) >> 8) & 0xff));
    }' unless defined(&PCI_CAPLIST_NEXT);
    eval 'sub PCI_CAPLIST_CAP {
        my($cr) = @_;
	    eval q((($cr) & 0xff));
    }' unless defined(&PCI_CAPLIST_CAP);
    eval 'sub PCI_CAP_RESERVED () {0x;}' unless defined(&PCI_CAP_RESERVED);
    eval 'sub PCI_CAP_PWRMGMT () {0x1;}' unless defined(&PCI_CAP_PWRMGMT);
    eval 'sub PCI_CAP_AGP () {0x2;}' unless defined(&PCI_CAP_AGP);
    eval 'sub PCI_CAP_VPD () {0x3;}' unless defined(&PCI_CAP_VPD);
    eval 'sub PCI_CAP_SLOTID () {0x4;}' unless defined(&PCI_CAP_SLOTID);
    eval 'sub PCI_CAP_MSI () {0x5;}' unless defined(&PCI_CAP_MSI);
    eval 'sub PCI_CAP_CPCI_HOTSWAP () {0x6;}' unless defined(&PCI_CAP_CPCI_HOTSWAP);
    eval 'sub PCI_CAP_PCIX () {0x7;}' unless defined(&PCI_CAP_PCIX);
    eval 'sub PCI_CAP_LDT () {0x8;}' unless defined(&PCI_CAP_LDT);
    eval 'sub PCI_CAP_VENDSPEC () {0x9;}' unless defined(&PCI_CAP_VENDSPEC);
    eval 'sub PCI_CAP_DEBUGPORT () {0xa;}' unless defined(&PCI_CAP_DEBUGPORT);
    eval 'sub PCI_CAP_CPCI_RSRCCTL () {0xb;}' unless defined(&PCI_CAP_CPCI_RSRCCTL);
    eval 'sub PCI_CAP_HOTPLUG () {0xc;}' unless defined(&PCI_CAP_HOTPLUG);
    eval 'sub PCI_CAP_AGP8 () {0xe;}' unless defined(&PCI_CAP_AGP8);
    eval 'sub PCI_CAP_SECURE () {0xf;}' unless defined(&PCI_CAP_SECURE);
    eval 'sub PCI_CAP_PCIEXPRESS () {0x10;}' unless defined(&PCI_CAP_PCIEXPRESS);
    eval 'sub PCI_CAP_MSIX () {0x11;}' unless defined(&PCI_CAP_MSIX);
    eval 'sub PCI_VPD_ADDRESS_MASK () {0x7fff;}' unless defined(&PCI_VPD_ADDRESS_MASK);
    eval 'sub PCI_VPD_ADDRESS_SHIFT () {16;}' unless defined(&PCI_VPD_ADDRESS_SHIFT);
    eval 'sub PCI_VPD_ADDRESS {
        my($ofs) = @_;
	    eval q(((($ofs) &  &PCI_VPD_ADDRESS_MASK) <<  &PCI_VPD_ADDRESS_SHIFT));
    }' unless defined(&PCI_VPD_ADDRESS);
    eval 'sub PCI_VPD_DATAREG {
        my($ofs) = @_;
	    eval q((($ofs) + 4));
    }' unless defined(&PCI_VPD_DATAREG);
    eval 'sub PCI_VPD_OPFLAG () {0x80000000;}' unless defined(&PCI_VPD_OPFLAG);
    eval 'sub PCI_PMCSR () {0x4;}' unless defined(&PCI_PMCSR);
    eval 'sub PCI_PMCSR_STATE_MASK () {0x3;}' unless defined(&PCI_PMCSR_STATE_MASK);
    eval 'sub PCI_PMCSR_STATE_D0 () {0x;}' unless defined(&PCI_PMCSR_STATE_D0);
    eval 'sub PCI_PMCSR_STATE_D1 () {0x1;}' unless defined(&PCI_PMCSR_STATE_D1);
    eval 'sub PCI_PMCSR_STATE_D2 () {0x2;}' unless defined(&PCI_PMCSR_STATE_D2);
    eval 'sub PCI_PMCSR_STATE_D3 () {0x3;}' unless defined(&PCI_PMCSR_STATE_D3);
    eval 'sub PCI_PCIE_XCAP () {0x;}' unless defined(&PCI_PCIE_XCAP);
    eval 'sub PCI_PCIE_XCAP_SI () {0x1000000;}' unless defined(&PCI_PCIE_XCAP_SI);
    eval 'sub PCI_PCIE_DCAP () {0x4;}' unless defined(&PCI_PCIE_DCAP);
    eval 'sub PCI_PCIE_DCSR () {0x8;}' unless defined(&PCI_PCIE_DCSR);
    eval 'sub PCI_PCIE_LCAP () {0xc;}' unless defined(&PCI_PCIE_LCAP);
    eval 'sub PCI_PCIE_LCSR () {0x10;}' unless defined(&PCI_PCIE_LCSR);
    eval 'sub PCI_PCIE_SLCAP () {0x14;}' unless defined(&PCI_PCIE_SLCAP);
    eval 'sub PCI_PCIE_SLCAP_ABP () {0x1;}' unless defined(&PCI_PCIE_SLCAP_ABP);
    eval 'sub PCI_PCIE_SLCAP_PCP () {0x2;}' unless defined(&PCI_PCIE_SLCAP_PCP);
    eval 'sub PCI_PCIE_SLCAP_MSP () {0x4;}' unless defined(&PCI_PCIE_SLCAP_MSP);
    eval 'sub PCI_PCIE_SLCAP_AIP () {0x8;}' unless defined(&PCI_PCIE_SLCAP_AIP);
    eval 'sub PCI_PCIE_SLCAP_PIP () {0x10;}' unless defined(&PCI_PCIE_SLCAP_PIP);
    eval 'sub PCI_PCIE_SLCAP_HPS () {0x20;}' unless defined(&PCI_PCIE_SLCAP_HPS);
    eval 'sub PCI_PCIE_SLCAP_HPC () {0x40;}' unless defined(&PCI_PCIE_SLCAP_HPC);
    eval 'sub PCI_PCIE_SLCSR () {0x18;}' unless defined(&PCI_PCIE_SLCSR);
    eval 'sub PCI_PCIE_SLCSR_ABE () {0x1;}' unless defined(&PCI_PCIE_SLCSR_ABE);
    eval 'sub PCI_PCIE_SLCSR_PFE () {0x2;}' unless defined(&PCI_PCIE_SLCSR_PFE);
    eval 'sub PCI_PCIE_SLCSR_MSE () {0x4;}' unless defined(&PCI_PCIE_SLCSR_MSE);
    eval 'sub PCI_PCIE_SLCSR_PDE () {0x8;}' unless defined(&PCI_PCIE_SLCSR_PDE);
    eval 'sub PCI_PCIE_SLCSR_CCE () {0x10;}' unless defined(&PCI_PCIE_SLCSR_CCE);
    eval 'sub PCI_PCIE_SLCSR_HPE () {0x20;}' unless defined(&PCI_PCIE_SLCSR_HPE);
    eval 'sub PCI_PCIE_SLCSR_ABP () {0x10000;}' unless defined(&PCI_PCIE_SLCSR_ABP);
    eval 'sub PCI_PCIE_SLCSR_PFD () {0x20000;}' unless defined(&PCI_PCIE_SLCSR_PFD);
    eval 'sub PCI_PCIE_SLCSR_MSC () {0x40000;}' unless defined(&PCI_PCIE_SLCSR_MSC);
    eval 'sub PCI_PCIE_SLCSR_PDC () {0x80000;}' unless defined(&PCI_PCIE_SLCSR_PDC);
    eval 'sub PCI_PCIE_SLCSR_CC () {0x100000;}' unless defined(&PCI_PCIE_SLCSR_CC);
    eval 'sub PCI_PCIE_SLCSR_MS () {0x200000;}' unless defined(&PCI_PCIE_SLCSR_MS);
    eval 'sub PCI_PCIE_SLCSR_PDS () {0x400000;}' unless defined(&PCI_PCIE_SLCSR_PDS);
    eval 'sub PCI_PCIE_SLCSR_LACS () {0x1000000;}' unless defined(&PCI_PCIE_SLCSR_LACS);
    eval 'sub PCI_PCIE_RCSR () {0x1c;}' unless defined(&PCI_PCIE_RCSR);
    eval 'sub PCI_INTERRUPT_REG () {0x3c;}' unless defined(&PCI_INTERRUPT_REG);
    eval 'sub PCI_INTERRUPT_PIN_SHIFT () {8;}' unless defined(&PCI_INTERRUPT_PIN_SHIFT);
    eval 'sub PCI_INTERRUPT_PIN_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_PIN_MASK);
    eval 'sub PCI_INTERRUPT_PIN {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_PIN_SHIFT) &  &PCI_INTERRUPT_PIN_MASK));
    }' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_INTERRUPT_LINE_SHIFT () {0;}' unless defined(&PCI_INTERRUPT_LINE_SHIFT);
    eval 'sub PCI_INTERRUPT_LINE_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_LINE_MASK);
    eval 'sub PCI_INTERRUPT_LINE {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_LINE_SHIFT) &  &PCI_INTERRUPT_LINE_MASK));
    }' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_MIN_GNT_SHIFT () {16;}' unless defined(&PCI_MIN_GNT_SHIFT);
    eval 'sub PCI_MIN_GNT_MASK () {0xff;}' unless defined(&PCI_MIN_GNT_MASK);
    eval 'sub PCI_MIN_GNT {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_MIN_GNT_SHIFT) &  &PCI_MIN_GNT_MASK));
    }' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_MAX_LAT_SHIFT () {24;}' unless defined(&PCI_MAX_LAT_SHIFT);
    eval 'sub PCI_MAX_LAT_MASK () {0xff;}' unless defined(&PCI_MAX_LAT_MASK);
    eval 'sub PCI_MAX_LAT {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_MAX_LAT_SHIFT) &  &PCI_MAX_LAT_MASK));
    }' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_INTERRUPT_PIN_NONE () {0x;}' unless defined(&PCI_INTERRUPT_PIN_NONE);
    eval 'sub PCI_INTERRUPT_PIN_A () {0x1;}' unless defined(&PCI_INTERRUPT_PIN_A);
    eval 'sub PCI_INTERRUPT_PIN_B () {0x2;}' unless defined(&PCI_INTERRUPT_PIN_B);
    eval 'sub PCI_INTERRUPT_PIN_C () {0x3;}' unless defined(&PCI_INTERRUPT_PIN_C);
    eval 'sub PCI_INTERRUPT_PIN_D () {0x4;}' unless defined(&PCI_INTERRUPT_PIN_D);
    eval 'sub PCI_INTERRUPT_PIN_MAX () {0x4;}' unless defined(&PCI_INTERRUPT_PIN_MAX);
    eval 'sub PCI_VPDRES_ISLARGE {
        my($x) = @_;
	    eval q((($x) & 0x80));
    }' unless defined(&PCI_VPDRES_ISLARGE);
    eval 'sub PCI_VPDRES_SMALL_LENGTH {
        my($x) = @_;
	    eval q((($x) & 0x7));
    }' unless defined(&PCI_VPDRES_SMALL_LENGTH);
    eval 'sub PCI_VPDRES_SMALL_NAME {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0xf));
    }' unless defined(&PCI_VPDRES_SMALL_NAME);
    eval 'sub PCI_VPDRES_LARGE_NAME {
        my($x) = @_;
	    eval q((($x) & 0x7f));
    }' unless defined(&PCI_VPDRES_LARGE_NAME);
    eval 'sub PCI_VPDRES_TYPE_COMPATIBLE_DEVICE_ID () {0x3;}' unless defined(&PCI_VPDRES_TYPE_COMPATIBLE_DEVICE_ID);
    eval 'sub PCI_VPDRES_TYPE_VENDOR_DEFINED () {0xe;}' unless defined(&PCI_VPDRES_TYPE_VENDOR_DEFINED);
    eval 'sub PCI_VPDRES_TYPE_END_TAG () {0xf;}' unless defined(&PCI_VPDRES_TYPE_END_TAG);
    eval 'sub PCI_VPDRES_TYPE_IDENTIFIER_STRING () {0x2;}' unless defined(&PCI_VPDRES_TYPE_IDENTIFIER_STRING);
    eval 'sub PCI_VPDRES_TYPE_VPD () {0x10;}' unless defined(&PCI_VPDRES_TYPE_VPD);
}
1;
