/* r128_drv.c -- ATI Rage 128 driver -*- linux-c -*-
 * Created: Mon Dec 13 09:47:27 1999 by faith@precisioninsight.com
 */
/*-
 * Copyright 1999 Precision Insight, Inc., Cedar Park, Texas.
 * Copyright 2000 VA Linux Systems, Inc., Sunnyvale, California.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * VA LINUX SYSTEMS AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *    Rickard E. (Rik) Faith <faith@valinux.com>
 *    Gareth Hughes <gareth@valinux.com>
 *
 */

#include "drmP.h"
#include "drm.h"
#include "r128_drm.h"
#include "r128_drv.h"
#include "drm_pciids.h"

void r128_configure(drm_device_t *);

/* drv_PCI_IDs comes from drm_pciids.h, generated from drm_pciids.txt. */
static drm_pci_id_list_t r128_pciidlist[] = {
	r128_PCI_IDS
};

void
r128_configure(drm_device_t *dev)
{
	dev->driver.buf_priv_size	= sizeof(drm_r128_buf_priv_t);
	dev->driver.preclose		= r128_driver_preclose;
	dev->driver.lastclose		= r128_driver_lastclose;
	dev->driver.vblank_wait		= r128_driver_vblank_wait;
	dev->driver.irq_preinstall	= r128_driver_irq_preinstall;
	dev->driver.irq_postinstall	= r128_driver_irq_postinstall;
	dev->driver.irq_uninstall	= r128_driver_irq_uninstall;
	dev->driver.irq_handler		= r128_driver_irq_handler;
	dev->driver.dma_ioctl		= r128_cce_buffers;

	dev->driver.ioctls		= r128_ioctls;
	dev->driver.max_ioctl		= r128_max_ioctl;

	dev->driver.name		= DRIVER_NAME;
	dev->driver.desc		= DRIVER_DESC;
	dev->driver.date		= DRIVER_DATE;
	dev->driver.major		= DRIVER_MAJOR;
	dev->driver.minor		= DRIVER_MINOR;
	dev->driver.patchlevel		= DRIVER_PATCHLEVEL;

	dev->driver.use_agp		= 1;
	dev->driver.use_mtrr		= 1;
	dev->driver.use_pci_dma		= 1;
	dev->driver.use_sg		= 1;
	dev->driver.use_dma		= 1;
	dev->driver.use_irq		= 1;
	dev->driver.use_vbl_irq		= 1;
}

#ifdef __FreeBSD__
static int
r128_probe(device_t dev)
{
	return drm_probe(dev, r128_pciidlist);
}

static int
r128_attach(device_t nbdev)
{
	drm_device_t *dev = device_get_softc(nbdev);

	bzero(dev, sizeof(drm_device_t));
	r128_configure(dev);
	return drm_attach(nbdev, r128_pciidlist);
}

static device_method_t r128_methods[] = {
	/* Device interface */
	DEVMETHOD(device_probe,		r128_probe),
	DEVMETHOD(device_attach,	r128_attach),
	DEVMETHOD(device_detach,	drm_detach),

	{ 0, 0 }
};

static driver_t r128_driver = {
	"drm",
	r128_methods,
	sizeof(drm_device_t)
};

extern devclass_t drm_devclass;
#if __FreeBSD_version >= 700010
DRIVER_MODULE(r128, vgapci, r128_driver, drm_devclass, 0, 0);
#else
DRIVER_MODULE(r128, pci, r128_driver, drm_devclass, 0, 0);
#endif
MODULE_DEPEND(r128, drm, 1, 1, 1);

#elif defined(__NetBSD__) || defined(__OpenBSD__)

int	r128drm_probe(struct device *, void *, void *);
void	r128drm_attach(struct device *, struct device *, void *);

int
#if defined(__OpenBSD__)
r128drm_probe(struct device *parent, void *match, void *aux)
#else
r128drm_probe(struct device *parent, struct cfdata *match, void *aux)
#endif
{
	return drm_probe((struct pci_attach_args *)aux, r128_pciidlist);
}

void
r128drm_attach(struct device *parent, struct device *self, void *aux)
{
	struct pci_attach_args *pa = aux;
	drm_device_t *dev = (drm_device_t *)self;

	r128_configure(dev);
	return drm_attach(self, pa, r128_pciidlist);
}

#if defined(__OpenBSD__)
struct cfattach ragedrm_ca = {
	sizeof(drm_device_t), r128drm_probe, r128drm_attach,
	drm_detach, drm_activate
};

struct cfdriver ragedrm_cd = {
	0, "ragedrm", DV_DULL
};
#else
#ifdef _LKM
CFDRIVER_DECL(r128drm, DV_TTY, NULL);
#else
CFATTACH_DECL(r128drm, sizeof(drm_device_t), r128drm_probe, r128drm_attach,
	drm_detach, drm_activate);
#endif
#endif

#endif
