/*	$OpenBSD: udivsi3.S,v 1.1 2006/11/10 07:44:58 drahn Exp $	*/
/*	$NetBSD: udivsi3.S,v 1.7 2006/05/22 20:56:44 uwe Exp $	*/

/* copied from libkern with raise code removed */

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)udivsi3.s	5.1 (Berkeley) 5/15/90
 */

#include <machine/asm.h>

/*
 * IMPORTANT: This function is special.
 *
 * This function is an auxiliary function that is referenced by the
 * code generated by gcc for integer division.  But gcc does NOT treat
 * a call to this function as an ordinary function call w.r.t. the set
 * of register this call clobbers.  See the definition of "udivsi3_i1"
 * in gcc/config/sh/sh.md.
 *
 * Any call to this function MUST NOT clobber any registers besides r4
 * and r0, where the result is returned.  At the time of the call the
 * r4 contains the first argument, so we are only left with r0, and we
 * cannot do anything meaningful using only one register.  The
 * consequences are:
 *
 * . this function cannot have _PROF_PROLOGUE
 * . this function cannot be called via PLT
 */


/* r0 <= r4 / r5 */
NENTRY(__udivsi3)
	tst	r5, r5
	bt	div_by_zero

	mov	#0, r0
	div0u
#define DIVSTEP	rotcl r4; div1 r5, r0
	/* repeat 32 times */
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
	DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP; DIVSTEP;
#undef DIVSTEP
	rotcl	r4

	rts
	 mov	r4, r0

div_by_zero:
	rts
	 mov	#0, r0
