require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IF_BWIVAR_H)) {
    eval 'sub _IF_BWIVAR_H () {1;}' unless defined(&_IF_BWIVAR_H);
    eval 'sub BWI_ALIGN () {0x1000;}' unless defined(&BWI_ALIGN);
    eval 'sub BWI_RING_ALIGN () { &BWI_ALIGN;}' unless defined(&BWI_RING_ALIGN);
    eval 'sub BWI_BUS_SPACE_MAXADDR () {0x3fffffff;}' unless defined(&BWI_BUS_SPACE_MAXADDR);
    eval 'sub BWI_TX_NRING () {6;}' unless defined(&BWI_TX_NRING);
    eval 'sub BWI_TXRX_NRING () {6;}' unless defined(&BWI_TXRX_NRING);
    eval 'sub BWI_TX_NDESC () {128;}' unless defined(&BWI_TX_NDESC);
    eval 'sub BWI_RX_NDESC () {64;}' unless defined(&BWI_RX_NDESC);
    eval 'sub BWI_TXSTATS_NDESC () {64;}' unless defined(&BWI_TXSTATS_NDESC);
    eval 'sub BWI_TX_NSPRDESC () {2;}' unless defined(&BWI_TX_NSPRDESC);
    eval 'sub BWI_TX_DATA_RING () {1;}' unless defined(&BWI_TX_DATA_RING);
    eval 'sub BWI_SHRETRY () {7;}' unless defined(&BWI_SHRETRY);
    eval 'sub BWI_LGRETRY () {4;}' unless defined(&BWI_LGRETRY);
    eval 'sub BWI_SHRETRY_FB () {3;}' unless defined(&BWI_SHRETRY_FB);
    eval 'sub BWI_LGRETRY_FB () {2;}' unless defined(&BWI_LGRETRY_FB);
    eval 'sub BWI_LED_EVENT_NONE () {-1;}' unless defined(&BWI_LED_EVENT_NONE);
    eval 'sub BWI_LED_EVENT_POLL () {0;}' unless defined(&BWI_LED_EVENT_POLL);
    eval 'sub BWI_LED_EVENT_TX () {1;}' unless defined(&BWI_LED_EVENT_TX);
    eval 'sub BWI_LED_EVENT_RX () {2;}' unless defined(&BWI_LED_EVENT_RX);
    eval 'sub BWI_LED_SLOWDOWN {
        my($dur) = @_;
	    eval q(($dur) = ((($dur) * 3) / 2));
    }' unless defined(&BWI_LED_SLOWDOWN);
    eval("sub BWI_TXPWR_INIT () { 0; }") unless defined(&BWI_TXPWR_INIT);
    eval("sub BWI_TXPWR_FORCE () { 1; }") unless defined(&BWI_TXPWR_FORCE);
    eval("sub BWI_TXPWR_CALIB () { 2; }") unless defined(&BWI_TXPWR_CALIB);
    eval 'sub BWI_NOISE_FLOOR () {-95;}' unless defined(&BWI_NOISE_FLOOR);
    eval 'sub CSR_READ_4 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_4(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg)));
    }' unless defined(&CSR_READ_4);
    eval 'sub CSR_READ_2 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_2(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg)));
    }' unless defined(&CSR_READ_2);
    eval 'sub CSR_WRITE_4 {
        my($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg), ($val)));
    }' unless defined(&CSR_WRITE_4);
    eval 'sub CSR_WRITE_2 {
        my($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_2(($sc)-> &sc_mem_bt, ($sc)-> &sc_mem_bh, ($reg), ($val)));
    }' unless defined(&CSR_WRITE_2);
    eval 'sub CSR_SETBITS_4 {
        my($sc, $reg, $bits) = @_;
	    eval q( &CSR_WRITE_4(($sc), ($reg),  &CSR_READ_4(($sc), ($reg)) | ($bits)));
    }' unless defined(&CSR_SETBITS_4);
    eval 'sub CSR_SETBITS_2 {
        my($sc, $reg, $bits) = @_;
	    eval q( &CSR_WRITE_2(($sc), ($reg),  &CSR_READ_2(($sc), ($reg)) | ($bits)));
    }' unless defined(&CSR_SETBITS_2);
    eval 'sub CSR_FILT_SETBITS_4 {
        my($sc, $reg, $filt, $bits) = @_;
	    eval q( &CSR_WRITE_4(($sc), ($reg), ( &CSR_READ_4(($sc), ($reg)) & ($filt)) | ($bits)));
    }' unless defined(&CSR_FILT_SETBITS_4);
    eval 'sub CSR_FILT_SETBITS_2 {
        my($sc, $reg, $filt, $bits) = @_;
	    eval q( &CSR_WRITE_2(($sc), ($reg), ( &CSR_READ_2(($sc), ($reg)) & ($filt)) | ($bits)));
    }' unless defined(&CSR_FILT_SETBITS_2);
    eval 'sub CSR_CLRBITS_4 {
        my($sc, $reg, $bits) = @_;
	    eval q( &CSR_WRITE_4(($sc), ($reg),  &CSR_READ_4(($sc), ($reg)) & ~($bits)));
    }' unless defined(&CSR_CLRBITS_4);
    eval 'sub CSR_CLRBITS_2 {
        my($sc, $reg, $bits) = @_;
	    eval q( &CSR_WRITE_2(($sc), ($reg),  &CSR_READ_2(($sc), ($reg)) & ~($bits)));
    }' unless defined(&CSR_CLRBITS_2);
    eval 'sub BWI_DESC32_A_FUNC_TXRX () {0x1;}' unless defined(&BWI_DESC32_A_FUNC_TXRX);
    eval 'sub BWI_DESC32_A_FUNC_MASK () {0xc0000000;}' unless defined(&BWI_DESC32_A_FUNC_MASK);
    eval 'sub BWI_DESC32_A_ADDR_MASK () {0x3fffffff;}' unless defined(&BWI_DESC32_A_ADDR_MASK);
    eval 'sub BWI_DESC32_C_BUFLEN_MASK () {0x1fff;}' unless defined(&BWI_DESC32_C_BUFLEN_MASK);
    eval 'sub BWI_DESC32_C_ADDRHI_MASK () {0x30000;}' unless defined(&BWI_DESC32_C_ADDRHI_MASK);
    eval 'sub BWI_DESC32_C_EOR () {(1<< 28);}' unless defined(&BWI_DESC32_C_EOR);
    eval 'sub BWI_DESC32_C_INTR () {(1<< 29);}' unless defined(&BWI_DESC32_C_INTR);
    eval 'sub BWI_DESC32_C_FRAME_END () {(1<< 30);}' unless defined(&BWI_DESC32_C_FRAME_END);
    eval 'sub BWI_DESC32_C_FRAME_START () {(1<< 31);}' unless defined(&BWI_DESC32_C_FRAME_START);
    eval 'sub BWI_RXH_F1_BCM2053_RSSI () {(1<< 14);}' unless defined(&BWI_RXH_F1_BCM2053_RSSI);
    eval 'sub BWI_RXH_F1_OFDM () {(1<< 0);}' unless defined(&BWI_RXH_F1_OFDM);
    eval 'sub BWI_RXH_F2_TYPE2FRAME () {(1<< 2);}' unless defined(&BWI_RXH_F2_TYPE2FRAME);
    eval 'sub BWI_RXH_F3_BCM2050_RSSI () {(1<< 10);}' unless defined(&BWI_RXH_F3_BCM2050_RSSI);
    eval 'sub BWI_RXH_PHYINFO_LNAGAIN () {(3<< 14);}' unless defined(&BWI_RXH_PHYINFO_LNAGAIN);
    eval 'sub BWI_TXH_ID_RING_MASK () {0xe000;}' unless defined(&BWI_TXH_ID_RING_MASK);
    eval 'sub BWI_TXH_ID_IDX_MASK () {0x1fff;}' unless defined(&BWI_TXH_ID_IDX_MASK);
    eval 'sub BWI_TXH_PHY_C_OFDM () {(1<< 0);}' unless defined(&BWI_TXH_PHY_C_OFDM);
    eval 'sub BWI_TXH_PHY_C_SHPREAMBLE () {(1<< 4);}' unless defined(&BWI_TXH_PHY_C_SHPREAMBLE);
    eval 'sub BWI_TXH_PHY_C_ANTMODE_MASK () {0x300;}' unless defined(&BWI_TXH_PHY_C_ANTMODE_MASK);
    eval 'sub BWI_TXH_MAC_C_ACK () {(1<< 0);}' unless defined(&BWI_TXH_MAC_C_ACK);
    eval 'sub BWI_TXH_MAC_C_FIRST_FRAG () {(1<< 3);}' unless defined(&BWI_TXH_MAC_C_FIRST_FRAG);
    eval 'sub BWI_TXH_MAC_C_HWSEQ () {(1<< 4);}' unless defined(&BWI_TXH_MAC_C_HWSEQ);
    eval 'sub BWI_TXH_MAC_C_FB_OFDM () {(1<< 8);}' unless defined(&BWI_TXH_MAC_C_FB_OFDM);
    eval 'sub fw_iv_cnt () { &fw_size;}' unless defined(&fw_iv_cnt);
    eval 'sub BWI_FWHDR_SZ () {$sizeof{\'struct bwi_fwhdr\'};}' unless defined(&BWI_FWHDR_SZ);
    eval 'sub BWI_FW_VERSION3 () {3;}' unless defined(&BWI_FW_VERSION3);
    eval 'sub BWI_FW_VERSION4 () {4;}' unless defined(&BWI_FW_VERSION4);
    eval 'sub BWI_FW_VERSION3_REVMAX () {0x128;}' unless defined(&BWI_FW_VERSION3_REVMAX);
    eval 'sub BWI_FW_T_UCODE () {ord(\'u\');}' unless defined(&BWI_FW_T_UCODE);
    eval 'sub BWI_FW_T_PCM () {ord(\'p\');}' unless defined(&BWI_FW_T_PCM);
    eval 'sub BWI_FW_T_IV () {ord(\'i\');}' unless defined(&BWI_FW_T_IV);
    eval 'sub BWI_FW_GEN_1 () {1;}' unless defined(&BWI_FW_GEN_1);
    eval 'sub BWI_FW_IV_OFS_MASK () {0x7fff;}' unless defined(&BWI_FW_IV_OFS_MASK);
    eval 'sub BWI_FW_IV_IS_32BIT () {(1<< 15);}' unless defined(&BWI_FW_IV_IS_32BIT);
    eval 'sub BWI_LED_F_ACTLOW () {0x1;}' unless defined(&BWI_LED_F_ACTLOW);
    eval 'sub BWI_LED_F_BLINK () {0x2;}' unless defined(&BWI_LED_F_BLINK);
    eval 'sub BWI_LED_F_POLLABLE () {0x4;}' unless defined(&BWI_LED_F_POLLABLE);
    eval 'sub BWI_LED_F_SLOW () {0x8;}' unless defined(&BWI_LED_F_SLOW);
    eval("sub BWI_CLOCK_MODE_SLOW () { 0; }") unless defined(&BWI_CLOCK_MODE_SLOW);
    eval("sub BWI_CLOCK_MODE_FAST () { 1; }") unless defined(&BWI_CLOCK_MODE_FAST);
    eval("sub BWI_CLOCK_MODE_DYN () { 2; }") unless defined(&BWI_CLOCK_MODE_DYN);
    eval 'sub BWI_REGWIN_F_EXIST () {0x1;}' unless defined(&BWI_REGWIN_F_EXIST);
    eval 'sub BWI_CREATE_REGWIN {
        my($rw, $id, $type, $rev) = @_;
	    eval q( &do { ($rw)-> &rw_flags =  &BWI_REGWIN_F_EXIST; ($rw)-> &rw_type = ($type); ($rw)-> &rw_id = ($id); ($rw)-> &rw_rev = ($rev); }  &while (0));
    }' unless defined(&BWI_CREATE_REGWIN);
    eval 'sub BWI_REGWIN_EXIST {
        my($rw) = @_;
	    eval q((($rw)-> &rw_flags &  &BWI_REGWIN_F_EXIST));
    }' unless defined(&BWI_REGWIN_EXIST);
    eval 'sub BWI_GPIO_REGWIN {
        my($sc) = @_;
	    eval q(( &BWI_REGWIN_EXIST(($sc)-> &sc_com_regwin) ? ($sc)-> &sc_com_regwin : ($sc)-> &sc_bus_regwin));
    }' unless defined(&BWI_GPIO_REGWIN);
    eval 'sub BWI_PHY_F_CALIBRATED () {0x1;}' unless defined(&BWI_PHY_F_CALIBRATED);
    eval 'sub BWI_PHY_F_LINKED () {0x2;}' unless defined(&BWI_PHY_F_LINKED);
    eval 'sub BWI_CLEAR_PHY_FLAGS () {( &BWI_PHY_F_CALIBRATED);}' unless defined(&BWI_CLEAR_PHY_FLAGS);
    eval 'sub BWI_RF_ATTEN_FACTOR () {4;}' unless defined(&BWI_RF_ATTEN_FACTOR);
    eval 'sub BWI_RF_ATTEN_MAX0 () {9;}' unless defined(&BWI_RF_ATTEN_MAX0);
    eval 'sub BWI_RF_ATTEN_MAX1 () {31;}' unless defined(&BWI_RF_ATTEN_MAX1);
    eval 'sub BWI_BBP_ATTEN_MAX () {11;}' unless defined(&BWI_BBP_ATTEN_MAX);
    eval 'sub BWI_TPCTL1_MAX () {7;}' unless defined(&BWI_TPCTL1_MAX);
    eval 'sub BWI_RFLO_MAX () {56;}' unless defined(&BWI_RFLO_MAX);
    eval 'sub BWI_INVALID_NRSSI () {-1000;}' unless defined(&BWI_INVALID_NRSSI);
    eval 'sub BWI_NRSSI_TBLSZ () {64;}' unless defined(&BWI_NRSSI_TBLSZ);
    eval 'sub BWI_TSSI_MAX () {64;}' unless defined(&BWI_TSSI_MAX);
    eval 'sub BWI_RF_F_INITED () {0x1;}' unless defined(&BWI_RF_F_INITED);
    eval 'sub BWI_RF_F_ON () {0x2;}' unless defined(&BWI_RF_F_ON);
    eval 'sub BWI_RF_CLEAR_FLAGS () {( &BWI_RF_F_INITED);}' unless defined(&BWI_RF_CLEAR_FLAGS);
    eval 'sub BWI_ANT_MODE_0 () {0;}' unless defined(&BWI_ANT_MODE_0);
    eval 'sub BWI_ANT_MODE_1 () {1;}' unless defined(&BWI_ANT_MODE_1);
    eval 'sub BWI_ANT_MODE_UNKN () {2;}' unless defined(&BWI_ANT_MODE_UNKN);
    eval 'sub BWI_ANT_MODE_AUTO () {3;}' unless defined(&BWI_ANT_MODE_AUTO);
    eval 'sub mac_rw_flags () { ($mac_regwin->{rw_flags});}' unless defined(&mac_rw_flags);
    eval 'sub mac_type () { ($mac_regwin->{rw_type});}' unless defined(&mac_type);
    eval 'sub mac_id () { ($mac_regwin->{rw_id});}' unless defined(&mac_id);
    eval 'sub mac_rev () { ($mac_regwin->{rw_rev});}' unless defined(&mac_rev);
    eval 'sub BWI_MAC_F_BSWAP () {0x1;}' unless defined(&BWI_MAC_F_BSWAP);
    eval 'sub BWI_MAC_F_TPCTL_INITED () {0x2;}' unless defined(&BWI_MAC_F_TPCTL_INITED);
    eval 'sub BWI_MAC_F_HAS_TXSTATS () {0x4;}' unless defined(&BWI_MAC_F_HAS_TXSTATS);
    eval 'sub BWI_MAC_F_INITED () {0x8;}' unless defined(&BWI_MAC_F_INITED);
    eval 'sub BWI_MAC_F_ENABLED () {0x10;}' unless defined(&BWI_MAC_F_ENABLED);
    eval 'sub BWI_MAC_F_LOCKED () {0x20;}' unless defined(&BWI_MAC_F_LOCKED);
    eval 'sub BWI_MAC_F_TPCTL_ERROR () {0x40;}' unless defined(&BWI_MAC_F_TPCTL_ERROR);
    eval 'sub BWI_MAC_F_PHYE_RESET () {0x80;}' unless defined(&BWI_MAC_F_PHYE_RESET);
    eval 'sub BWI_CREATE_MAC {
        my($mac, $sc, $id, $rev) = @_;
	    eval q( &do {  &BWI_CREATE_REGWIN(($mac)-> &mac_regwin, ($id),  &BWI_REGWIN_T_MAC, ($rev)); ($mac)-> &mac_sc = ($sc); }  &while (0));
    }' unless defined(&BWI_CREATE_MAC);
    eval 'sub BWI_MAC_MAX () {2;}' unless defined(&BWI_MAC_MAX);
    eval 'sub BWI_LED_MAX () {4;}' unless defined(&BWI_LED_MAX);
    eval("sub BWI_BUS_SPACE_30BIT () { 1; }") unless defined(&BWI_BUS_SPACE_30BIT);
    eval("sub BWI_BUS_SPACE_32BIT () { 2; }") unless defined(&BWI_BUS_SPACE_32BIT);
    eval("sub BWI_BUS_SPACE_64BIT () { 3; }") unless defined(&BWI_BUS_SPACE_64BIT);
    eval 'sub BWI_TX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL));}' unless defined(&BWI_TX_RADIOTAP_PRESENT);
    eval 'sub BWI_RX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_TSFT) | (1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | (1<<  &IEEE80211_RADIOTAP_DBM_ANTSIGNAL) | (1<<  &IEEE80211_RADIOTAP_DBM_ANTNOISE));}' unless defined(&BWI_RX_RADIOTAP_PRESENT);
    if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
	eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
    }
    eval 'sub BWI_F_BUS_INITED () {0x1;}' unless defined(&BWI_F_BUS_INITED);
    eval 'sub BWI_F_PROMISC () {0x2;}' unless defined(&BWI_F_PROMISC);
    eval 'sub abs {
        my($a) = @_;
	    eval q( &__builtin_abs($a));
    }' unless defined(&abs);
    eval 'sub MOBJ_WRITE_2 {
        my($mac, $objid, $ofs, $val) = @_;
	    eval q( &bwi_memobj_write_2(($mac), ($objid), ($ofs), ($val)));
    }' unless defined(&MOBJ_WRITE_2);
    eval 'sub MOBJ_WRITE_4 {
        my($mac, $objid, $ofs, $val) = @_;
	    eval q( &bwi_memobj_write_4(($mac), ($objid), ($ofs), ($val)));
    }' unless defined(&MOBJ_WRITE_4);
    eval 'sub MOBJ_READ_2 {
        my($mac, $objid, $ofs) = @_;
	    eval q( &bwi_memobj_read_2(($mac), ($objid), ($ofs)));
    }' unless defined(&MOBJ_READ_2);
    eval 'sub MOBJ_READ_4 {
        my($mac, $objid, $ofs) = @_;
	    eval q( &bwi_memobj_read_4(($mac), ($objid), ($ofs)));
    }' unless defined(&MOBJ_READ_4);
    eval 'sub MOBJ_SETBITS_4 {
        my($mac, $objid, $ofs, $bits) = @_;
	    eval q( &MOBJ_WRITE_4(($mac), ($objid), ($ofs),  &MOBJ_READ_4(($mac), ($objid), ($ofs)) | ($bits)));
    }' unless defined(&MOBJ_SETBITS_4);
    eval 'sub MOBJ_CLRBITS_4 {
        my($mac, $objid, $ofs, $bits) = @_;
	    eval q( &MOBJ_WRITE_4(($mac), ($objid), ($ofs),  &MOBJ_READ_4(($mac), ($objid), ($ofs)) & ~($bits)));
    }' unless defined(&MOBJ_CLRBITS_4);
    eval 'sub MOBJ_FILT_SETBITS_2 {
        my($mac, $objid, $ofs, $filt, $bits) = @_;
	    eval q( &MOBJ_WRITE_2(($mac), ($objid), ($ofs), ( &MOBJ_READ_2(($mac), ($objid), ($ofs)) & ($filt)) | ($bits)));
    }' unless defined(&MOBJ_FILT_SETBITS_2);
    eval 'sub TMPLT_WRITE_4 {
        my($mac, $ofs, $val) = @_;
	    eval q( &bwi_tmplt_write_4(($mac), ($ofs), ($val)));
    }' unless defined(&TMPLT_WRITE_4);
    eval 'sub HFLAGS_WRITE {
        my($mac, $flags) = @_;
	    eval q( &bwi_hostflags_write(($mac), ($flags)));
    }' unless defined(&HFLAGS_WRITE);
    eval 'sub HFLAGS_READ {
        my($mac) = @_;
	    eval q( &bwi_hostflags_read(($mac)));
    }' unless defined(&HFLAGS_READ);
    eval 'sub HFLAGS_CLRBITS {
        my($mac, $bits) = @_;
	    eval q( &HFLAGS_WRITE(($mac),  &HFLAGS_READ(($mac)) | ($bits)));
    }' unless defined(&HFLAGS_CLRBITS);
    eval 'sub HFLAGS_SETBITS {
        my($mac, $bits) = @_;
	    eval q( &HFLAGS_WRITE(($mac),  &HFLAGS_READ(($mac)) & ~($bits)));
    }' unless defined(&HFLAGS_SETBITS);
    eval 'sub bwi_phy_init {
        my($_mac) = @_;
	    eval q({  ($_mac->{mac_phy}->{phy_init})($_mac); });
    }' unless defined(&bwi_phy_init);
    eval 'sub PHY_WRITE {
        my($mac, $ctrl, $val) = @_;
	    eval q( &bwi_phy_write(($mac), ($ctrl), ($val)));
    }' unless defined(&PHY_WRITE);
    eval 'sub PHY_READ {
        my($mac, $ctrl) = @_;
	    eval q( &bwi_phy_read(($mac), ($ctrl)));
    }' unless defined(&PHY_READ);
    eval 'sub PHY_SETBITS {
        my($mac, $ctrl, $bits) = @_;
	    eval q( &PHY_WRITE(($mac), ($ctrl),  &PHY_READ(($mac), ($ctrl)) | ($bits)));
    }' unless defined(&PHY_SETBITS);
    eval 'sub PHY_CLRBITS {
        my($mac, $ctrl, $bits) = @_;
	    eval q( &PHY_WRITE(($mac), ($ctrl),  &PHY_READ(($mac), ($ctrl)) & ~($bits)));
    }' unless defined(&PHY_CLRBITS);
    eval 'sub PHY_FILT_SETBITS {
        my($mac, $ctrl, $filt, $bits) = @_;
	    eval q( &PHY_WRITE(($mac), ($ctrl), ( &PHY_READ(($mac), ($ctrl)) & ($filt)) | ($bits)));
    }' unless defined(&PHY_FILT_SETBITS);
    eval 'sub bwi_rf_off {
        my($_mac) = @_;
	    eval q({  ($_mac->{mac_rf}->{rf_off})($_mac);  ($_mac->{mac_rf}->{rf_flags}) &= ~ &BWI_RF_F_ON; });
    }' unless defined(&bwi_rf_off);
    eval 'sub bwi_rf_on {
        my($_mac) = @_;
	    eval q({  &if ( ($_mac->{mac_rf}->{rf_flags}) &  &BWI_RF_F_ON) ;  ($_mac->{mac_rf}->{rf_on})($_mac);  ($_mac->{mac_rf}->{rf_flags}) |=  &BWI_RF_F_ON; });
    }' unless defined(&bwi_rf_on);
    eval 'sub bwi_rf_calc_nrssi_slope {
        my($_mac) = @_;
	    eval q({  ($_mac->{mac_rf}->{rf_calc_nrssi_slope})($_mac); });
    }' unless defined(&bwi_rf_calc_nrssi_slope);
    eval 'sub bwi_rf_set_nrssi_thr {
        my($_mac) = @_;
	    eval q({  ($_mac->{mac_rf}->{rf_set_nrssi_thr})($_mac); });
    }' unless defined(&bwi_rf_set_nrssi_thr);
    eval 'sub bwi_rf_calc_rssi {
        my($_mac,$_hdr) = @_;
	    eval q({ ( ($_mac->{mac_rf}->{rf_calc_rssi})($_mac, $_hdr)); });
    }' unless defined(&bwi_rf_calc_rssi);
    eval 'sub bwi_rf_lo_update {
        my($_mac) = @_;
	    eval q({ ( ($_mac->{mac_rf}->{rf_lo_update})($_mac)); });
    }' unless defined(&bwi_rf_lo_update);
    eval 'sub RF_WRITE {
        my($mac, $ofs, $val) = @_;
	    eval q( &bwi_rf_write(($mac), ($ofs), ($val)));
    }' unless defined(&RF_WRITE);
    eval 'sub RF_READ {
        my($mac, $ofs) = @_;
	    eval q( &bwi_rf_read(($mac), ($ofs)));
    }' unless defined(&RF_READ);
    eval 'sub RF_SETBITS {
        my($mac, $ofs, $bits) = @_;
	    eval q( &RF_WRITE(($mac), ($ofs),  &RF_READ(($mac), ($ofs)) | ($bits)));
    }' unless defined(&RF_SETBITS);
    eval 'sub RF_CLRBITS {
        my($mac, $ofs, $bits) = @_;
	    eval q( &RF_WRITE(($mac), ($ofs),  &RF_READ(($mac), ($ofs)) & ~($bits)));
    }' unless defined(&RF_CLRBITS);
    eval 'sub RF_FILT_SETBITS {
        my($mac, $ofs, $filt, $bits) = @_;
	    eval q( &RF_WRITE(($mac), ($ofs), ( &RF_READ(($mac), ($ofs)) & ($filt)) | ($bits)));
    }' unless defined(&RF_FILT_SETBITS);
}
1;
