/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class PolicyQualifierInfo {
    private OID oid;
    private byte[] encoded;
    private DERValue qualifier;

    public final String getPolicyQualifierId() {
        return this.oid.toString();
    }

    public final byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public final byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return new byte[0];
        }
        return this.qualifier.getEncoded();
    }

    public final String toString() {
        return "PolicyQualifierInfo { policyQualifierId ::= " + this.oid + ", qualifier ::= " + this.qualifier + " }";
    }

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("null bytes");
        }
        this.encoded = (byte[])byArray.clone();
        DERReader dERReader = new DERReader(new ByteArrayInputStream(this.encoded));
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new ASN1ParsingException("malformed PolicyQualifierInfo");
        }
        DERValue dERValue2 = dERReader.read();
        if (!(dERValue2.getValue() instanceof OID)) {
            throw new ASN1ParsingException("value read not an OBJECT IDENTIFIER");
        }
        this.oid = (OID)dERValue2.getValue();
        if (dERValue2.getEncodedLength() < dERValue2.getLength()) {
            this.qualifier = dERReader.read();
        }
    }
}

