'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.8/tcllib-1.8/modules/comm/comm_wire.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005 Docs. Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "comm_wire" n 3 comm "Remote communication"
.BS
.SH "NAME"
comm_wire \- The comm wire protocol
.SH "SYNOPSIS"
package require \fBcomm_wire \fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBcomm\fR command provides an inter-interpreter remote
execution facility much like Tk's \fBsend(n)\fR, except that it uses
sockets rather than the X server for the communication path.  As a
result, \fBcomm\fR works with multiple interpreters, works on
Windows and Macintosh systems, and provides control over the remote
execution path.
.PP
This document contains a specification of the various versions of the
wire protocol used by comm internally for the communication between
its endpoints. It has no relevance to users of \fBcomm\fR, only to
developers who wish to modify the package, write a compatible facility
in a different language, or some other facility based on the same
protocol.
'\"
'\"     An example of some other facility could be a router layer which is
'\"     able to get messages for many different endpoints and then routes
'\"     them to the correct one. Why is this interesting ? Because it
'\"     allows mesh-routing, i.e. an application fires a command to some
'\"     other endpoint without having to worry if there is direct
'\"     connection to this endpoint or not. A secure tunnel then neatly
'\"     fits into this. Its endpoints are routing agents which take
'\"     arbitrariry commands, route them through the tunnel and then
'\"     dispatch them to the correct endpoint on the other side.
'\"
'\"     Note: A special case would be to have such a router facility built
'\"     into the core comm package, making each endpoint a router as
'\"     well. Like with the ability to listen to for non-local connection
'\"     this is something the user should be able to disable.
'\"
'\"
'\"     Motivation for documenting the protocol
'\"     ---------------------------------------
'\"
'\"     While the comm package allows the transport and execution of arbitrary
'\"     Tcl scripts a particular application can use the hooks to restrict the
'\"     scripts to single commands, and the legal commands to a specific set
'\"     as well.
'\"
'\"     If this is done (*) comm becomes more of a transport layer for a
'\"     regular RPC, and the data transported over the wire is less of a Tcl
'\"     script and more of a declaration of which remote procedure is wanted,
'\"     plus arguments.
'\"
'\"     At this point it begins to make sense to have implementations in other
'\"     scripting languages. Because then it beomes irrelevant in what
'\"     language the server is implemented. The comm protocol becomes a
'\"     portable RPC protocol, which can also be used for transport Tcl
'\"     scripts when both sides are Tcl and allowing this.
'\"
'\"     (*) And IMHO it should be done 90% of the time, just to get proper
'\"     security. Note that just using a safe interp is not quite enough, as
'\"     it still allows aribtrary scripts. The interp has to contains aliases
'\"     for the wanted commands, and only them for us to get a large security
'\"     wall.
'\"
.SH "Wire Protocol Version 3"
.SS "Basic Layer"
The basic encoding for \fIall\fR data is UTF-8. Because of this
binary data, including the NULL character, can be sent over the wire
as is, without the need for armoring it.
.SS "Basic Message Layer"
On top of the \fBBasic Layer\fR we have a
\fImessage oriented\fR exchange of data. Each \fImessage\fR is a
syntactically valid Tcl list terminated with an additional EOL. Note
that EOL characters can occur within the list as well. They can be
distinguished from the terminating EOL by the fact that the data from
the beginning up to their location is not a valid Tcl list.
.PP
EOL is signaled through the character \fB
\fR. This is following
the unix convention for line-endings.
.PP
As a list each message is composed of \fIwords\fR. Their meaning
depends on when the message was sent in the overall exchange. This is
described in the section sections.
.SS "Negotiation Messages - Initial Handshake"
The command protocol is defined like this:
.IP \(bu
The first message send by a client to a server, when opening the
connection, contains two words. The first word is a list as well, and
contains the versions of the wire protocol the client is willing to
accept, with the most prefered version first. The second word is the
TCP port the client is listening on for connections to itself.
.IP \(bu
The first message sent by the server to the client, in response to the
message above contains only one word. This word is a list, containing
the string \fBvers\fR as its first element, and the version of the
wire protocol the server has selected from the offered versions as the
second.
'\"
'\"         NOTE / DANGER
'\"
'\"         The terminating EOL for this first response will be the socket
'\"         specific default EOL (Windows/Internet convention: "\\r\\n").
'\"         However all future messages use Unix convention, i.e. "\\n",
'\"         for their EOLs, embedded or terminating.
'\"
'\"         Reason: The internal command commNewComm does the common
'\"                 processing for new connections, doing the
'\"
'\"                           fconfigure -translation lf
'\"
'\"                 However the handshake response containing the accepted
'\"                 version is sent before commNewComm is called (in
'\"                 commIncoming).
'\"
'\"
'\"         NOTE 2:
'\"
'\"         This inconsistency has been fixed locally already, but
'\"         not been committed yet.
'\"
.SS "Script/Command Messages"
All messages coming after the
\fBinitial handshake\fR
consist of three words. These are an instruction, a transaction id,
and the payload. The valid instructions are shown below. The
transaction ids are used by the client to match any incoming replies
to the command messages it sent. This means that a server has to copy
the transaction id from a command message to the reply it sends for
that message.
.TP
\fBsend\fR
.TP
\fBasync\fR
.TP
\fBcommand\fR
The payload is the Tcl script to execute on the server. It is actually
a list containing the script fragments. These fragement are
\fBconcat\fRenated together by the server to form the full script to
execute on the server side.
This emulates the Tcl "eval" semantics.
In most cases it is best to have only one word in the list, a list
containing the exact command.
.sp
Examples:
.sp
.nf

    (a)     {send 1 {{array get tcl_platform}}}
    (b)     {send 1 {array get tcl_platform}}
    (c)     {send 1 {array {get tcl_platform}}}

    are all valid representations of the same command. They are
    generated via

    (a')    send {array get tcl_platform}
    (b')    send array get tcl_platform
    (c')    send array {get tcl_platform}

    respectively

.fi
.sp
Note that (a), generated by (a'), is the usual form, if only single
commands are sent by the client.
For example constructed using \fBlist\fR, if the command contains
variable arguments. Like
.sp
.nf

    send [list array get $the_variable]

.fi
.sp
These three instructions all invoke the script on the server
side. Their difference is in the treatment of result values, and thus
determines if a reply is expected.
.RS
.TP
\fBsend\fR
A reply is expected. The sender is waiting for the result.
.TP
\fBasync\fR
No reply is expected, the sender has no interest in the result and is
not waiting for any.
.TP
\fBcommand\fR
A reply is expected, but the sender is not waiting for it. It has
arranged to get a process-internal notification when the result
arrives.
.RE
.TP
\fBreply\fR
Like the previous three command, however the tcl script in the payload
is highly restricted.
It has to be a syntactically valid Tcl \fBreturn\fR command. This
contains result code, value, error code, and error info.
.sp
Examples:
.sp
.nf

    {reply 1 {return -code 0 {}}}
    {reply 1 {return -code 0 {osVersion 2.4.21-99-default byteOrder littleEndian machine i686 platform unix os Linux user andreask wordSize 4}}}

.fi
'\"
'\" 	 Socket Miscellanea
'\" 	 ------------------
'\"
'\" 	 It is possible to have two sockets between a client and a
'\" 	 server. This happens if both sides connected to each other at
'\" 	 the same time.
'\"
'\"
'\" 	 Current protocol versions
'\" 	 -------------------------
'\"
'\" 	 V2
'\"
'\"
'\" 	 V3      This is prefered version and uses UTF 8 encoding.
'\"
'\" 	         This is actually the only version which will work IIU
'\" 		 the code right. Because the server part of comm will
'\" 		 send the version reply if and only if version 3 was
'\" 		 negotiated.
'\"
'\" 		 IOW if v2 is used the client will not see a version
'\" 	         reply during the negotiation handshake.
'\"
.SH "SEE ALSO"
comm
.SH "KEYWORDS"
communication, ipc, message, remote communication, rpc, socket
.SH "COPYRIGHT"
.nf
Copyright (c) 2005 Docs. Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi