#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions1DmkIII',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 145 => 'absPeakAudioFilePath' },
	'accessorytype' => { 111 => 0x53 },
	'actionadvised' => { 49 => 0x2a },
	'activearea' => { 43 => 0xc68d },
	'addaspectratioinfo' => { 21 => 0x80e },
	'addoriginaldecisiondata' => { 21 => 0x80f, 22 => 0x11, 23 => 0x13, 26 => 0x14 },
	'address' => { 63 => 'Address' },
	'adjustmentmode' => { 129 => [0x15,0x22] },
	'advancedraw' => { 97 => 0x76a43203 },
	'advisory' => { 143 => 'Advisory' },
	'ae_iso' => { 113 => 0x2 },
	'aeaperture' => { 113 => 0x1 },
	'aebautocancel' => { 21 => 0x104 },
	'aebbracketvalue' => { 18 => 0x11 },
	'aebsequence' => { 19 => 0x9, 20 => 0x9, 21 => 0x105, 22 => 0x8, 23 => 0x9, 26 => 0x9, 27 => 0x7 },
	'aebshotcount' => { 21 => 0x106 },
	'aebxv' => { 113 => 0x4 },
	'aedump' => { 118 => 0x209 },
	'aeexposuretime' => { 113 => 0x0 },
	'aeextra' => { 113 => 0x7 },
	'aeflashtv' => { 113 => 0x5 },
	'aelock' => { 103 => 0x201 },
	'aeprogrammode' => { 113 => 0x6 },
	'aesetting' => { 2 => 0x21 },
	'aexv' => { 113 => 0x3 },
	'afareamode' => { 80 => 0x0 },
	'afareas' => { 103 => 0x304 },
	'afassist' => { 19 => 0x5, 27 => 0x5 },
	'afassistbeam' => { 21 => 0x50e, 22 => 0x4, 23 => 0x5, 24 => 0x4, 25 => 0x4, 26 => 0x5 },
	'afexpansionwithselectedpoint' => { 21 => 0x508 },
	'afmicroadjustment' => { 21 => 0x507 },
	'afmode' => { 111 => 0xf, 129 => 0x5 },
	'afonaelockbuttonswitch' => { 21 => 0x702 },
	'afpoint' => { 2 => 0x13, 39 => 0x18, 80 => 0x1 },
	'afpointactivationarea' => { 20 => 0x11, 26 => 0x11 },
	'afpointautoselection' => { 21 => 0x50b },
	'afpointbrightness' => { 21 => 0x50d },
	'afpointdisplayduringfocus' => { 21 => 0x50c },
	'afpointillumination' => { 20 => 0xa },
	'afpointregistration' => { 19 => 0x7 },
	'afpoints' => { 74 => 0x10 },
	'afpointselected' => { 118 => 0xe },
	'afpointselection' => { 20 => 0xb },
	'afpointselectionmethod' => { 22 => 0xc, 23 => 0xd, 26 => 0xd },
	'afpointspotmetering' => { 20 => 0xd },
	'afpointsused' => { 15 => [0x16,0x1a], 80 => 0x2, 118 => 0x3c },
	'afpointsused2' => { 18 => 0xe },
	'afpointsused5d' => { 0 => 0x38 },
	'afresponse' => { 86 => 0xad },
	'afsearch' => { 103 => 0x303 },
	'aiservoimagepriority' => { 21 => 0x503 },
	'aiservotrackingmethod' => { 21 => 0x504 },
	'aiservotrackingsensitivity' => { 20 => 0x14, 21 => 0x502 },
	'album' => { 145 => 'album' },
	'alreadyapplied' => { 135 => 'AlreadyApplied' },
	'alttapename' => { 145 => 'altTapeName' },
	'alttimecodetimeformat' => { 145 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 145 => 'altTimecodeTimeValue' },
	'antialiasstrength' => { 43 => 0xc632 },
	'aperturerange' => { 21 => 0x10d },
	'aperturevalue' => { 43 => 0x9202, 107 => 0x1002, 138 => 'ApertureValue' },
	'applicationrecordversion' => { 49 => 0x0 },
	'applyshootingmeteringmode' => { 21 => 0x10e },
	'armidentifier' => { 50 => 0x78 },
	'armversion' => { 50 => 0x7a },
	'artist' => { 43 => 0x13b, 110 => 'Artist', 142 => 'Artist', 145 => 'artist' },
	'asshotwhitexy' => { 43 => 0xc629 },
	'assistbuttonfunction' => { 19 => 0xd },
	'audio' => { 111 => 0x20 },
	'audiochanneltype' => { 145 => 'audioChannelType' },
	'audiocompression' => { 57 => 'Compression' },
	'audiocompressor' => { 145 => 'audioCompressor' },
	'audioduration' => { 49 => 0x99 },
	'audiomoddate' => { 145 => 'audioModDate' },
	'audiooutcue' => { 49 => 0x9a },
	'audiosamplerate' => { 145 => 'audioSampleRate' },
	'audiosampletype' => { 145 => 'audioSampleType' },
	'audiosamplingrate' => { 49 => 0x97 },
	'audiosamplingresolution' => { 49 => 0x98 },
	'audiotype' => { 49 => 0x96 },
	'author' => { 59 => 'Author', 110 => 'Author', 125 => 'Author', 140 => 'Author' },
	'authorsposition' => { 141 => 'AuthorsPosition' },
	'autoafpoint' => { 118 => 0xf },
	'autobracket' => { 129 => 0x19 },
	'autobracketing' => { 47 => 0x1100, 118 => 0x18 },
	'autobracketrelease' => { 86 => 0x8a },
	'autobrightness' => { 135 => 'AutoBrightness' },
	'autocontrast' => { 135 => 'AutoContrast' },
	'autoexposure' => { 135 => 'AutoExposure' },
	'autoexposurebracketing' => { 18 => 0x10 },
	'autofocus' => { 105 => 0x209 },
	'autoiso' => { 18 => 0x1, 40 => 0x3008 },
	'autorotate' => { 18 => 0x1b },
	'autoshadows' => { 135 => 'AutoShadows' },
	'auxiliarylens' => { 86 => 0x82 },
	'avsettingwithoutlens' => { 21 => 0x707 },
	'avvalue' => { 30 => 0x2 },
	'azimuth' => { 67 => 'Azimuth' },
	'babyage' => { 111 => 0x33 },
	'baseiso' => { 18 => 0x2, 34 => 0x101c },
	'baselineexposure' => { 43 => 0xc62a },
	'baselinenoise' => { 43 => 0xc62b },
	'baselinesharpness' => { 43 => 0xc62c },
	'baseurl' => { 143 => 'BaseURL' },
	'batteryadbodyload' => { 114 => 0x3 },
	'batteryadbodynoload' => { 114 => 0x2 },
	'batteryadgripload' => { 114 => 0x5 },
	'batteryadgripnoload' => { 114 => 0x4 },
	'batterybodygripstates' => { 114 => 0x1 },
	'batterytype' => { 114 => 0x0 },
	'bayergreensplit' => { 43 => 0xc62d },
	'bayerpattern' => { 77 => 0x17 },
	'beatspliceparamsriseindecibel' => { 145 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 145 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 145 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 43 => 0xc65c },
	'bestshotmode' => { 40 => 0x3007 },
	'bitdepth' => { 64 => 'BitDepth', 77 => 0x11, 90 => 0x41 },
	'bitspercomponent' => { 51 => 0x87 },
	'bitspersample' => { 43 => 0x102, 142 => 'BitsPerSample' },
	'blacklevel' => { 107 => 0x1012 },
	'blackpoint' => { 118 => 0x200 },
	'bluebalance' => { 107 => 0x1018, 118 => 0x1b },
	'bluecurvelimits' => { 38 => 0x1fe },
	'bluecurvepoints' => { 38 => 0x1d4 },
	'bluehue' => { 135 => 'BlueHue' },
	'bluesaturation' => { 135 => 'BlueSaturation' },
	'blurwarning' => { 47 => 0x1300 },
	'bodyfirmwareversion' => { 104 => 0x104 },
	'bracketmode' => { 9 => 0x3 },
	'bracketsequence' => { 40 => 0x301d },
	'bracketshotnumber' => { 9 => 0x5 },
	'bracketstep' => { 72 => 0xe },
	'bracketvalue' => { 9 => 0x4 },
	'brightness' => { 43 => 0xfe53, 58 => 'Brightness', 72 => 0x2c, 135 => 'Brightness' },
	'brightnessadj' => { 38 => 0x114, 92 => 0x0 },
	'brightnessvalue' => { 43 => 0x9203, 107 => 0x1003, 138 => 'BrightnessValue' },
	'bulbduration' => { 18 => 0x18 },
	'burstmode' => { 53 => 0xa, 111 => 0x2a },
	'burstmode2' => { 53 => 0x18 },
	'buttonfunctioncontroloff' => { 21 => 0x70a },
	'bwfilter' => { 72 => 0x2a, 78 => 0x39 },
	'bwmode' => { 107 => 0x203 },
	'by-line' => { 49 => 0x50 },
	'by-linetitle' => { 49 => 0x55 },
	'calibrationilluminant1' => { 43 => 0xc65a },
	'calibrationilluminant2' => { 43 => 0xc65b },
	'cameraid' => { 107 => 0x209, 128 => 0x209 },
	'cameraiso' => { 2 => 0x10 },
	'cameraparameters' => { 107 => 0x2050 },
	'cameraprofile' => { 135 => 'CameraProfile' },
	'cameraserialnumber' => { 43 => 0xc62f, 132 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 103 => 0x0 },
	'cameratemperature' => { 118 => 0x47 },
	'cameratype' => { 18 => 0x1a, 107 => 0x207 },
	'cameratype2' => { 104 => 0x100 },
	'canonexposuremode' => { 2 => 0x14 },
	'canonfiledescription' => { 34 => 0x805 },
	'canonfilelength' => { 12 => 0xe },
	'canonfirmwareversion' => { 12 => 0x7, 34 => 0x80b },
	'canonflashinfo' => { 34 => 0x1028 },
	'canonflashmode' => { 2 => 0x4 },
	'canonimageheight' => { 15 => 0x3 },
	'canonimageheightasshot' => { 15 => 0x5 },
	'canonimagesize' => { 2 => 0xa },
	'canonimagetype' => { 12 => 0x6, 34 => 0x815 },
	'canonimagewidth' => { 15 => 0x2 },
	'canonimagewidthasshot' => { 15 => 0x4 },
	'canonmodelid' => { 12 => 0x10, 34 => 0x1834 },
	'caption-abstract' => { 49 => 0x78 },
	'captionwriter' => { 141 => 'CaptionWriter' },
	'casioimagesize' => { 40 => 0x9 },
	'category' => { 49 => 0xf, 141 => 'Category' },
	'ccdisosensitivity' => { 40 => 0x3014 },
	'ccdscanmode' => { 107 => 0x1039 },
	'ccdsensitivity' => { 39 => 0x14, 91 => 0x6 },
	'celllength' => { 43 => 0x109 },
	'cellwidth' => { 43 => 0x108 },
	'certificate' => { 148 => 'Certificate' },
	'cfapattern' => { 43 => 0xa302 },
	'cfapatterncolumns' => { 138 => 'CFAPatternColumns' },
	'cfapatternrows' => { 138 => 'CFAPatternRows' },
	'cfapatternvalues' => { 138 => 'CFAPatternValues' },
	'channels' => { 57 => 'Channels' },
	'checkmark' => { 38 => 0x26a },
	'chromablurradius' => { 43 => 0xc631 },
	'chromaticaberrationb' => { 135 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 135 => 'ChromaticAberrationR' },
	'city' => { 49 => 0x5a, 63 => 'City', 141 => 'City' },
	'classifystate' => { 49 => 0xe1 },
	'codec' => { 71 => 'Codec' },
	'codedcharacterset' => { 50 => 0x5a },
	'coloraberrationcontrol' => { 97 => 0xc89224b },
	'coloradjustment' => { 129 => 0x14 },
	'coloradjustmentmode' => { 128 => 0x210 },
	'colorantsa' => { 149 => 'ColorantsA' },
	'colorantsb' => { 149 => 'ColorantsB' },
	'colorantsblack' => { 149 => 'ColorantsBlack' },
	'colorantsblue' => { 149 => 'ColorantsBlue' },
	'colorantscyan' => { 149 => 'ColorantsCyan' },
	'colorantsgreen' => { 149 => 'ColorantsGreen' },
	'colorantsl' => { 149 => 'ColorantsL' },
	'colorantsmagenta' => { 149 => 'ColorantsMagenta' },
	'colorantsmode' => { 149 => 'ColorantsMode' },
	'colorantsred' => { 149 => 'ColorantsRed' },
	'colorantsswatchname' => { 149 => 'ColorantsSwatchName' },
	'colorantstype' => { 149 => 'ColorantsType' },
	'colorantsyellow' => { 149 => 'ColorantsYellow' },
	'colorbalance' => { 58 => 'ColorBalance' },
	'colorbalance1' => { 86 => 0xc },
	'colorbalanceadj' => { 97 => 0x76a43202 },
	'colorbalanceblue' => { 72 => 0x1e },
	'colorbalancegreen' => { 72 => 0x1d },
	'colorbalancered' => { 72 => 0x1c },
	'colorbooster' => { 97 => 0x5f0e7d23 },
	'colorboostlevel' => { 93 => 0x1 },
	'colorboosttype' => { 93 => 0x0 },
	'colorclass' => { 120 => 0xde },
	'colorcontrol' => { 107 => 0x102b },
	'coloreffect' => { 111 => 0x28 },
	'colorfilter' => { 72 => 0x29, 78 => 0x38 },
	'colorgain' => { 90 => 0x51 },
	'colorhue' => { 7 => 0x2, 86 => 0x8d },
	'colormatrix' => { 8 => 0xa, 106 => 0x200, 107 => 0x1011 },
	'colormode' => { 40 => 0x3015, 47 => 0x1210, 53 => 0x66, 72 => 0x28, 75 => 0x16, 76 => 0x101, 78 => 0x7, 86 => 0x3, 91 => 0x4, 107 => 0x101, 111 => 0x32, 130 => 0xb029, 141 => 'ColorMode' },
	'colormoirereduction' => { 98 => 0x5 },
	'colornoisereduction' => { 135 => 'ColorNoiseReduction' },
	'colorplanes' => { 46 => 0x2 },
	'colorprofile' => { 72 => 0x33 },
	'colorrepresentation' => { 51 => 0x3c },
	'colorsequence' => { 51 => 0x41 },
	'colorspace' => { 7 => 0x3, 12 => 0xb4, 34 => 0x10b4, 43 => 0xa001, 64 => 'ColorSpace', 74 => 0x25, 86 => 0x1e, 103 => 0x507, 118 => 0x37, 129 => 0xb, 138 => 'ColorSpace' },
	'colortempasshot' => { 4 => 0x1d, 5 => 0x1c, 6 => 0x43 },
	'colortempauto' => { 4 => 0x22, 5 => 0x26, 6 => 0x48 },
	'colortempcloudy' => { 4 => 0x31, 5 => 0x35, 6 => 0x5c },
	'colortempcustom' => { 6 => 0x84 },
	'colortempcustom1' => { 4 => 0x45 },
	'colortempcustom2' => { 4 => 0x4a },
	'colortempdaylight' => { 4 => 0x27, 5 => 0x2b, 6 => 0x52 },
	'colortemperature' => { 8 => 0x9, 12 => 0xae, 17 => 0x9, 34 => 0x10ae, 58 => 'ColorTemperature', 73 => [0x6e,0x49], 74 => 0x3f, 75 => 0x5e, 76 => 0x10b, 78 => 0x3c },
	'colortempflash' => { 4 => 0x40, 5 => 0x49, 6 => 0x70 },
	'colortempfluorescent' => { 4 => 0x3b, 5 => 0x3f, 6 => 0x66 },
	'colortempkelvin' => { 5 => 0x44, 6 => 0x6b },
	'colortempmeasured' => { 6 => 0x4d },
	'colortemppc1' => { 5 => 0x94, 6 => 0x75 },
	'colortemppc2' => { 5 => 0x99, 6 => 0x7a },
	'colortemppc3' => { 5 => 0x9e, 6 => 0x7f },
	'colortempshade' => { 4 => 0x2c, 5 => 0x30, 6 => 0x57 },
	'colortemptungsten' => { 4 => 0x36, 5 => 0x3a, 6 => 0x61 },
	'colortempunknown' => { 5 => 0x21 },
	'colortempunknown10' => { 5 => 0x76 },
	'colortempunknown11' => { 5 => 0x7b },
	'colortempunknown12' => { 5 => 0x80 },
	'colortempunknown13' => { 5 => 0x85 },
	'colortempunknown14' => { 5 => 0x8a },
	'colortempunknown15' => { 5 => 0x8f },
	'colortempunknown16' => { 5 => 0xa3 },
	'colortempunknown2' => { 5 => 0x4e },
	'colortempunknown3' => { 5 => 0x53 },
	'colortempunknown4' => { 5 => 0x58 },
	'colortempunknown5' => { 5 => 0x5d },
	'colortempunknown6' => { 5 => 0x62 },
	'colortempunknown7' => { 5 => 0x67 },
	'colortempunknown8' => { 5 => 0x6c },
	'colortempunknown9' => { 5 => 0x71 },
	'colortone' => { 2 => 0x2a },
	'colortoneadj' => { 38 => 0x11e },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 44 => 'Comment', 59 => 'Comment', 110 => 'Comment' },
	'componentsconfiguration' => { 43 => 0x9101, 64 => 'Components', 138 => 'ComponentsConfiguration' },
	'componentversion' => { 34 => 0x80c },
	'composer' => { 145 => 'composer' },
	'compressedbitsperpixel' => { 43 => 0x9102, 138 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 76 => 0x40, 107 => 0x40 },
	'compression' => { 43 => 0x103, 142 => 'Compression' },
	'compressionfactor' => { 103 => 0x50d },
	'compressionratio' => { 64 => 'Compression', 107 => 0x1034 },
	'constrainedcropheight' => { 38 => 0x266, 120 => 0xd6 },
	'constrainedcropwidth' => { 38 => 0x262, 120 => 0xd5 },
	'contact' => { 49 => 0x76 },
	'contentlocationcode' => { 49 => 0x1a },
	'contentlocationname' => { 49 => 0x1b },
	'continuousdrive' => { 2 => 0x5 },
	'continuousshootingspeed' => { 21 => 0x610 },
	'continuousshotlimit' => { 21 => 0x611 },
	'contrast' => { 2 => 0xd, 39 => 0xc, 40 => [0x3012,0x20], 43 => [0xa408,0xfe54], 47 => 0x1004, 58 => 'Contrast', 72 => 0x20, 73 => 0x31, 74 => 0x27, 75 => 0x19, 78 => 0x2, 107 => 0x1029, 111 => 0x2c, 118 => 0x20, 129 => 0xd, 135 => 'Contrast', 138 => 'Contrast' },
	'contrastadj' => { 38 => 0x115 },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 103 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributedmediaduration' => { 145 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 145 => 'contributedMediaManaged' },
	'contributedmediapath' => { 145 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 145 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 145 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 145 => 'contributedMediaWebStatement' },
	'contributor' => { 136 => 'contributor' },
	'contributors' => { 59 => 'Contributors' },
	'conversionlens' => { 111 => 0x35 },
	'converter' => { 43 => 0xfe4d, 91 => 0xb },
	'converttograyscale' => { 135 => 'ConvertToGrayscale' },
	'copyright' => { 43 => 0x8298, 59 => 'Copyright', 110 => 'Copyright', 125 => 'Copyright', 142 => 'Copyright', 145 => 'copyright' },
	'copyrightflag' => { 123 => 0x40a },
	'copyrightnotice' => { 49 => 0x74 },
	'coringfilter' => { 107 => 0x102d },
	'country' => { 63 => 'Country', 141 => 'Country' },
	'country-primarylocationcode' => { 49 => 0x64 },
	'country-primarylocationname' => { 49 => 0x65 },
	'countrycode' => { 121 => 'CountryCode', 139 => 'CountryCode' },
	'coverage' => { 136 => 'coverage' },
	'crc32' => { 137 => 'crc32' },
	'createdate' => { 43 => 0x9004, 59 => 'CreateDate', 125 => 'CreationDate', 143 => 'CreateDate' },
	'creationdate' => { 140 => 'CreationDate' },
	'creationtime' => { 110 => 'Creation Time' },
	'creator' => { 125 => 'Creator', 136 => 'creator', 140 => 'Creator' },
	'creatorcontactinfociadrcity' => { 139 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 139 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 139 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 139 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 139 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 139 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 139 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 139 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 143 => 'CreatorTool' },
	'credit' => { 49 => 0x6e, 141 => 'Credit' },
	'creditlinereq' => { 147 => 'CreditLineReq' },
	'cropactive' => { 38 => 0x244 },
	'cropangle' => { 135 => 'CropAngle' },
	'cropaspectratio' => { 38 => 0x260 },
	'cropbottom' => { 46 => 0x9, 94 => 0x36, 120 => 0xdc, 135 => 'CropBottom' },
	'cropheight' => { 38 => 0x24c, 135 => 'CropHeight' },
	'crophispeed' => { 86 => 0x1b },
	'cropleft' => { 38 => 0x246, 46 => 0x6, 94 => 0x1e, 120 => 0xd9, 135 => 'CropLeft' },
	'cropoutputscale' => { 94 => 0xbe },
	'cropright' => { 46 => 0x8, 94 => 0x2e, 120 => 0xdb, 135 => 'CropRight' },
	'croprotation' => { 46 => 0xb },
	'croptop' => { 38 => 0x248, 46 => 0x7, 94 => 0x26, 120 => 0xda, 135 => 'CropTop' },
	'cropunits' => { 135 => 'CropUnits' },
	'cropwidth' => { 38 => 0x24a, 135 => 'CropWidth' },
	'curves' => { 97 => 0x76a43201 },
	'customrendered' => { 43 => 0xa401, 138 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x503 },
	'd-lightinghq' => { 97 => 0x2175eb78 },
	'd-lightinghqselected' => { 97 => 0x6a6e36b6 },
	'd-lightinghs' => { 97 => 0xce5554aa },
	'd-lightinghsadjustment' => { 96 => 0x0 },
	'd-lightinghscolorboost' => { 95 => 0x2, 96 => 0x1 },
	'd-lightinghshighlight' => { 95 => 0x1 },
	'd-lightinghsshadow' => { 95 => 0x0 },
	'datacompressionmethod' => { 51 => 0x6e },
	'dataimprint' => { 72 => 0x34 },
	'date' => { 118 => 0x6, 136 => 'date' },
	'dateacquired' => { 132 => 'DateAcquired' },
	'datecreated' => { 49 => 0x37, 141 => 'DateCreated' },
	'datesent' => { 50 => 0x46 },
	'datetime' => { 142 => 'DateTime' },
	'datetimedigitized' => { 138 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 37 => 0x0, 43 => 0x9003, 59 => 'OriginalDate', 138 => 'DateTimeOriginal' },
	'datetimestamp' => { 53 => 0x64 },
	'declination' => { 67 => 'Declination' },
	'decposition' => { 72 => 0x32 },
	'defaultcroporigin' => { 43 => 0xc61f },
	'defaultcropsize' => { 43 => 0xc620 },
	'defaultscale' => { 43 => 0xc61e },
	'deletedimagecount' => { 86 => 0xa6 },
	'derivedfromdocumentid' => { 146 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 146 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 146 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 146 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 146 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 146 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 146 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 146 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 146 => 'DerivedFromVersionID' },
	'description' => { 110 => 'Description', 136 => 'description' },
	'destination' => { 50 => 0x5 },
	'destinationcity' => { 118 => 0x24 },
	'destinationcitycode' => { 118 => 0x1001 },
	'destinationdst' => { 118 => 0x26 },
	'developmentdynamicrange' => { 47 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 138 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 138 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 138 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 21 => 0x706 },
	'digitalcreationdate' => { 49 => 0x3e },
	'digitalcreationtime' => { 49 => 0x3f },
	'digitalgain' => { 17 => 0xb },
	'digitalgem' => { 84 => 0x0 },
	'digitalice' => { 90 => 0x100 },
	'digitalroc' => { 89 => 0x0 },
	'digitalzoom' => { 2 => 0xc, 39 => 0xa, 53 => 0x68, 58 => 'DigitalZoom', 72 => 0xc, 86 => 0x86, 91 => 0xa, 107 => 0x204, 118 => 0x1e, 128 => 0x204 },
	'digitalzoomon' => { 128 => 0x21b },
	'digitalzoomratio' => { 43 => 0xa404, 138 => 'DigitalZoomRatio' },
	'directory' => { 44 => 'Directory' },
	'disclaimer' => { 110 => 'Disclaimer' },
	'displayaperture' => { 2 => 0x23 },
	'displayedunitsx' => { 124 => 0x2 },
	'displayedunitsy' => { 124 => 0x6 },
	'distance1' => { 53 => 0x28 },
	'distance2' => { 53 => 0x2c },
	'distance3' => { 53 => 0x30 },
	'distance4' => { 53 => 0x34 },
	'distortioncorrection' => { 103 => 0x50b },
	'distortioncorrection2' => { 106 => 0x1011 },
	'dngbackwardversion' => { 43 => 0xc613 },
	'dnglensinfo' => { 43 => 0xc630 },
	'dngversion' => { 43 => 0xc612 },
	'document' => { 110 => 'Document' },
	'documenthistory' => { 49 => 0xe7 },
	'documentid' => { 146 => 'DocumentID' },
	'documentname' => { 43 => 0x10d },
	'documentnotes' => { 49 => 0xe6 },
	'dotrange' => { 43 => 0x150 },
	'drivemode' => { 72 => 0x6, 75 => 0x1e, 118 => 0x34, 129 => 0x3 },
	'duration' => { 57 => 'Duration', 71 => 'Duration', 145 => 'duration' },
	'dynamicrange' => { 47 => 0x1400 },
	'dynamicrangemax' => { 38 => 0x7c },
	'dynamicrangemin' => { 38 => 0x7a },
	'dynamicrangesetting' => { 47 => 0x1402 },
	'easymode' => { 2 => 0xb },
	'edgenoisereduction' => { 98 => 0x4 },
	'editorialupdate' => { 49 => 0x8 },
	'editstatus' => { 49 => 0x7, 121 => 'EditStatus' },
	'elevation' => { 67 => 'Elevation' },
	'email' => { 59 => 'EMail' },
	'engineer' => { 145 => 'engineer' },
	'enhancedarktones' => { 92 => 0x8 },
	'enhancement' => { 39 => 0x16, 40 => 0x3016 },
	'envelopenumber' => { 50 => 0x28 },
	'envelopepriority' => { 50 => 0x3c },
	'enveloperecordversion' => { 50 => 0x0 },
	'epsonimageheight' => { 107 => 0x20c },
	'epsonimagewidth' => { 107 => 0x20b },
	'epsonsoftware' => { 107 => 0x20d },
	'equipmentversion' => { 104 => 0x0 },
	'ettlii' => { 21 => 0x304, 22 => 0xd, 23 => 0xe, 24 => 0x7, 25 => 0x7, 26 => 0xe },
	'excursiontolerance' => { 51 => 0x82 },
	'exifcamerainfo' => { 49 => 0xe8 },
	'exifimagelength' => { 43 => 0xa003, 138 => 'PixelYDimension' },
	'exifimagewidth' => { 43 => 0xa002, 138 => 'PixelXDimension' },
	'exifversion' => { 43 => 0x9000, 138 => 'ExifVersion' },
	'expirationdate' => { 49 => 0x25 },
	'expirationtime' => { 49 => 0x26 },
	'exposure' => { 43 => 0xfe51, 135 => 'Exposure' },
	'exposurebracketvalue' => { 86 => 0x19 },
	'exposurecompensation' => { 18 => 0x6, 30 => 0x0, 43 => 0x9204, 53 => 0x24, 58 => 'ExposureComp', 72 => 0xd, 73 => 0x53, 74 => 0x1e, 75 => 0x1, 107 => 0x1006, 118 => 0x16, 129 => [0xc,0x35], 138 => 'ExposureBiasValue' },
	'exposuredifference' => { 86 => 0xe },
	'exposureindex' => { 43 => 0xa215, 138 => 'ExposureIndex' },
	'exposurelevelincrements' => { 19 => 0x6, 20 => 0x6, 21 => 0x101, 22 => 0x5, 23 => 0x6, 24 => 0x5, 25 => 0x5, 26 => 0x6, 27 => 0x4 },
	'exposuremode' => { 43 => 0xa402, 58 => 'ExposureMode', 72 => 0x1, 73 => 0xa, 74 => 0x0, 75 => 0x0, 103 => 0x200, 129 => 0x8, 138 => 'ExposureMode' },
	'exposuremodeinmanual' => { 21 => 0x10b },
	'exposureprogram' => { 43 => 0x8822, 138 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 1 => 0x4, 18 => 0x16, 43 => 0x829a, 53 => 0x20, 55 => 0x38, 58 => 'ExposureTime', 72 => 0x9, 73 => 0x35, 74 => 0x48, 118 => 0x12, 129 => 0x32, 138 => 'ExposureTime' },
	'exposurewarning' => { 47 => 0x1302 },
	'extender' => { 104 => 0x301 },
	'extenderfirmwareversion' => { 104 => 0x304 },
	'extendermagnification' => { 60 => 'Magnification' },
	'extendermake' => { 60 => 'Make' },
	'extendermodel' => { 60 => 'Model', 104 => 0x303 },
	'extenderserialnumber' => { 60 => 'SerialNumber', 104 => 0x302 },
	'externalflash' => { 105 => 0x1201 },
	'externalflashbounce' => { 107 => 0x1026 },
	'externalflashmode' => { 107 => 0x1028, 116 => 0x2 },
	'externalflashzoom' => { 107 => 0x1027 },
	'ffid' => { 137 => 'ffid' },
	'filedatarate' => { 145 => 'fileDataRate' },
	'fileformat' => { 32 => 0x0, 50 => 0x14 },
	'filemodifydate' => { 44 => 'FileModifyDate' },
	'filename' => { 44 => 'FileName' },
	'filenumber' => { 9 => 0x1, 12 => 0x8, 34 => 0x1817 },
	'filenumbermemory' => { 72 => 0x1a },
	'filesource' => { 43 => 0xa300, 47 => 0x8000, 138 => 'FileSource' },
	'fileversion' => { 50 => 0x16 },
	'fillflashautoreduction' => { 19 => 0xe, 20 => 0xe, 27 => 0xa },
	'filllight' => { 135 => 'FillLight' },
	'fillorder' => { 43 => 0x10a },
	'filmmode' => { 47 => 0x1401, 111 => 0x42 },
	'filmtype' => { 90 => 0x2 },
	'filter' => { 39 => 0x17, 40 => 0x3017 },
	'filtereffect' => { 9 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 20 => 0x1 },
	'firmware' => { 129 => [0x17,0x3b], 133 => 'Firmware' },
	'firmwaredate' => { 40 => 0x2001 },
	'firmwareid' => { 77 => 0x0 },
	'firmwarerevision' => { 0 => 0xa4, 12 => 0x1e },
	'firmwareversion' => { 58 => 'FirmwareVersion' },
	'fixtureidentifier' => { 49 => 0x16 },
	'flash' => { 43 => 0x9209, 73 => 0x1f, 74 => 0x15 },
	'flashactivity' => { 2 => 0x1c },
	'flashadump' => { 118 => 0x20a },
	'flashbdump' => { 118 => 0x20b },
	'flashbias' => { 111 => 0x24 },
	'flashbits' => { 2 => 0x1d },
	'flashchargelevel' => { 107 => 0x1010 },
	'flashcompensation' => { 133 => 'FlashCompensation' },
	'flashdevice' => { 107 => 0x1005 },
	'flashdistance' => { 40 => 0x2034 },
	'flashenergy' => { 43 => 0xa20b, 138 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 86 => 0x18 },
	'flashexposurecomp' => { 18 => 0xf, 61 => 'ExposureComp', 72 => 0x23, 76 => 0x104, 86 => 0x12, 107 => 0x1023, 118 => 0x4d, 129 => 0x3a },
	'flashexposurecompensation' => { 103 => 0x401 },
	'flashfired' => { 53 => 0x5d, 61 => 'Fired', 72 => 0x14, 138 => 'FlashFired' },
	'flashfiring' => { 21 => 0x306, 22 => 0x6, 23 => 0x7, 26 => 0x7 },
	'flashfirmwareversion' => { 104 => 0x1002 },
	'flashfunction' => { 138 => 'FlashFunction' },
	'flashguidenumber' => { 18 => 0xd, 31 => 0x0, 61 => 'GuideNumber' },
	'flashintensity' => { 39 => [0x19,0x5] },
	'flashmake' => { 61 => 'Make' },
	'flashmanufacturer' => { 132 => 'FlashManufacturer' },
	'flashmetering' => { 72 => 0x3f },
	'flashmode' => { 39 => 0x4, 53 => 0x5c, 61 => 'Mode', 72 => 0x2, 86 => 0x87, 103 => 0x400, 107 => 0x1004, 118 => 0xc, 126 => 0x20, 128 => 0x225, 138 => 'FlashMode' },
	'flashmodecode' => { 116 => 0x1 },
	'flashmodel' => { 61 => 'Model', 104 => 0x1001, 132 => 'FlashModel' },
	'flashpixversion' => { 43 => 0xa000, 138 => 'FlashpixVersion' },
	'flashredeyemode' => { 138 => 'FlashRedEyeMode' },
	'flashreturn' => { 138 => 'FlashReturn' },
	'flashserialnumber' => { 61 => 'SerialNumber', 104 => 0x1003 },
	'flashsetting' => { 86 => 0x8 },
	'flashstatus' => { 116 => 0x0 },
	'flashstrength' => { 47 => 0x1011 },
	'flashsyncspeedav' => { 19 => 0x3, 21 => 0x10f, 22 => 0x2, 23 => 0x3, 24 => 0x2, 25 => 0x2, 26 => 0x3, 27 => 0x6 },
	'flashthreshold' => { 31 => 0x1 },
	'flashtype' => { 61 => 'Type', 86 => 0x9, 104 => 0x1000 },
	'flickerreduce' => { 128 => 0x218 },
	'fliphorizontal' => { 97 => 0x76a43206 },
	'fnumber' => { 18 => 0x15, 43 => 0x829d, 53 => 0x1e, 55 => 0x3c, 65 => 'FNumber', 72 => 0xa, 73 => 0x36, 74 => 0x47, 118 => 0x13, 129 => 0x31, 138 => 'FNumber' },
	'focallength' => { 0 => 0xa, 11 => 0x1, 40 => 0x1d, 43 => 0x920a, 65 => 'FocalLength', 72 => 0x12, 118 => 0x1d, 138 => 'FocalLength' },
	'focallengthin35mmformat' => { 43 => 0xa405, 138 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 104 => 0x103, 107 => 0x205 },
	'focalplaneresolutionunit' => { 43 => 0xa210, 138 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 43 => 0xa20e, 138 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 11 => 0x2 },
	'focalplaneyresolution' => { 43 => 0xa20f, 138 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 11 => 0x3 },
	'focaltype' => { 0 => 0x2d, 11 => 0x0 },
	'focalunits' => { 2 => 0x19 },
	'focus' => { 91 => 0x8 },
	'focusarea' => { 72 => 0x31 },
	'focuscontinuous' => { 2 => 0x20 },
	'focusdistance' => { 65 => 'FocusDistance', 72 => 0x13, 105 => 0x305 },
	'focusdistancelower' => { 18 => 0x14 },
	'focusdistanceupper' => { 18 => 0x13 },
	'focusinfoversion' => { 105 => 0x0 },
	'focusingscreen' => { 20 => 0x0, 21 => 0x80b, 26 => 0x0 },
	'focusmode' => { 2 => 0x7, 39 => 0x3, 40 => [0x3003,0xd], 47 => 0x1021, 53 => 0x38, 58 => 'FocusMode', 72 => 0x30, 74 => 0xe, 86 => 0x7, 103 => 0x301, 107 => 0x100b, 111 => 0x7, 118 => 0xd },
	'focuspixel' => { 47 => 0x1023 },
	'focusposition' => { 118 => 0x10 },
	'focusprocess' => { 103 => 0x302 },
	'focusrange' => { 2 => 0x12 },
	'focussetting' => { 129 => 0x6 },
	'focusstepcount' => { 107 => 0x100e },
	'focuswarning' => { 47 => 0x1301 },
	'foldername' => { 72 => 0x27 },
	'fontschildfontfiles' => { 149 => 'FontsChildFontFiles' },
	'fontscomposite' => { 149 => 'FontsComposite' },
	'fontsfontface' => { 149 => 'FontsFontFace' },
	'fontsfontfamily' => { 149 => 'FontsFontFamily' },
	'fontsfontfilename' => { 149 => 'FontsFontFileName' },
	'fontsfontname' => { 149 => 'FontsFontName' },
	'fontsfonttype' => { 149 => 'FontsFontType' },
	'fontsversionstring' => { 149 => 'FontsVersionString' },
	'for' => { 125 => 'For' },
	'format' => { 136 => 'format' },
	'framenum' => { 120 => 0xd7 },
	'framenumber' => { 47 => 0x8003, 118 => 0x29 },
	'freebytes' => { 34 => 0x1 },
	'freememorycardimages' => { 73 => [0x37,0x54], 74 => [0x2d,0x4a] },
	'fujiflashmode' => { 47 => 0x1010 },
	'fullsizeimage' => { 64 => 'data' },
	'fullsizeimagename' => { 64 => '1Name' },
	'fullsizeimagetype' => { 64 => '0Type' },
	'gaincontrol' => { 43 => 0xa407, 138 => 'GainControl' },
	'gamma' => { 43 => 0xa500 },
	'gammacompensatedvalue' => { 51 => 0x91 },
	'genre' => { 145 => 'genre' },
	'globalaltitude' => { 123 => 0x419 },
	'globalangle' => { 123 => 0x40d },
	'gpsaltitude' => { 48 => 0x6, 62 => 'Altitude', 138 => 'GPSAltitude' },
	'gpsaltituderef' => { 48 => 0x5, 138 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 48 => 0x1c, 138 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 48 => 0x1d },
	'gpsdatetime' => { 62 => 'DateTime' },
	'gpsdestbearing' => { 48 => 0x18, 62 => 'Bearing', 138 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 48 => 0x17, 138 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 48 => 0x1a, 62 => 'Distance', 138 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 48 => 0x19, 138 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 48 => 0x14, 138 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 48 => 0x13 },
	'gpsdestlongitude' => { 48 => 0x16, 138 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 48 => 0x15 },
	'gpsdifferential' => { 48 => 0x1e, 62 => 'Differential', 138 => 'GPSDifferential' },
	'gpsdop' => { 48 => 0xb, 138 => 'GPSDOP' },
	'gpsimgdirection' => { 48 => 0x11, 138 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 48 => 0x10, 138 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 48 => 0x2, 62 => 'Latitude', 138 => 'GPSLatitude' },
	'gpslatituderef' => { 48 => 0x1 },
	'gpslongitude' => { 48 => 0x4, 62 => 'Longitude', 138 => 'GPSLongitude' },
	'gpslongituderef' => { 48 => 0x3 },
	'gpsmapdatum' => { 48 => 0x12, 62 => 'Datum', 138 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 48 => 0xa, 62 => 'MeasureMode', 138 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 48 => 0x1b, 138 => 'GPSProcessingMethod' },
	'gpssatellites' => { 48 => 0x8, 62 => 'Satellites', 138 => 'GPSSatellites' },
	'gpsspeed' => { 48 => 0xd, 62 => 'Speed', 138 => 'GPSSpeed' },
	'gpsspeedref' => { 48 => 0xc, 138 => 'GPSSpeedRef' },
	'gpsstatus' => { 48 => 0x9, 138 => 'GPSStatus' },
	'gpstimestamp' => { 48 => 0x7, 138 => 'GPSTimeStamp' },
	'gpstrack' => { 48 => 0xf, 62 => 'Heading', 138 => 'GPSTrack' },
	'gpstrackref' => { 48 => 0xe, 138 => 'GPSTrackRef' },
	'gpsversionid' => { 48 => 0x0, 138 => 'GPSVersionID' },
	'gradation' => { 103 => 0x50f },
	'grayresponseunit' => { 43 => 0x122 },
	'greencurvelimits' => { 38 => 0x1c4 },
	'greencurvepoints' => { 38 => 0x19a },
	'greenhue' => { 135 => 'GreenHue' },
	'greensaturation' => { 135 => 'GreenSaturation' },
	'halftonehints' => { 43 => 0x141 },
	'hascrop' => { 135 => 'HasCrop' },
	'hassettings' => { 135 => 'HasSettings' },
	'headline' => { 49 => 0x69, 141 => 'Headline' },
	'highisonoisereduction' => { 21 => 0x202, 86 => 0xb1 },
	'highlight' => { 129 => 0xf },
	'highlightrecovery' => { 135 => 'HighlightRecovery' },
	'highlighttonepriority' => { 21 => 0x203 },
	'historyaction' => { 146 => 'HistoryAction' },
	'historyinstanceid' => { 146 => 'HistoryInstanceID' },
	'historyparameters' => { 146 => 'HistoryParameters' },
	'historysoftwareagent' => { 146 => 'HistorySoftwareAgent' },
	'historywhen' => { 146 => 'HistoryWhen' },
	'hometowncity' => { 118 => 0x23 },
	'hometowncitycode' => { 118 => 0x1000 },
	'hometowndst' => { 118 => 0x25 },
	'hostcomputer' => { 43 => 0x13c },
	'hue' => { 78 => 0x3b },
	'hueadjustment' => { 86 => 0x92 },
	'hueadjustmentaqua' => { 135 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 135 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 135 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 135 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 135 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 135 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 135 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 135 => 'HueAdjustmentYellow' },
	'icc_profile' => { 44 => 'ICC_Profile' },
	'iccprofilename' => { 141 => 'ICCProfile' },
	'identifier' => { 136 => 'identifier', 143 => 'Identifier' },
	'imageadjustment' => { 86 => 0x80, 91 => 0x5 },
	'imageareaoffset' => { 118 => 0x38 },
	'imageauthentication' => { 86 => 0x20 },
	'imageboundary' => { 86 => 0x16 },
	'imagecount' => { 86 => 0xa5 },
	'imagedatasize' => { 86 => 0xa2 },
	'imagedescription' => { 43 => 0x10e, 142 => 'ImageDescription' },
	'imagedustoff' => { 97 => 0xfe443a45 },
	'imageheight' => { 43 => 0x101, 77 => 0xc, 142 => 'ImageLength' },
	'imagehistory' => { 43 => 0x9213 },
	'imagenumber' => { 0 => 0xd0, 43 => 0x9211, 58 => 'ImageNumber', 73 => 0xae, 74 => 0x5e, 133 => 'ImageNumber' },
	'imagenumber2' => { 74 => 0x62 },
	'imageoptimization' => { 86 => 0xa9 },
	'imageorientation' => { 49 => 0x83 },
	'imageprocessing' => { 86 => 0x1a, 118 => 0x32 },
	'imageprocessingversion' => { 106 => 0x0 },
	'imagequality' => { 58 => 'ImageQuality', 111 => 0x1 },
	'imagequality2' => { 103 => 0x603 },
	'imagesize' => { 64 => 'ImageSize' },
	'imagesourcedata' => { 43 => 0x935c },
	'imagestabilization' => { 2 => 0x22, 40 => 0x3020, 58 => 'ImageStabilization', 73 => 0xbd, 74 => 0x71, 75 => 0x87, 76 => [0x18,0x107,0x113], 86 => 0xac },
	'imagestabilizer' => { 111 => 0x1a },
	'imagetone' => { 118 => 0x4f },
	'imagetype' => { 49 => 0x82 },
	'imageuniqueid' => { 43 => 0xa420, 138 => 'ImageUniqueID' },
	'imagewidth' => { 43 => 0x100, 77 => 0xe, 142 => 'ImageWidth' },
	'incrementaltemperature' => { 135 => 'IncrementalTemperature' },
	'incrementaltint' => { 135 => 'IncrementalTint' },
	'infinitylensstep' => { 107 => 0x103b },
	'infobuttonwhenshooting' => { 21 => 0x409 },
	'inkset' => { 43 => 0x14c },
	'instructions' => { 141 => 'Instructions' },
	'instrument' => { 145 => 'instrument' },
	'intellectualgenre' => { 139 => 'IntellectualGenre' },
	'interchangecolorspace' => { 51 => 0x40 },
	'internalflash' => { 72 => 0x2b, 105 => 0x1208 },
	'internalflashmagni' => { 116 => 0x3 },
	'internalserialnumber' => { 12 => 0x96, 47 => 0x10, 104 => 0x102, 111 => 0x25, 115 => 0x4 },
	'interopindex' => { 43 => 0x1 },
	'interopversion' => { 43 => 0x2 },
	'intervallength' => { 72 => 0x10 },
	'intervalmode' => { 72 => 0x26 },
	'intervalnumber' => { 72 => 0x11 },
	'introtime' => { 145 => 'introTime' },
	'iptc-naa' => { 43 => 0x83bb },
	'iptcbitspersample' => { 51 => 0x56 },
	'iptcimageheight' => { 51 => 0x1e },
	'iptcimagerotation' => { 51 => 0x66 },
	'iptcimagewidth' => { 51 => 0x14 },
	'iptcpicturenumber' => { 51 => 0xa },
	'iptcpixelheight' => { 51 => 0x32 },
	'iptcpixelwidth' => { 51 => 0x28 },
	'iso' => { 40 => 0x14, 43 => 0x8827, 53 => 0x60, 55 => 0x4e, 58 => 'ISO', 72 => 0x8, 86 => 0x2, 112 => 0x17, 118 => 0x14, 138 => 'ISOSpeedRatings' },
	'isoexpansion' => { 22 => 0x7, 23 => 0x8, 26 => 0x8 },
	'isoselection' => { 86 => 0xf },
	'isosetting' => { 53 => 0x5e, 58 => 'ISOSetting', 72 => 0x24, 73 => 0x26, 74 => 0x1c, 78 => 0x6, 86 => 0x13, 126 => 0x27 },
	'isospeedexpansion' => { 20 => 0x3 },
	'isospeedincrements' => { 21 => 0x102 },
	'isospeedrange' => { 21 => 0x103 },
	'isovalue' => { 107 => 0x1001 },
	'jobid' => { 49 => 0xb8 },
	'jobrefid' => { 144 => 'JobRefId' },
	'jobrefname' => { 144 => 'JobRefName' },
	'jobrefurl' => { 144 => 'JobRefUrl' },
	'jpgfromraw' => { 34 => 0x2007, 41 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 43 => [0x117,0x202] },
	'jpgfromrawstart' => { 43 => [0x111,0x201] },
	'key' => { 145 => 'key' },
	'keywords' => { 49 => 0x19, 59 => 'Keywords', 125 => 'Keywords', 140 => 'Keywords' },
	'kodakimageheight' => { 53 => 0xe, 54 => 0x70 },
	'kodakimagewidth' => { 53 => 0xc, 54 => 0x6c },
	'kodakmaker' => { 54 => 0x8 },
	'kodakmodel' => { 53 => 0x0, 54 => 0x28 },
	'label' => { 110 => 'Label', 143 => 'Label' },
	'language' => { 136 => 'language' },
	'languageidentifier' => { 49 => 0x87 },
	'lastfilenumber' => { 72 => 0x1b },
	'lastkeywordiptc' => { 132 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 132 => 'LastKeywordXMP' },
	'lasturl' => { 146 => 'LastURL' },
	'lcddisplayatpoweron' => { 25 => 0xa },
	'lcddisplayreturntoshoot' => { 26 => 0x12 },
	'lcdilluminationduringbulb' => { 21 => 0x408 },
	'lcdpanels' => { 20 => 0x8 },
	'lcheditor' => { 97 => 0x8ae85e },
	'legacyiptcdigest' => { 141 => 'LegacyIPTCDigest' },
	'lens' => { 43 => 0xfdea, 86 => 0x84, 129 => 0xa, 133 => 'Lens' },
	'lensafstopbutton' => { 19 => 0x11, 20 => 0x13, 21 => 0x506, 22 => 0x10, 23 => 0x12, 26 => 0x13, 27 => 0x9 },
	'lensaperturerange' => { 129 => 0x30 },
	'lenscoefficients' => { 117 => 0x4 },
	'lensdataversion' => { 85 => 0x0 },
	'lensdistortionparams' => { 107 => 0x206 },
	'lensdrivenoaf' => { 21 => 0x505 },
	'lensfirmwareversion' => { 104 => 0x204 },
	'lensfstops' => { 85 => 0x7, 86 => 0x8b },
	'lensid' => { 76 => 0x10c },
	'lensidnumber' => { 85 => 0x6 },
	'lensinfo' => { 133 => 'LensInfo' },
	'lensmake' => { 65 => 'Make' },
	'lensmanufacturer' => { 132 => 'LensManufacturer' },
	'lensmodel' => { 65 => 'Model', 132 => 'LensModel' },
	'lensserialnumber' => { 65 => 'SerialNumber', 104 => 0x202, 111 => 0x52 },
	'lenstemperature' => { 107 => 0x1008 },
	'lenstype' => { 0 => 0xd, 2 => 0x16, 12 => 0x95, 86 => 0x83, 104 => 0x201, 111 => 0x51, 117 => 0x0, 118 => 0x3f },
	'license' => { 134 => 'license' },
	'licensetype' => { 137 => 'licensetype' },
	'lightsource' => { 43 => 0x9208, 86 => 0x90, 138 => 'LightSource' },
	'lightsourcespecial' => { 128 => 0x21d },
	'linearresponselimit' => { 43 => 0xc62e },
	'liveviewexposuresimulation' => { 21 => 0x810 },
	'localcaption' => { 49 => 0x79 },
	'localizedcameramodel' => { 43 => 0xc615 },
	'location' => { 139 => 'Location' },
	'lockmicrophonebutton' => { 21 => 0x709 },
	'logcomment' => { 145 => 'logComment' },
	'longexposurenoisereduction' => { 21 => 0x201, 22 => 0x1, 23 => 0x2, 24 => 0x1, 25 => 0x1, 26 => 0x2, 27 => 0x1 },
	'longfocal' => { 0 => 0x14, 2 => 0x17 },
	'loop' => { 145 => 'loop' },
	'luminanceadjustmentaqua' => { 135 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 135 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 135 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 135 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 135 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 135 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 135 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 135 => 'LuminanceAdjustmentYellow' },
	'luminancesmoothing' => { 135 => 'LuminanceSmoothing' },
	'macro' => { 47 => 0x1020, 107 => 0x202, 126 => 0x21, 128 => 0x202 },
	'macromode' => { 2 => 0x1, 72 => 0xb, 103 => 0x300, 111 => 0x1c },
	'magnifiedview' => { 23 => 0x11, 25 => 0x9 },
	'make' => { 35 => 0x0, 43 => 0x10f, 58 => 'Make', 110 => 'Make', 112 => 0x10f, 142 => 'Make' },
	'makernote' => { 138 => 'MakerNote' },
	'makernotecanon' => { 42 => 'MakN', 43 => 0x927c },
	'makernotecasio' => { 42 => 'MakN', 43 => 0x927c },
	'makernotecasio2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotefujifilm' => { 42 => 'MakN', 43 => 0x927c },
	'makernotehp' => { 42 => 'MakN', 43 => 0x927c },
	'makernotehp2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotehp4' => { 42 => 'MakN', 43 => 0x927c },
	'makernotehp6' => { 42 => 'MakN', 43 => 0x927c },
	'makernotejvc' => { 42 => 'MakN', 43 => 0x927c },
	'makernotejvctext' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak1a' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak1b' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak3' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak4' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak5' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak6a' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodak6b' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekodakunknown' => { 42 => 'MakN', 43 => 0x927c },
	'makernotekyocera' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteleica' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteminolta' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteminolta2' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteminolta3' => { 42 => 'MakN', 43 => 0x927c },
	'makernotenikon' => { 42 => 'MakN', 43 => 0x927c },
	'makernotenikon2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotenikon3' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteoffset' => { 128 => 0xff },
	'makernoteolympus' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteolympus2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotepanasonic' => { 42 => 'MakN', 43 => 0x927c },
	'makernotepanasonic2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotepentax' => { 42 => 'MakN', 43 => 0x927c },
	'makernotericoh' => { 42 => 'MakN', 43 => 0x927c },
	'makernotericohtext' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesafety' => { 43 => 0xc635 },
	'makernotesanyo' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesanyoc4' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesanyopatch' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesigma' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesony' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesonysr2' => { 42 => 'MakN', 43 => 0x927c },
	'makernotesonysrf' => { 42 => 'MakN', 43 => 0x927c },
	'makernotetype' => { 127 => 0x1 },
	'makernoteunknown' => { 42 => 'MakN', 43 => 0x927c },
	'makernoteversion' => { 76 => 0x0, 86 => 0x1, 107 => 0x0, 127 => 0x2, 129 => 0x1d },
	'managedfromdocumentid' => { 146 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 146 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 146 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 146 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 146 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 146 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 146 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 146 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 146 => 'ManagedFromVersionID' },
	'manager' => { 146 => 'Manager' },
	'managervariant' => { 146 => 'ManagerVariant' },
	'manageto' => { 146 => 'ManageTo' },
	'manageui' => { 146 => 'ManageUI' },
	'manometerreading' => { 103 => 0x901 },
	'manualflash' => { 105 => 0x1209 },
	'manualfocusdistance' => { 86 => 0x85, 107 => 0x100c, 128 => 0x223 },
	'manualtv' => { 20 => 0x5, 21 => 0x705 },
	'manufacturedate' => { 115 => 0x1 },
	'marked' => { 148 => 'Marked' },
	'markerscomment' => { 145 => 'markersComment' },
	'markersduration' => { 145 => 'markersDuration' },
	'markerslocation' => { 145 => 'markersLocation' },
	'markersname' => { 145 => 'markersName' },
	'markersstarttime' => { 145 => 'markersStartTime' },
	'markerstarget' => { 145 => 'markersTarget' },
	'markerstype' => { 145 => 'markersType' },
	'maskedareas' => { 43 => 0xc68e },
	'masterdocumentid' => { 49 => 0xb9 },
	'mastergain' => { 90 => 0x50 },
	'maxaperture' => { 2 => 0x1a, 65 => 'MaxAperture', 72 => 0x17 },
	'maxapertureatcurrentfocal' => { 104 => 0x20a },
	'maxapertureatmaxfocal' => { 47 => 0x1407, 65 => 'MaxApertureAtMaxFocal', 85 => 0xb, 104 => 0x206 },
	'maxapertureatminfocal' => { 47 => 0x1406, 85 => 0xa },
	'maxaperturevalue' => { 43 => 0x9205, 138 => 'MaxApertureValue' },
	'maxfocallength' => { 47 => 0x1405, 65 => 'MaxFocalLength', 85 => 0x9, 104 => 0x208 },
	'maximumdensityrange' => { 51 => 0x8c },
	'maxpagesizeh' => { 149 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 149 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 149 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 43 => 0x119 },
	'mcuversion' => { 85 => 0xc },
	'md5digest' => { 66 => 'zmd5' },
	'measuredev' => { 18 => 0x3, 34 => 0x1814, 58 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 19 => 0xb, 22 => 0xa, 23 => 0xb, 26 => 0xb },
	'menubuttonreturn' => { 27 => 0xb },
	'metadatadate' => { 143 => 'MetadataDate' },
	'metadatamoddate' => { 145 => 'metadataModDate' },
	'meteringmode' => { 2 => 0x11, 43 => 0x9207, 53 => 0x1c, 72 => 0x7, 73 => 0x25, 103 => 0x202, 118 => 0x17, 129 => 0x9, 138 => 'MeteringMode' },
	'mieversion' => { 66 => '0Vers' },
	'minaperture' => { 2 => 0x1b, 65 => 'MinAperture' },
	'minfocallength' => { 47 => 0x1404, 65 => 'MinFocalLength', 85 => 0x8, 104 => 0x207 },
	'minoltadate' => { 72 => 0x15 },
	'minoltaimagesize' => { 72 => 0x4, 73 => 0xc, 74 => 0x2, 76 => 0x103 },
	'minoltamodelid' => { 72 => 0x25 },
	'minoltaquality' => { 72 => 0x5, 73 => 0xd, 74 => 0x3, 76 => [0x102,0x103], 107 => [0x102,0x103] },
	'minoltatime' => { 72 => 0x16 },
	'minsamplevalue' => { 43 => 0x118 },
	'mirrorlockup' => { 19 => 0xc, 20 => 0xc, 21 => 0x60f, 22 => 0xb, 23 => 0xc, 24 => 0x6, 25 => 0x6, 26 => 0xc, 27 => 0x3 },
	'moddate' => { 140 => 'ModDate' },
	'model' => { 35 => 0x6, 43 => 0x110, 58 => 'Model', 110 => 'Model', 112 => 0x110, 142 => 'Model' },
	'modelrevision' => { 115 => 0x2 },
	'modifiedcolortemp' => { 13 => 0x9 },
	'modifieddigitalgain' => { 13 => 0xb },
	'modifiedparamflag' => { 10 => 0x1 },
	'modifiedpicturestyle' => { 13 => 0xa },
	'modifiedsaturation' => { 103 => 0x504 },
	'modifiedsensorbluelevel' => { 13 => 0x5 },
	'modifiedsensorredlevel' => { 13 => 0x4 },
	'modifiedsharpness' => { 13 => 0x2 },
	'modifiedsharpnessfreq' => { 13 => 0x3 },
	'modifiedtonecurve' => { 13 => 0x1 },
	'modifiedwhitebalance' => { 13 => 0x8 },
	'modifiedwhitebalanceblue' => { 13 => 0x7 },
	'modifiedwhitebalancered' => { 13 => 0x6 },
	'modifydate' => { 43 => 0x132, 59 => 'ModifyDate', 109 => 'tIME', 125 => 'ModDate', 143 => 'ModifyDate' },
	'moirefilter' => { 43 => 0xfe58 },
	'monochromecontrast' => { 38 => 0x2ee },
	'monochromefiltereffect' => { 38 => 0x2ea },
	'monochromelinear' => { 38 => 0x2f0 },
	'monochromesharpness' => { 38 => 0x2f2 },
	'monochrometoningeffect' => { 38 => 0x2ec },
	'monthdaycreated' => { 53 => 0x12, 55 => 0xe },
	'multiexposureautogain' => { 87 => 0x3 },
	'multiexposuremode' => { 87 => 0x1 },
	'multiexposureshots' => { 87 => 0x2 },
	'multiexposureversion' => { 87 => 0x0 },
	'multisample' => { 90 => 0x40 },
	'nativedigest' => { 138 => 'NativeDigest', 142 => 'NativeDigest' },
	'ndfilter' => { 18 => 0x1c },
	'nearlensstep' => { 107 => 0x103c },
	'newsphotoversion' => { 51 => 0x0 },
	'nickname' => { 143 => 'Nickname' },
	'nikoncaptureversion' => { 86 => 0xe09 },
	'noisereduction' => { 9 => 0x8, 73 => 0xb0, 74 => 0x60, 75 => 0x3f, 86 => 0x95, 97 => 0x753dcbc0, 103 => 0x50a, 107 => 0x103a, 111 => 0x2d, 118 => 0x49 },
	'noisereduction2' => { 106 => 0x1010 },
	'noisereductionintensity' => { 98 => 0x9 },
	'noisereductionmethod' => { 98 => 0x11 },
	'noisereductionsharpness' => { 98 => 0xd },
	'npages' => { 149 => 'NPages' },
	'nullrecord' => { 34 => 0x0 },
	'numafpoints' => { 15 => 0x1 },
	'numberofbeats' => { 145 => 'numberOfBeats' },
	'numindexentries' => { 51 => 0x54 },
	'objectattributereference' => { 49 => 0x4 },
	'objectcycle' => { 49 => 0x4b },
	'objectdistance' => { 39 => 0x6, 40 => 0x2022 },
	'objectname' => { 49 => 0x5 },
	'objectpreviewdata' => { 49 => 0xca },
	'objectpreviewfileformat' => { 49 => 0xc8 },
	'objectpreviewfileversion' => { 49 => 0xc9 },
	'objecttypereference' => { 49 => 0x3 },
	'oecfcolumns' => { 138 => 'OECFColumns' },
	'oecfnames' => { 138 => 'OECFNames' },
	'oecfrows' => { 138 => 'OECFRows' },
	'oecfvalues' => { 138 => 'OECFValues' },
	'offsetschema' => { 43 => 0xea1d },
	'oldsubfiletype' => { 43 => 0xff },
	'olympusimageheight' => { 107 => 0x102f },
	'olympusimageheight2' => { 106 => 0x615 },
	'olympusimagewidth' => { 107 => 0x102e },
	'olympusimagewidth2' => { 106 => 0x614 },
	'onetouchwb' => { 107 => 0x302 },
	'opticalzoom' => { 55 => 0x1e, 65 => 'OpticalZoom' },
	'opticalzoomcode' => { 18 => 0xa },
	'opticalzoomon' => { 128 => 0x219 },
	'ordernumber' => { 47 => 0x8002 },
	'orientation' => { 43 => 0x112, 112 => 0x112, 142 => 'Orientation' },
	'originaldecisiondata' => { 12 => 0x83 },
	'originalfilename' => { 34 => 0x816, 56 => 0x20 },
	'originalimageheight' => { 46 => 0x1 },
	'originalimagewidth' => { 46 => 0x0 },
	'originalrawfiledata' => { 43 => 0xc68c },
	'originalrawfilename' => { 43 => 0xc68b },
	'originaltransmissionreference' => { 49 => 0x67 },
	'originatingprogram' => { 49 => 0x41 },
	'os' => { 137 => 'os' },
	'outcue' => { 145 => 'outCue' },
	'outputheight' => { 94 => 0xce },
	'outputheightinches' => { 94 => 0x96 },
	'outputpixels' => { 94 => 0xd6 },
	'outputresolution' => { 94 => 0xb6 },
	'outputwidth' => { 94 => 0xc6 },
	'outputwidthinches' => { 94 => 0x8e },
	'owner' => { 148 => 'Owner' },
	'ownerid' => { 49 => 0xbc },
	'ownername' => { 12 => 0x9, 34 => 0x810, 43 => 0xfde8, 58 => 'OwnerName', 133 => 'OwnerName' },
	'pagename' => { 43 => 0x11d },
	'pagenumber' => { 43 => 0x129 },
	'panasonicrawversion' => { 112 => 0x1 },
	'panoramadirection' => { 14 => 0x5 },
	'panoramaframe' => { 14 => 0x2 },
	'panoramamode' => { 53 => 0x3c, 103 => 0x601 },
	'parametricdarks' => { 135 => 'ParametricDarks' },
	'parametrichighlights' => { 135 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 135 => 'ParametricHighlightSplit' },
	'parametriclights' => { 135 => 'ParametricLights' },
	'parametricmidtonesplit' => { 135 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 135 => 'ParametricShadows' },
	'parametricshadowsplit' => { 135 => 'ParametricShadowSplit' },
	'pdfversion' => { 140 => 'PDFVersion' },
	'pentaximagesize' => { 118 => 0x9 },
	'pentaxmode' => { 118 => 0x1 },
	'pentaxmodelid' => { 115 => 0x0, 118 => 0x5 },
	'pentaxversion' => { 118 => 0x0 },
	'pf0customfuncregistration' => { 29 => 0x1 },
	'pf10retainprogramshift' => { 29 => 0xb },
	'pf13drivepriority' => { 29 => 0xe },
	'pf14disablefocussearch' => { 29 => 0xf },
	'pf15disableafassistbeam' => { 29 => 0x10 },
	'pf16autofocuspointshoot' => { 29 => 0x11 },
	'pf17disableafpointsel' => { 29 => 0x12 },
	'pf18enableautoafpointsel' => { 29 => 0x13 },
	'pf19continuousshootspeed' => { 29 => 0x14 },
	'pf19shootingspeedhigh' => { 28 => 0xa },
	'pf19shootingspeedlow' => { 28 => 0x9 },
	'pf1disableshootingmodes' => { 29 => 0x2 },
	'pf1value' => { 28 => 0x1 },
	'pf20limitcontinousshots' => { 29 => 0x15 },
	'pf20maxcontinousshots' => { 28 => 0xb },
	'pf21enablequietoperation' => { 29 => 0x16 },
	'pf23felocktime' => { 28 => 0xd },
	'pf23postreleasetime' => { 28 => 0xe },
	'pf23settimerlengths' => { 29 => 0x18 },
	'pf23shutterbuttontime' => { 28 => 0xc },
	'pf24lightlcdduringbulb' => { 29 => 0x19 },
	'pf25aemode' => { 28 => 0xf },
	'pf25afmode' => { 28 => 0x12 },
	'pf25afpointsel' => { 28 => 0x13 },
	'pf25colormatrix' => { 28 => 0x17 },
	'pf25defaultclearsettings' => { 29 => 0x1a },
	'pf25drivemode' => { 28 => 0x11 },
	'pf25imagesize' => { 28 => 0x14 },
	'pf25meteringmode' => { 28 => 0x10 },
	'pf25parameters' => { 28 => 0x16 },
	'pf25wbmode' => { 28 => 0x15 },
	'pf26shortenreleaselag' => { 29 => 0x1b },
	'pf27reversedialrotation' => { 29 => 0x1c },
	'pf27value' => { 28 => 0x18 },
	'pf28noquickdialexpcomp' => { 29 => 0x1d },
	'pf29quickdialswitchoff' => { 29 => 0x1e },
	'pf2disablemeteringmodes' => { 29 => 0x3 },
	'pf2value' => { 28 => 0x2 },
	'pf30enlargementmode' => { 29 => 0x1f },
	'pf31originaldecisiondata' => { 29 => 0x20 },
	'pf3manualexposuremetering' => { 29 => 0x4 },
	'pf3value' => { 28 => 0x3 },
	'pf4exposuretimelimits' => { 29 => 0x5 },
	'pf4exposuretimemax' => { 28 => 0x5 },
	'pf4exposuretimemin' => { 28 => 0x4 },
	'pf5aperturelimits' => { 29 => 0x6 },
	'pf5aperturemax' => { 28 => 0x7 },
	'pf5aperturemin' => { 28 => 0x6 },
	'pf6presetshootingmodes' => { 29 => 0x7 },
	'pf7bracketcontinuousshoot' => { 29 => 0x8 },
	'pf8bracketshots' => { 28 => 0x8 },
	'pf8setbracketshots' => { 29 => 0x9 },
	'pf9changebracketsequence' => { 29 => 0xa },
	'phonenumber' => { 59 => 'Phone' },
	'photoeffect' => { 2 => 0x28 },
	'photoeffects' => { 97 => 0xab5eca5e },
	'photoeffectsblue' => { 99 => 0x8 },
	'photoeffectsgreen' => { 99 => 0x6 },
	'photoeffectsred' => { 99 => 0x4 },
	'photoeffectstype' => { 99 => 0x0 },
	'photometricinterpretation' => { 43 => 0x106, 142 => 'PhotometricInterpretation' },
	'photoshopquality' => { 122 => 0x0 },
	'pictinfo' => { 128 => 0x208 },
	'picturemode' => { 47 => 0x1031, 103 => 0x520, 118 => [0xb,0x33] },
	'picturemodebwfilter' => { 103 => 0x525 },
	'picturemodecontrast' => { 103 => 0x523 },
	'picturemodehue' => { 103 => 0x522 },
	'picturemodesaturation' => { 103 => 0x521 },
	'picturemodesharpness' => { 103 => 0x524 },
	'picturemodetone' => { 103 => 0x526 },
	'picturestyle' => { 0 => 0x6c, 17 => 0xa, 38 => 0x27a },
	'planarconfiguration' => { 43 => 0x11c, 142 => 'PlanarConfiguration' },
	'platenames' => { 149 => 'PlateNames' },
	'pngwarning' => { 110 => 'Warning' },
	'postalcode' => { 63 => 'PostalCode' },
	'precaptureframes' => { 107 => 0x300 },
	'predictor' => { 43 => 0x13d },
	'prefs' => { 49 => 0xdd, 121 => 'Prefs' },
	'preservedfilename' => { 146 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 16 => 0x6 },
	'previewfocalplaneyresolution' => { 16 => 0x8 },
	'previewimage' => { 40 => 0x2000, 41 => 'PreviewImage', 42 => 'MakN', 43 => 0x927c, 45 => 0x4, 68 => 'data', 76 => 0x81, 107 => 0x280 },
	'previewimagedata' => { 118 => 0x2000 },
	'previewimageheight' => { 16 => 0x4 },
	'previewimagelength' => { 16 => 0x2, 40 => 0x3, 43 => [0x117,0x202], 76 => 0x89, 88 => 0x202, 103 => 0x102, 107 => 0x1037, 118 => 0x3, 126 => 0x1e },
	'previewimagename' => { 68 => '1Name' },
	'previewimagesize' => { 40 => 0x2, 68 => 'ImageSize', 118 => 0x2 },
	'previewimagestart' => { 16 => 0x5, 40 => 0x4, 43 => [0x111,0x201], 76 => 0x88, 88 => 0x201, 103 => 0x101, 107 => 0x1036, 118 => 0x4, 126 => 0x1c },
	'previewimagetype' => { 68 => '0Type' },
	'previewimagevalid' => { 103 => 0x100, 107 => 0x1035 },
	'previewimagewidth' => { 16 => 0x3 },
	'previewquality' => { 16 => 0x1 },
	'primarychromaticities' => { 43 => 0x13f, 142 => 'PrimaryChromaticities' },
	'printim' => { 43 => 0xc4a5 },
	'privatertkinfo' => { 131 => 'privateRTKInfo' },
	'processingsoftware' => { 43 => 0xb },
	'producer' => { 140 => 'Producer' },
	'productid' => { 50 => 0x32 },
	'productionversion' => { 111 => 0x2 },
	'programmode' => { 78 => 0x5 },
	'programshift' => { 86 => 0xd },
	'programversion' => { 49 => 0x46 },
	'projectrefpath' => { 145 => 'projectRefPath' },
	'projectreftype' => { 145 => 'projectRefType' },
	'province-state' => { 49 => 0x5f },
	'publisher' => { 136 => 'publisher' },
	'pulldown' => { 145 => 'pullDown' },
	'quality' => { 2 => 0x3, 39 => 0x2, 40 => 0x3002, 47 => 0x1000, 53 => 0x9, 86 => 0x4, 91 => 0x3, 107 => 0x201, 118 => 0x8, 129 => 0x16 },
	'qualitymode' => { 40 => 0x8 },
	'quantizationmethod' => { 51 => 0x78 },
	'quickcontroldialinmeter' => { 21 => 0x703 },
	'quickshot' => { 128 => 0x213 },
	'rasterizedcaption' => { 49 => 0x7d },
	'rating' => { 43 => 0x4746, 120 => 0xdf, 137 => 'rating', 143 => 'Rating' },
	'ratingpercent' => { 43 => 0x4749, 132 => 'Rating' },
	'rawandjpgrecording' => { 19 => 0x8 },
	'rawbrightnessadj' => { 38 => 0x38 },
	'rawcoloradj' => { 38 => 0x2e },
	'rawcolortoneadj' => { 38 => 0x290 },
	'rawcontrastadj' => { 38 => 0x294 },
	'rawcropbottom' => { 120 => 0xd4 },
	'rawcropleft' => { 120 => 0xd1 },
	'rawcropright' => { 120 => 0xd3 },
	'rawcroptop' => { 120 => 0xd2 },
	'rawcustomsaturation' => { 38 => 0x30 },
	'rawcustomtone' => { 38 => 0x34 },
	'rawdatauniqueid' => { 43 => 0xc65d },
	'rawdepth' => { 77 => 0x10 },
	'rawdevcolorspace' => { 108 => 0x108 },
	'rawdevcontrastvalue' => { 108 => 0x106 },
	'rawdeveditstatus' => { 108 => 0x10b },
	'rawdevengine' => { 108 => 0x109 },
	'rawdevexposurebiasvalue' => { 108 => 0x100 },
	'rawdevgraypoint' => { 108 => 0x103 },
	'rawdevmemorycoloremphasis' => { 108 => 0x105 },
	'rawdevnoisereduction' => { 108 => 0x10a },
	'rawdevsaturationemphasis' => { 108 => 0x104 },
	'rawdevsettings' => { 108 => 0x10c },
	'rawdevsharpnessvalue' => { 108 => 0x107 },
	'rawdevversion' => { 108 => 0x0 },
	'rawdevwbfineadjustment' => { 108 => 0x102 },
	'rawdevwhitebalancevalue' => { 108 => 0x101 },
	'rawfile' => { 43 => 0xfe4c },
	'rawfilename' => { 135 => 'RawFileName' },
	'rawhighlightpoint' => { 38 => 0x29a },
	'rawimagecenter' => { 86 => 0x99 },
	'rawimagesize' => { 118 => 0x39 },
	'rawjpgheight' => { 36 => 0x4 },
	'rawjpgquality' => { 9 => 0x6, 36 => 0x1 },
	'rawjpgsize' => { 9 => 0x7, 36 => 0x2 },
	'rawjpgwidth' => { 36 => 0x3 },
	'rawlinear' => { 38 => 0x296 },
	'rawsaturationadj' => { 38 => 0x292 },
	'rawshadowpoint' => { 38 => 0x29c },
	'rawsharpnessadj' => { 38 => 0x298 },
	'recordid' => { 34 => 0x1804 },
	'recordingmode' => { 39 => 0x1 },
	'recordmode' => { 2 => 0x9, 40 => 0x3000 },
	'recordshutterrelease' => { 128 => 0x217 },
	'redbalance' => { 107 => 0x1017, 118 => 0x1c },
	'redcurvelimits' => { 38 => 0x18a },
	'redcurvepoints' => { 38 => 0x160 },
	'redeyecorrection' => { 100 => 0x0 },
	'redhue' => { 135 => 'RedHue' },
	'redsaturation' => { 135 => 'RedSaturation' },
	'referenceblackwhite' => { 43 => 0x214, 142 => 'ReferenceBlackWhite' },
	'referencedate' => { 49 => 0x2f },
	'referencenumber' => { 49 => 0x32 },
	'references' => { 59 => 'References' },
	'referenceservice' => { 49 => 0x2d },
	'relatedaudiofile' => { 57 => 'data' },
	'relatedaudiofilename' => { 57 => '1Name' },
	'relatedaudiofiletype' => { 57 => '0Type' },
	'relatedimagefileformat' => { 43 => 0x1000 },
	'relatedimagelength' => { 43 => 0x1002 },
	'relatedimagewidth' => { 43 => 0x1001 },
	'relatedsoundfile' => { 43 => 0xa004, 138 => 'RelatedSoundFile' },
	'relatedvideofile' => { 71 => 'data' },
	'relatedvideofilename' => { 71 => '1Name' },
	'relatedvideofiletype' => { 71 => '0Type' },
	'relation' => { 136 => 'relation' },
	'relativepeakaudiofilepath' => { 145 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 145 => 'relativeTimestamp' },
	'releasedate' => { 49 => 0x1e, 145 => 'releaseDate' },
	'releasesetting' => { 34 => 0x1016 },
	'releasetime' => { 49 => 0x23 },
	'renditionclass' => { 146 => 'RenditionClass' },
	'renditionofdocumentid' => { 146 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 146 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 146 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 146 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 146 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 146 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 146 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 146 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 146 => 'RenditionOfVersionID' },
	'renditionparams' => { 146 => 'RenditionParams' },
	'resampleparamsquality' => { 145 => 'resampleParamsQuality' },
	'resaved' => { 128 => 0x21e },
	'resolution' => { 64 => 'Resolution' },
	'resolutionmode' => { 129 => 0x4 },
	'resolutionunit' => { 43 => 0x128, 52 => 0x2, 142 => 'ResolutionUnit' },
	'reuseallowed' => { 147 => 'ReuseAllowed' },
	'revision' => { 137 => 'revision' },
	'rgbcurvelimits' => { 38 => 0x238 },
	'rgbcurvepoints' => { 38 => 0x20e },
	'ricohdate' => { 126 => 0x6 },
	'ricohimageheight' => { 126 => 0x2 },
	'ricohimagewidth' => { 126 => 0x0 },
	'rightascension' => { 67 => 'RightAscension' },
	'rights' => { 136 => 'rights' },
	'romoperationmode' => { 34 => 0x80d },
	'rotation' => { 33 => 0x3, 38 => 0x26e, 46 => 0x4, 67 => 'Rotation', 73 => 0x50, 74 => 0x46, 75 => 0x5a, 97 => 0x76a43207, 111 => 0x30, 120 => 0xd8 },
	'routing' => { 125 => 'Routing' },
	'rowsperstrip' => { 43 => 0x116 },
	'safetyshift' => { 21 => 0x108 },
	'safetyshiftinavortv' => { 19 => 0x10, 20 => 0x10, 22 => 0xf, 23 => 0x10, 26 => 0x10 },
	'samplebits' => { 57 => 'SampleBits' },
	'samplerate' => { 57 => 'SampleRate' },
	'samplesperpixel' => { 43 => 0x115, 142 => 'SamplesPerPixel' },
	'samplestructure' => { 51 => 0x5a },
	'sanyoquality' => { 128 => 0x201 },
	'sanyothumbnail' => { 128 => 0x100 },
	'saturation' => { 2 => 0xe, 7 => 0x1, 39 => 0xd, 40 => [0x3013,0x1f], 43 => [0xa409,0xfe55], 47 => 0x1003, 58 => 'Saturation', 72 => 0x1f, 73 => 0x32, 74 => 0x28, 75 => 0x1a, 78 => 0x1, 86 => [0x94,0xaa], 118 => 0x1f, 126 => 0x28, 129 => 0x10, 135 => 'Saturation', 138 => 'Saturation' },
	'saturationadj' => { 38 => 0x116 },
	'saturationadjustmentaqua' => { 135 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 135 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 135 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 135 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 135 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 135 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 135 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 135 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 146 => 'SaveID' },
	'scaledresolution' => { 94 => 0x9e },
	'scaletype' => { 145 => 'scaleType' },
	'scanningdirection' => { 51 => 0x64 },
	'scene' => { 139 => 'Scene', 145 => 'scene' },
	'scenecapturetype' => { 43 => 0xa406, 138 => 'SceneCaptureType' },
	'scenemode' => { 76 => 0x100, 86 => 0x8f, 103 => 0x509 },
	'sceneselect' => { 128 => 0x21f },
	'scenetype' => { 43 => 0xa301, 138 => 'SceneType' },
	'securityclassification' => { 43 => 0x9212 },
	'selectableafpoint' => { 21 => 0x509 },
	'self-timer' => { 2 => 0x2 },
	'self-timer2' => { 18 => 0x1d },
	'selftimer' => { 40 => 0x3001, 111 => 0x2e, 128 => 0x214 },
	'selftimermode' => { 43 => 0x882b },
	'selftimertime' => { 34 => 0x1806 },
	'seminfo' => { 43 => 0x8546 },
	'sensingmethod' => { 43 => 0xa217, 138 => 'SensingMethod' },
	'sensorbluelevel' => { 17 => 0x5 },
	'sensorcleaning' => { 27 => 0xd },
	'sensorheight' => { 77 => 0x8 },
	'sensorpixelsize' => { 86 => 0x9a },
	'sensorredlevel' => { 17 => 0x4 },
	'sensorsize' => { 58 => 'SensorSize' },
	'sensortemperature' => { 105 => 0x1500, 107 => 0x1007 },
	'sensorwidth' => { 77 => 0xa },
	'sequence' => { 103 => 0x600 },
	'sequencenumber' => { 18 => 0x9, 40 => 0x301c, 47 => 0x1101, 53 => 0x1d, 111 => 0x2b },
	'sequenceshotinterval' => { 128 => 0x224 },
	'sequentialshot' => { 128 => 0x20e },
	'serialnumber' => { 12 => 0xc, 34 => 0x180b, 43 => 0xfde9, 58 => 'SerialNumber', 86 => 0xa0, 104 => 0x101, 107 => [0x404,0x101a], 129 => 0x2, 133 => 'SerialNumber' },
	'serialnumberformat' => { 12 => 0x15, 34 => 0x183b },
	'serviceidentifier' => { 50 => 0x1e },
	'setbuttoncrosskeysfunc' => { 24 => 0x0, 25 => 0x0 },
	'setbuttonfunction' => { 19 => 0x1, 27 => 0xc },
	'setbuttonwhenshooting' => { 21 => 0x704 },
	'setfunctionwhenshooting' => { 22 => 0x0, 23 => 0x1, 26 => 0x1 },
	'shadingcompensation' => { 103 => 0x50c },
	'shadingcompensation2' => { 106 => 0x1012 },
	'shadow' => { 129 => 0xe },
	'shadows' => { 43 => 0xfe52, 135 => 'Shadows' },
	'shadowscale' => { 43 => 0xc633 },
	'shadowtint' => { 135 => 'ShadowTint' },
	'shakereduction' => { 119 => 0x1 },
	'sharpness' => { 2 => 0xf, 17 => 0x2, 39 => 0xb, 40 => [0x3011,0x21], 43 => [0xa40a,0xfe56], 47 => 0x1001, 53 => 0x6b, 55 => 0x37, 58 => 'Sharpness', 72 => 0x21, 73 => 0x30, 74 => 0x26, 75 => 0x18, 78 => 0x3, 86 => 0x6, 107 => 0x100f, 118 => 0x21, 126 => 0x22, 127 => 0x1003, 129 => 0x11, 135 => 'Sharpness', 138 => 'Sharpness' },
	'sharpnessfactor' => { 107 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 17 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 103 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 58 => 'ShootingMode', 86 => 0x89, 111 => 0x1f },
	'shortdescription' => { 137 => 'shortdescription' },
	'shortdocumentid' => { 49 => 0xba },
	'shortfocal' => { 0 => 0x12, 2 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shortreleasetimelag' => { 21 => 0x80d },
	'shotdate' => { 145 => 'shotDate' },
	'shotlocation' => { 145 => 'shotLocation' },
	'shotname' => { 145 => 'shotName' },
	'shutter-aelock' => { 19 => 0x4, 22 => 0x3, 23 => 0x4, 24 => 0x3, 25 => 0x3, 26 => 0x4, 27 => 0x2 },
	'shutteraelbutton' => { 20 => 0x4 },
	'shutterbuttonafonbutton' => { 21 => 0x701 },
	'shuttercount' => { 9 => 0x1 },
	'shuttercurtainsync' => { 19 => 0xf, 20 => 0xf, 21 => 0x305, 22 => 0xe, 23 => 0xf, 24 => 0x8, 25 => 0x8, 26 => 0xf, 27 => 0x8 },
	'shuttermode' => { 53 => 0x1b },
	'shutterreleasemethod' => { 34 => 0x1010 },
	'shutterreleasenocfcard' => { 19 => 0x2, 20 => 0x2, 27 => 0xf },
	'shutterreleasetiming' => { 34 => 0x1011 },
	'shutterspeedrange' => { 21 => 0x10c },
	'shutterspeedvalue' => { 43 => 0x9201, 107 => 0x1000, 138 => 'ShutterSpeedValue' },
	'similarityindex' => { 49 => 0xe4 },
	'slowshutter' => { 18 => 0x8 },
	'slowsync' => { 47 => 0x1030 },
	'smoothingparameter1' => { 106 => 0x300 },
	'smoothingparameter2' => { 106 => 0x310 },
	'smoothingthreshold2' => { 106 => 0x610 },
	'smoothingthresholds' => { 106 => 0x600 },
	'smoothness' => { 43 => 0xfe57 },
	'software' => { 43 => 0x131, 59 => 'Software', 110 => 'Software', 129 => 0x18, 142 => 'Software' },
	'softwareversion' => { 128 => 0x207 },
	'source' => { 49 => 0x73, 110 => 'Source', 136 => 'source', 137 => 'source', 141 => 'Source' },
	'sourceresolution' => { 94 => 0xae },
	'spatialfrequencyresponsecolumns' => { 138 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 138 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 138 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 138 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 145 => 'speakerPlacement' },
	'specialinstructions' => { 49 => 0x28 },
	'specialmode' => { 107 => 0x200, 128 => 0x200 },
	'spectralsensitivity' => { 43 => 0x8824, 138 => 'SpectralSensitivity' },
	'splittoningbalance' => { 135 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 135 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 135 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 135 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 135 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 72 => 0x2d },
	'spotfocuspointy' => { 72 => 0x2e },
	'spotmeterlinktoafpoint' => { 21 => 0x107 },
	'sr_swstoswrtime' => { 119 => 0x2 },
	'srresult' => { 119 => 0x0 },
	'starttimecodetimeformat' => { 145 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 145 => 'startTimecodeTimeValue' },
	'state' => { 63 => 'State', 141 => 'State' },
	'storagemethod' => { 77 => 0x12 },
	'straightenangle' => { 97 => 0x2fc08431 },
	'stretchmode' => { 145 => 'stretchMode' },
	'sub-location' => { 49 => 0x5c },
	'subfiledata' => { 66 => 'data' },
	'subfiledirectory' => { 66 => '1Directory' },
	'subfilemimetype' => { 66 => '2MIME' },
	'subfilename' => { 66 => '1Name' },
	'subfileresource' => { 66 => 'rsrc' },
	'subfiletype' => { 43 => 0xfe, 66 => '0Type' },
	'subject' => { 125 => 'Subject', 136 => 'subject', 140 => 'Subject' },
	'subjectarea' => { 138 => 'SubjectArea' },
	'subjectcode' => { 139 => 'SubjectCode' },
	'subjectdistance' => { 43 => 0x9206, 53 => 0x3e, 138 => 'SubjectDistance' },
	'subjectdistancerange' => { 43 => 0xa40c, 138 => 'SubjectDistanceRange' },
	'subjectlocation' => { 43 => [0x9214,0xa214], 138 => 'SubjectLocation' },
	'subjectprogram' => { 72 => 0x22 },
	'subjectreference' => { 49 => 0xc },
	'subsectime' => { 43 => 0x9290 },
	'subsectimedigitized' => { 43 => 0x9292 },
	'subsectimeoriginal' => { 43 => 0x9291 },
	'superimposeddisplay' => { 19 => 0xa, 22 => 0x9, 23 => 0xa, 26 => 0xa, 27 => 0xe },
	'supplementalcategories' => { 49 => 0x14, 141 => 'SupplementalCategories' },
	'supplementaltype' => { 51 => 0x37 },
	'switchtoregisteredafpoint' => { 20 => 0x12, 21 => 0x50a },
	'tagged' => { 120 => 0xdd },
	'tapename' => { 145 => 'tapeName' },
	'targetaperture' => { 18 => 0x4 },
	'targetcompressionratio' => { 32 => 0x1 },
	'targetdistancesetting' => { 34 => 0x1807 },
	'targetexposuretime' => { 18 => 0x5 },
	'targetimagetype' => { 34 => 0x100a },
	'temperature' => { 135 => 'Temperature' },
	'tempo' => { 145 => 'tempo' },
	'thresholding' => { 43 => 0x107 },
	'thumbnailfilename' => { 34 => 0x817 },
	'thumbnailimage' => { 34 => 0x2008, 41 => 'ThumbnailImage', 45 => 0x3, 69 => 'data', 107 => 0x100 },
	'thumbnailimagename' => { 69 => '1Name' },
	'thumbnailimagesize' => { 69 => 'ImageSize' },
	'thumbnailimagetype' => { 69 => '0Type' },
	'thumbnaillength' => { 43 => 0x202 },
	'thumbnailoffset' => { 43 => 0x201 },
	'thumbnailsformat' => { 143 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 143 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 143 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 143 => 'ThumbnailsWidth' },
	'tilelength' => { 43 => 0x143 },
	'tilewidth' => { 43 => 0x142 },
	'time' => { 118 => 0x7 },
	'timecreated' => { 49 => 0x3c, 53 => 0x14, 55 => 0x10, 121 => 'TimeCreated' },
	'timerlength' => { 21 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 145 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 145 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 145 => 'timeScaleParamsQuality' },
	'timesent' => { 50 => 0x50 },
	'timesignature' => { 145 => 'timeSignature' },
	'timestamp' => { 0 => 0x11c, 110 => 'TimeStamp' },
	'timezone' => { 40 => 0x3006 },
	'timezonecode' => { 37 => 0x1 },
	'timezoneinfo' => { 37 => 0x2 },
	'timezoneoffset' => { 43 => 0x882a },
	'tint' => { 135 => 'Tint' },
	'title' => { 59 => 'Title', 110 => 'Title', 125 => 'Title', 136 => 'title', 140 => 'Title' },
	'tonecomp' => { 86 => 0x81 },
	'tonecurve' => { 17 => 0x1, 118 => 0x402, 135 => 'ToneCurve' },
	'tonecurveactive' => { 38 => 0x110 },
	'tonecurvename' => { 135 => 'ToneCurveName' },
	'tonecurveproperty' => { 38 => 0x3c },
	'tonecurves' => { 118 => 0x403 },
	'toningeffect' => { 9 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 53 => 0x62 },
	'tracknumber' => { 145 => 'trackNumber' },
	'trailersignature' => { 66 => 'zmie' },
	'transferfunction' => { 142 => 'TransferFunction' },
	'transmissionreference' => { 141 => 'TransmissionReference' },
	'travelday' => { 111 => 0x36 },
	'ttl_da_adown' => { 116 => 0x5 },
	'ttl_da_aup' => { 116 => 0x4 },
	'ttl_da_bdown' => { 116 => 0x7 },
	'ttl_da_bup' => { 116 => 0x6 },
	'tvvalue' => { 30 => 0x1 },
	'type' => { 136 => 'type' },
	'uniquecameramodel' => { 43 => 0xc614 },
	'uniquedocumentid' => { 49 => 0xbb },
	'uniqueobjectname' => { 50 => 0x64 },
	'unknowncompensation' => { 129 => 0xc },
	'unsharp1color' => { 101 => 0x13 },
	'unsharp1halowidth' => { 101 => 0x19 },
	'unsharp1intensity' => { 101 => 0x17 },
	'unsharp1threshold' => { 101 => 0x1b },
	'unsharp2color' => { 101 => 0x2e },
	'unsharp2halowidth' => { 101 => 0x34 },
	'unsharp2intensity' => { 101 => 0x32 },
	'unsharp2threshold' => { 101 => 0x36 },
	'unsharp3color' => { 101 => 0x49 },
	'unsharp3halowidth' => { 101 => 0x4f },
	'unsharp3intensity' => { 101 => 0x4d },
	'unsharp3threshold' => { 101 => 0x51 },
	'unsharp4color' => { 101 => 0x64 },
	'unsharp4halowidth' => { 101 => 0x6a },
	'unsharp4intensity' => { 101 => 0x68 },
	'unsharp4threshold' => { 101 => 0x6c },
	'unsharpcount' => { 101 => 0x0 },
	'unsharpmask' => { 97 => 0x76a43200 },
	'urgency' => { 49 => 0xa, 141 => 'Urgency' },
	'url' => { 59 => 'URL', 110 => 'URL', 123 => 0x40b },
	'usablemeteringmodes' => { 21 => 0x10a },
	'usableshootingmodes' => { 21 => 0x109 },
	'usageterms' => { 148 => 'UsageTerms' },
	'usercomment' => { 34 => 0x805, 43 => 0x9286, 138 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 20 => 0x7, 21 => 0x501 },
	'utmeasting' => { 70 => 'Easting' },
	'utmmapdatum' => { 70 => 'Datum' },
	'utmnorthing' => { 70 => 'Northing' },
	'utmzone' => { 70 => 'Zone' },
	'validbits' => { 106 => 0x611, 107 => 0x102c },
	'variousmodes' => { 53 => 0x26 },
	'variousmodes2' => { 53 => 0x3a },
	'variprogram' => { 86 => 0xab },
	'version' => { 47 => 0x0, 125 => 'Version', 135 => 'Version' },
	'versionid' => { 146 => 'VersionID' },
	'versionscomments' => { 146 => 'VersionsComments' },
	'versionseventaction' => { 146 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 146 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 146 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 146 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 146 => 'VersionsEventWhen' },
	'versionsmodifier' => { 146 => 'VersionsModifier' },
	'versionsmodifydate' => { 146 => 'VersionsModifyDate' },
	'versionsversion' => { 146 => 'VersionsVersion' },
	'vibrance' => { 135 => 'Vibrance' },
	'videoalphamode' => { 145 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 145 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 145 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 145 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 145 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 145 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 145 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 145 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 145 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 145 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 145 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 145 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 145 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 145 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 145 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 145 => 'videoColorSpace' },
	'videocompressor' => { 145 => 'videoCompressor' },
	'videofieldorder' => { 145 => 'videoFieldOrder' },
	'videoframerate' => { 145 => 'videoFrameRate' },
	'videoframesizeh' => { 145 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 145 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 145 => 'videoFrameSizeW' },
	'videomoddate' => { 145 => 'videoModDate' },
	'videopixelaspectratio' => { 145 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 145 => 'videoPixelDepth' },
	'viewinfoduringexposure' => { 21 => 0x407 },
	'vignetteamount' => { 135 => 'VignetteAmount' },
	'vignettecontrol' => { 97 => 0x76a43205 },
	'vignettecontrolintensity' => { 97 => 0xac6bd5c0 },
	'vignettemidpoint' => { 135 => 'VignetteMidpoint' },
	'voicememo' => { 128 => 0x216 },
	'wb_bluelevel' => { 112 => 0x26 },
	'wb_greenlevel' => { 112 => 0x25 },
	'wb_rbgglevels' => { 81 => 0x0 },
	'wb_rblevels' => { 106 => 0x100 },
	'wb_redlevel' => { 112 => 0x24 },
	'wb_rgbglevels' => { 83 => 0x0 },
	'wb_rggblevels' => { 82 => 0x0 },
	'wb_rggblevelsasshot' => { 4 => 0x19, 5 => 0x18, 6 => 0x3f },
	'wb_rggblevelsauto' => { 3 => 0x0, 4 => 0x1e, 5 => 0x22, 6 => 0x44 },
	'wb_rggblevelscloudy' => { 3 => 0xc, 4 => 0x2d, 5 => 0x31, 6 => 0x58, 118 => 0x20f },
	'wb_rggblevelscustom' => { 3 => 0x1c, 6 => 0x80 },
	'wb_rggblevelscustom1' => { 4 => 0x41 },
	'wb_rggblevelscustom2' => { 4 => 0x46 },
	'wb_rggblevelsdaylight' => { 3 => 0x4, 4 => 0x23, 5 => 0x27, 6 => 0x4e, 118 => 0x20d },
	'wb_rggblevelsflash' => { 3 => 0x18, 4 => 0x3c, 5 => 0x45, 6 => 0x6c, 118 => 0x214 },
	'wb_rggblevelsfluorescent' => { 3 => 0x14, 4 => 0x37, 5 => 0x3b, 6 => 0x62 },
	'wb_rggblevelsfluorescentd' => { 118 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 118 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 118 => 0x213 },
	'wb_rggblevelskelvin' => { 3 => 0x20, 5 => 0x40, 6 => 0x67 },
	'wb_rggblevelsmeasured' => { 6 => 0x49 },
	'wb_rggblevelspc1' => { 5 => 0x90, 6 => 0x71 },
	'wb_rggblevelspc2' => { 5 => 0x95, 6 => 0x76 },
	'wb_rggblevelspc3' => { 5 => 0x9a, 6 => 0x7b },
	'wb_rggblevelsshade' => { 3 => 0x8, 4 => 0x28, 5 => 0x2c, 6 => 0x53, 118 => 0x20e },
	'wb_rggblevelstungsten' => { 3 => 0x10, 4 => 0x32, 5 => 0x36, 6 => 0x5d, 118 => 0x210 },
	'wb_rggblevelsunknown' => { 5 => 0x1d },
	'wb_rggblevelsunknown10' => { 5 => 0x72 },
	'wb_rggblevelsunknown11' => { 5 => 0x77 },
	'wb_rggblevelsunknown12' => { 5 => 0x7c },
	'wb_rggblevelsunknown13' => { 5 => 0x81 },
	'wb_rggblevelsunknown14' => { 5 => 0x86 },
	'wb_rggblevelsunknown15' => { 5 => 0x8b },
	'wb_rggblevelsunknown16' => { 5 => 0x9f },
	'wb_rggblevelsunknown2' => { 5 => 0x4a },
	'wb_rggblevelsunknown3' => { 5 => 0x4f },
	'wb_rggblevelsunknown4' => { 5 => 0x54 },
	'wb_rggblevelsunknown5' => { 5 => 0x59 },
	'wb_rggblevelsunknown6' => { 5 => 0x5e },
	'wb_rggblevelsunknown7' => { 5 => 0x63 },
	'wb_rggblevelsunknown8' => { 5 => 0x68 },
	'wb_rggblevelsunknown9' => { 5 => 0x6d },
	'wbadjbluebalance' => { 102 => 0x8 },
	'wbadjcolortemp' => { 38 => 0x1a },
	'wbadjlighting' => { 102 => 0x15 },
	'wbadjmode' => { 102 => 0x10 },
	'wbadjredbalance' => { 102 => 0x0 },
	'wbadjrgblevels' => { 38 => 0x8 },
	'wbadjtemperature' => { 102 => 0x18 },
	'wbbracketmode' => { 9 => 0x9 },
	'wbbracketvalueab' => { 9 => 0xc },
	'wbbracketvaluegm' => { 9 => 0xd },
	'wbfinetuneactive' => { 38 => 0x24 },
	'wbfinetunesaturation' => { 38 => 0x28 },
	'wbfinetunetone' => { 38 => 0x2c },
	'wblevels' => { 79 => 0x4 },
	'wbmediaimagesizesetting' => { 21 => 0x708 },
	'wbmode' => { 78 => 0x4, 107 => 0x1015 },
	'wbscale' => { 79 => 0x0 },
	'wbshiftab' => { 17 => 0xc },
	'wbshiftgm' => { 17 => 0xd },
	'webstatement' => { 148 => 'WebStatement' },
	'whitebalance' => { 17 => 0x8, 18 => 0x7, 39 => 0x7, 40 => [0x19,0x2012], 43 => [0xa403,0xfe4e], 47 => 0x1002, 53 => 0x40, 72 => 0x3, 73 => 0xe, 74 => 0x4, 75 => 0xb, 86 => 0x5, 91 => 0x7, 111 => 0x3, 118 => 0x19, 126 => 0x26, 129 => [0x3c,0x7], 135 => 'WhiteBalance', 138 => 'WhiteBalance' },
	'whitebalance2' => { 103 => 0x500 },
	'whitebalanceadj' => { 38 => 0x18, 97 => 0x76a43204 },
	'whitebalancebias' => { 40 => 0x2011, 111 => 0x23 },
	'whitebalanceblue' => { 17 => 0x7 },
	'whitebalancebracket' => { 103 => 0x502 },
	'whitebalancefinetune' => { 86 => 0xb },
	'whitebalancemode' => { 118 => 0x1a },
	'whitebalancered' => { 17 => 0x6 },
	'whitebalancetemperature' => { 103 => 0x501 },
	'whitepoint' => { 43 => 0x13e, 118 => 0x201, 142 => 'WhitePoint' },
	'widefocuszone' => { 72 => 0x2f },
	'widerange' => { 128 => 0x20f },
	'workcolorspace' => { 38 => 0x270 },
	'worldtimelocation' => { 118 => 0x22 },
	'writer-editor' => { 49 => 0x7a },
	'x3filllight' => { 129 => 0x12 },
	'xmp' => { 44 => 'XMP' },
	'xpauthor' => { 43 => 0x9c9d },
	'xpcomment' => { 43 => 0x9c9c },
	'xpkeywords' => { 43 => 0x9c9e },
	'xposition' => { 43 => 0x11e },
	'xpsubject' => { 43 => 0x9c9f },
	'xptitle' => { 43 => 0x9c9b },
	'xresolution' => { 43 => 0x11a, 52 => 0x3, 124 => 0x0, 142 => 'XResolution' },
	'xyresolution' => { 46 => 0x3 },
	'ycbcrcoefficients' => { 43 => 0x211, 142 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 43 => 0x213, 142 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 43 => 0x212, 142 => 'YCbCrSubSampling' },
	'yearcreated' => { 53 => 0x10, 55 => 0xc },
	'yposition' => { 43 => 0x11f },
	'yresolution' => { 43 => 0x11b, 52 => 0x5, 124 => 0x4, 142 => 'YResolution' },
	'zonematching' => { 76 => 0x10a, 78 => 0x3a },
	'zonematchingon' => { 74 => 0x75 },
	'zoomsourcewidth' => { 2 => 0x24 },
	'zoomstepcount' => { 105 => 0x300, 107 => 0x100d },
	'zoomtargetwidth' => { 2 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'abstract' => 1,
	'adobe' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afaperture' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afpointsused1d' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationnotes' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blacklevel2' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canoncamerainfo' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonvrd' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmcontrast' => 1,
	'cmexposurecompensation' => 1,
	'cmhue' => 1,
	'cmmflags' => 1,
	'cmsaturation' => 1,
	'cmsharpness' => 1,
	'cmwhitebalance' => 1,
	'cmwhitebalancecomp' => 1,
	'cmwhitebalancegraypoint' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringvalues' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions1dmkiii' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'dinf' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'dynamicrangeoptimizer' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exitpupilposition' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'finalimageheight' => 1,
	'finalimagewidth' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'http-equiv' => 1,
	'huesetting' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kbytesize' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'people' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationsetting' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validpixeldepth' => 1,
	'vary' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoformat' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vr_0x66' => 1,
	'vr_0x82' => 1,
	'vrdversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grbglevels' => 1,
	'wb_rblevelsauto' => 1,
	'wb_rblevelscloudy' => 1,
	'wb_rblevelscoolwhitefluor' => 1,
	'wb_rblevelsdaylightfluor' => 1,
	'wb_rblevelsdaywhitefluor' => 1,
	'wb_rblevelseveningsunlight' => 1,
	'wb_rblevelsfineweather' => 1,
	'wb_rblevelsshade' => 1,
	'wb_rblevelstungsten' => 1,
	'wb_rblevelsused' => 1,
	'wb_rblevelswhitefluorescent' => 1,
	'wbadjdata' => 1,
	'whitebalancecomp' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2007, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
