-- This file is autogenerated by the Rail schema generator, using
-- the schema defined in db/migration/*.rb
--
-- Do not edit this file.  Instead, add a new migration using
-- ./script/generate migration <name>, and then run
-- ./script/generate schema

-- tables 

CREATE TABLE articles_categories (
  [article_id] int,
  [category_id] int,
  [is_primary] int
);

CREATE TABLE articles_tags (
  [article_id] int,
  [tag_id] int
);

CREATE TABLE blacklist_patterns (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [type] varchar(255),
  [pattern] varchar(255)
);

CREATE TABLE blogs (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [settings] text,
  [base_url] varchar(255)
);

CREATE TABLE categories (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [name] varchar(255),
  [position] int,
  [permalink] varchar(255)
);

CREATE TABLE contents (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [type] varchar(255),
  [title] varchar(255),
  [author] varchar(255),
  [body] text,
  [extended] text,
  [excerpt] text,
  [keywords] varchar(255),
  [created_at] datetime,
  [updated_at] datetime,
  [user_id] int,
  [permalink] varchar(255),
  [guid] varchar(255),
  [text_filter_id] int,
  [whiteboard] text,
  [article_id] int,
  [email] varchar(255),
  [url] varchar(255),
  [ip] varchar(40),
  [blog_name] varchar(255),
  [name] varchar(255),
  [published] bit DEFAULT 0,
  [allow_pings] bit,
  [allow_comments] bit,
  [blog_id] int NOT NULL,
  [published_at] datetime,
  [state] text,
  [status_confirmed] bit
);

CREATE TABLE notifications (
  [notify_user_id] int,
  [notify_content_id] int,
  [created_at] datetime,
  [updated_at] datetime
);

CREATE TABLE page_caches (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [name] varchar(255)
);

CREATE TABLE pings (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [article_id] int,
  [url] varchar(255),
  [created_at] datetime
);

CREATE TABLE redirects (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [from_path] varchar(255),
  [to_path] varchar(255)
);

CREATE TABLE resources (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [size] int,
  [filename] varchar(255),
  [mime] varchar(255),
  [created_at] datetime,
  [updated_at] datetime,
  [article_id] int,
  [itunes_metadata] bit,
  [itunes_author] varchar(255),
  [itunes_subtitle] varchar(255),
  [itunes_duration] int,
  [itunes_summary] text,
  [itunes_keywords] varchar(255),
  [itunes_category] varchar(255),
  [itunes_explicit] bit
);

CREATE TABLE sessions (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [sessid] varchar(255),
  [data] text,
  [created_at] datetime,
  [updated_at] datetime
);

CREATE TABLE sidebars (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [controller] varchar(255),
  [active_position] int,
  [config] text,
  [staged_position] int
);

CREATE TABLE tags (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [name] varchar(255),
  [created_at] datetime,
  [updated_at] datetime,
  [display_name] varchar(255)
);

CREATE TABLE text_filters (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [name] varchar(255),
  [description] varchar(255),
  [markup] varchar(255),
  [filters] text,
  [params] text
);

CREATE TABLE triggers (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [pending_item_id] int,
  [pending_item_type] varchar(255),
  [due_at] datetime,
  [trigger_method] varchar(255)
);

CREATE TABLE users (
  [id] int NOT NULL IDENTITY(1,
  1) PRIMARY KEY,
  [login] varchar(255),
  [password] varchar(255),
  [email] text,
  [name] text,
  [notify_via_email] bit,
  [notify_on_new_articles] bit,
  [notify_on_comments] bit,
  [notify_watch_my_articles] bit,
  [notify_via_jabber] bit,
  [jabber] varchar(255)
);


-- indexes 

CREATE  INDEX [blacklist_patterns_pattern_index] ON blacklist_patterns ([pattern]);
CREATE  INDEX [categories_permalink_index] ON categories ([permalink]);
CREATE  INDEX [contents_blog_id_index] ON contents ([blog_id]);
CREATE  INDEX [contents_article_id_index] ON contents ([article_id]);
CREATE  INDEX [page_caches_name_index] ON page_caches ([name]);
CREATE  INDEX [pings_article_id_index] ON pings ([article_id]);
CREATE  INDEX [sessions_sessid_index] ON sessions ([sessid]);

-- data 

INSERT INTO sidebars ([config], [staged_position], [active_position], [controller]) VALUES(NULL, NULL, 0, 'category');
INSERT INTO sidebars ([config], [staged_position], [active_position], [controller]) VALUES(NULL, NULL, 1, 'static');
INSERT INTO sidebars ([config], [staged_position], [active_position], [controller]) VALUES(NULL, NULL, 2, 'xml');
INSERT INTO text_filters ([name], [filters], [description], [params], [markup]) VALUES('none', '--- []

', 'None', '--- {}

', 'none');
INSERT INTO text_filters ([name], [filters], [description], [params], [markup]) VALUES('markdown', '--- []

', 'Markdown', '--- {}

', 'markdown');
INSERT INTO text_filters ([name], [filters], [description], [params], [markup]) VALUES('smartypants', '--- 
- :smartypants
', 'SmartyPants', '--- {}

', 'none');
INSERT INTO text_filters ([name], [filters], [description], [params], [markup]) VALUES('markdown smartypants', '--- 
- :smartypants
', 'Markdown with SmartyPants', '--- {}

', 'markdown');
INSERT INTO text_filters ([name], [filters], [description], [params], [markup]) VALUES('textile', '--- []

', 'Textile', '--- {}

', 'textile');

-- schema version meta-info 

CREATE TABLE schema_info (
  [version] int
);

insert into schema_info (version) values (53);
