-- Adjust this setting to control where the objects get created.
BEGIN;
SET search_path = public;


-- Register the functions.
CREATE OR REPLACE FUNCTION pg_freespacemap_pages()
RETURNS SETOF RECORD
AS '$libdir/pg_freespacemap', 'pg_freespacemap_pages'
LANGUAGE C;

CREATE OR REPLACE FUNCTION pg_freespacemap_relations()
RETURNS SETOF RECORD
AS '$libdir/pg_freespacemap', 'pg_freespacemap_relations'
LANGUAGE C;


-- Create views for convenient access.
CREATE VIEW pg_freespacemap_pages AS
	SELECT P.* FROM pg_freespacemap_pages() AS P
	(reltablespace oid,
	 reldatabase oid,
	 relfilenode oid,
	 relblocknumber bigint,
	 bytes integer);
 
CREATE VIEW pg_freespacemap_relations AS
	SELECT P.* FROM pg_freespacemap_relations() AS P
	(reltablespace oid,
	 reldatabase oid,
	 relfilenode oid,
	 avgrequest integer,
	 interestingpages integer,
	 storedpages integer,
	 nextpage integer);

 
-- Don't want these to be available to public.
REVOKE ALL ON FUNCTION pg_freespacemap_pages() FROM PUBLIC;
REVOKE ALL ON pg_freespacemap_pages FROM PUBLIC;

REVOKE ALL ON FUNCTION pg_freespacemap_relations() FROM PUBLIC;
REVOKE ALL ON pg_freespacemap_relations FROM PUBLIC;

COMMIT;
